/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.upload;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.upload.FtpUploader;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class FtpUploaderValidator
extends Validator {
    public static void validateFtpUploader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, FtpUploader> ftp = context.getModel().getUpload().getFtp();
        if (!ftp.isEmpty()) {
            context.getLogger().debug("upload.ftp");
        }
        for (Map.Entry<String, FtpUploader> e : ftp.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig()) continue;
            FtpUploaderValidator.validateFtp(context, mode, e.getValue(), errors);
        }
    }

    private static void validateFtp(JReleaserContext context, JReleaserContext.Mode mode, FtpUploader ftp, Errors errors) {
        context.getLogger().debug("upload.ftp.{}", new Object[]{ftp.getName()});
        if (!ftp.isActiveSet()) {
            ftp.setActive(Active.NEVER);
        }
        if (!ftp.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!(ftp.isArtifacts() || ftp.isFiles() || ftp.isSignatures())) {
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            ftp.disable();
            return;
        }
        ftp.setUsername(FtpUploaderValidator.checkProperty(context, "FTP_" + Env.toVar((String)ftp.getName()) + "_USERNAME", "ftp.username", ftp.getUsername(), errors, context.isDryrun()));
        ftp.setPassword(FtpUploaderValidator.checkProperty(context, "FTP_" + Env.toVar((String)ftp.getName()) + "_PASSWORD", "ftp.password", ftp.getPassword(), errors, context.isDryrun()));
        ftp.setHost(FtpUploaderValidator.checkProperty(context, "FTP_" + Env.toVar((String)ftp.getName()) + "_HOST", "ftp.host", ftp.getHost(), errors, context.isDryrun()));
        ftp.setPort(FtpUploaderValidator.checkProperty(context, "FTP_" + Env.toVar((String)ftp.getName()) + "_PORT", "ftp.port", ftp.getPort(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)ftp.getPath())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"ftp." + ftp.getName() + ".path"}));
        }
        FtpUploaderValidator.validateTimeout(ftp);
    }
}

