/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.announce;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.announce.Announcer;
import org.jreleaser.model.internal.announce.AbstractAnnouncer;
import org.jreleaser.model.internal.announce.HttpAnnouncer;

public final class HttpAnnouncers
extends AbstractAnnouncer<HttpAnnouncers, org.jreleaser.model.api.announce.HttpAnnouncers> {
    private final Map<String, HttpAnnouncer> httpAnnouncers = new LinkedHashMap<String, HttpAnnouncer>();
    private final org.jreleaser.model.api.announce.HttpAnnouncers immutable = new org.jreleaser.model.api.announce.HttpAnnouncers(){
        private Map<String, ? extends org.jreleaser.model.api.announce.HttpAnnouncer> httpAnnouncers;

        public String getType() {
            return "http";
        }

        public Map<String, ? extends org.jreleaser.model.api.announce.HttpAnnouncer> getHttpAnnouncers() {
            if (null == this.httpAnnouncers) {
                this.httpAnnouncers = HttpAnnouncers.this.httpAnnouncers.values().stream().map(HttpAnnouncer::asImmutable).collect(Collectors.toMap(Announcer::getName, Function.identity()));
            }
            return this.httpAnnouncers;
        }

        public String getName() {
            return HttpAnnouncers.this.name;
        }

        public boolean isSnapshotSupported() {
            return HttpAnnouncers.this.isSnapshotSupported();
        }

        public Active getActive() {
            return HttpAnnouncers.this.active;
        }

        public boolean isEnabled() {
            return HttpAnnouncers.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(HttpAnnouncers.this.asMap(full));
        }

        public String getPrefix() {
            return HttpAnnouncers.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(HttpAnnouncers.this.extraProperties);
        }

        public Integer getConnectTimeout() {
            return HttpAnnouncers.this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return HttpAnnouncers.this.readTimeout;
        }
    };

    public HttpAnnouncers() {
        super("http");
    }

    @Override
    public org.jreleaser.model.api.announce.HttpAnnouncers asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(HttpAnnouncers source) {
        super.merge(source);
        this.setHttpAnnouncers(this.mergeModel(this.httpAnnouncers, source.httpAnnouncers));
    }

    public List<HttpAnnouncer> getActiveHttpAnnouncers() {
        return this.httpAnnouncers.values().stream().filter(AbstractAnnouncer::isEnabled).collect(Collectors.toList());
    }

    public Map<String, HttpAnnouncer> getHttpAnnouncers() {
        return this.httpAnnouncers;
    }

    public void setHttpAnnouncers(Map<String, HttpAnnouncer> https) {
        this.httpAnnouncers.clear();
        this.httpAnnouncers.putAll(https);
    }

    public void addHttpAnnouncer(HttpAnnouncer http) {
        this.httpAnnouncers.put(http.getName(), http);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        this.asMap(full, props);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.getName(), props);
        return map;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        this.httpAnnouncers.values().stream().filter(h -> full || h.isEnabled()).map(d -> d.asMap(full)).forEach(props::putAll);
    }
}

