/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.announce;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.AbstractAnnouncer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public final class WebhookAnnouncer
extends AbstractAnnouncer<WebhookAnnouncer, org.jreleaser.model.api.announce.WebhookAnnouncer> {
    private String webhook;
    private String message;
    private String messageProperty;
    private String messageTemplate;
    private final org.jreleaser.model.api.announce.WebhookAnnouncer immutable = new org.jreleaser.model.api.announce.WebhookAnnouncer(){

        public String getType() {
            return "webhooks";
        }

        public String getWebhook() {
            return WebhookAnnouncer.this.webhook;
        }

        public String getMessage() {
            return WebhookAnnouncer.this.message;
        }

        public String getMessageProperty() {
            return WebhookAnnouncer.this.messageProperty;
        }

        public String getMessageTemplate() {
            return WebhookAnnouncer.this.messageTemplate;
        }

        public String getName() {
            return WebhookAnnouncer.this.name;
        }

        public boolean isSnapshotSupported() {
            return WebhookAnnouncer.this.isSnapshotSupported();
        }

        public Active getActive() {
            return WebhookAnnouncer.this.active;
        }

        public boolean isEnabled() {
            return WebhookAnnouncer.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(WebhookAnnouncer.this.asMap(full));
        }

        public String getPrefix() {
            return WebhookAnnouncer.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(WebhookAnnouncer.this.extraProperties);
        }

        public Integer getConnectTimeout() {
            return WebhookAnnouncer.this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return WebhookAnnouncer.this.readTimeout;
        }
    };

    public WebhookAnnouncer() {
        super("");
    }

    @Override
    public org.jreleaser.model.api.announce.WebhookAnnouncer asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(WebhookAnnouncer source) {
        super.merge(source);
        this.name = this.merge(this.name, source.name);
        this.webhook = this.merge(this.webhook, source.webhook);
        this.message = this.merge(this.message, source.message);
        this.messageTemplate = this.merge(this.messageTemplate, source.messageTemplate);
        this.messageProperty = this.merge(this.messageProperty, source.messageProperty);
    }

    public String getResolvedMessage(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.message, props);
    }

    public String getResolvedMessageTemplate(JReleaserContext context, Map<String, Object> extraProps) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("tagName", context.getModel().getRelease().getReleaser().getEffectiveTagName(context.getModel()));
        props.putAll(extraProps);
        Path templatePath = context.getBasedir().resolve(this.messageTemplate);
        try {
            BufferedReader reader = Files.newBufferedReader(templatePath);
            return MustacheUtils.applyTemplate((Reader)reader, props);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
        }
    }

    public String getResolvedWebhook() {
        return Env.env((String)(Env.toVar((String)this.name) + "_WEBHOOK"), (String)this.webhook);
    }

    @Override
    public String getPrefix() {
        return "webhook";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getWebhook() {
        return this.webhook;
    }

    public void setWebhook(String webhook) {
        this.webhook = webhook;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessageProperty() {
        return this.messageProperty;
    }

    public void setMessageProperty(String messageProperty) {
        this.messageProperty = messageProperty;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("webhook", StringUtils.isNotBlank((String)this.getResolvedWebhook()) ? "************" : "**unset**");
        props.put("message", this.message);
        props.put("messageProperty", this.messageProperty);
        props.put("messageTemplate", this.messageTemplate);
    }
}

