/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.MastodonAnnouncer;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class MastodonAnnouncerValidator
extends Validator {
    public static void validateMastodon(JReleaserContext context, MastodonAnnouncer mastodon, Errors errors) {
        context.getLogger().debug("announce.mastodon");
        if (!mastodon.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((String)mastodon.getHost())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"mastodon.host"}));
        }
        mastodon.setAccessToken(MastodonAnnouncerValidator.checkProperty(context, "MASTODON_ACCESS_TOKEN", "mastodon.accessToken", mastodon.getAccessToken(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)mastodon.getStatus())) {
            mastodon.setStatus(RB.$((String)"default.release.message", (Object[])new Object[0]));
        }
        MastodonAnnouncerValidator.validateTimeout(mastodon);
    }
}

