/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.signing;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.bouncycastle.openpgp.PGPException;
import org.jreleaser.model.api.signing.Keyring;

public final class FilesKeyring
extends Keyring {
    private final Path publicKeyring;
    private final Path secretKeyring;

    public FilesKeyring(Path publicKeyring, Path secretKeyring) throws IOException, PGPException {
        this.publicKeyring = publicKeyring;
        this.secretKeyring = secretKeyring;
    }

    protected InputStream getPublicKeyRingStream() throws IOException {
        return Files.newInputStream(this.publicKeyring, new OpenOption[0]);
    }

    protected InputStream getSecretKeyRingStream() throws IOException {
        return Files.newInputStream(this.secretKeyring, new OpenOption[0]);
    }
}

