/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.github;

import feign.form.FormData;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.deploy.DeployException;
import org.jreleaser.model.spi.upload.UploadException;
import org.jreleaser.sdk.commons.AbstractMavenDeployer;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.github.XGithub;
import org.jreleaser.sdk.github.api.GhPackageVersion;

public class GithubMavenDeployer
extends AbstractMavenDeployer<org.jreleaser.model.api.deploy.maven.GithubMavenDeployer, org.jreleaser.model.internal.deploy.maven.GithubMavenDeployer> {
    private org.jreleaser.model.internal.deploy.maven.GithubMavenDeployer deployer;

    public GithubMavenDeployer(JReleaserContext context) {
        super(context);
    }

    public org.jreleaser.model.internal.deploy.maven.GithubMavenDeployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(org.jreleaser.model.internal.deploy.maven.GithubMavenDeployer deployer) {
        this.deployer = deployer;
    }

    public String getType() {
        return "github";
    }

    public void deploy(String name) throws DeployException {
        Set deployables = this.collectDeployables();
        if (deployables.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"artifacts.no.match", (Object[])new Object[0]));
        }
        String baseUrl = this.deployer.getResolvedUrl(this.context.fullProps());
        String token = this.deployer.getPassword();
        for (AbstractMavenDeployer.Deployable deployable : deployables) {
            if (!deployable.getFilename().endsWith(".pom")) continue;
            this.deletePackage(token, deployable);
        }
        for (AbstractMavenDeployer.Deployable deployable : deployables) {
            Path localPath = Paths.get(deployable.getStagingRepository(), deployable.getPath(), deployable.getFilename());
            this.context.getLogger().info(" - {}", new Object[]{deployable.getFilename()});
            if (this.context.isDryrun()) continue;
            try {
                LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
                headers.put("Authorization", "token " + token);
                FormData data = ClientUtils.toFormData((Path)localPath);
                String url = baseUrl + deployable.getDeployPath() + "/" + deployable.getFilename();
                ClientUtils.putFile((JReleaserLogger)this.context.getLogger(), (String)url, (int)this.deployer.getConnectTimeout(), (int)this.deployer.getReadTimeout(), (FormData)data, headers);
            }
            catch (IOException | UploadException e) {
                this.context.getLogger().trace(e);
                throw new DeployException(RB.$((String)"ERROR_unexpected_deploy", (Object[])new Object[]{this.context.getBasedir().relativize(localPath)}), e);
            }
        }
    }

    private void deletePackage(String token, AbstractMavenDeployer.Deployable deployable) throws DeployException {
        String packageType = "maven";
        String packageName = deployable.getGroupId() + "." + deployable.getArtifactId();
        String packageVersion = deployable.getVersion();
        try {
            XGithub api = new XGithub(this.context.getLogger(), this.context.getModel().getRelease().getGithub().getApiEndpoint(), token, this.deployer.getConnectTimeout(), this.deployer.getReadTimeout());
            List<GhPackageVersion> ghPackageVersions = api.listPackageVersions(packageType, packageName);
            if (ghPackageVersions.isEmpty()) {
                return;
            }
            if (ghPackageVersions.size() == 1) {
                api.deletePackage(packageType, packageName);
            } else {
                Optional<GhPackageVersion> ghPackageVersion = ghPackageVersions.stream().filter(pv -> pv.getName().equals(packageVersion)).findFirst();
                if (ghPackageVersion.isPresent()) {
                    api.deletePackageVersion(packageType, packageType, packageVersion);
                }
            }
        }
        catch (Exception e) {
            this.context.getLogger().debug(RB.$((String)"ERROR_github_delete_package", (Object[])new Object[]{this.deployer.getUsername(), packageType, packageName, packageVersion}));
        }
    }
}

