/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.announce;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.announce.Announcer;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.project.Project;

public abstract class AbstractAnnouncer<S extends AbstractAnnouncer<S, A>, A extends org.jreleaser.model.api.announce.Announcer>
extends AbstractModelObject<S>
implements Announcer<A> {
    protected final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    @JsonIgnore
    protected String name;
    @JsonIgnore
    protected boolean enabled;
    protected Active active;
    protected Integer connectTimeout;
    protected Integer readTimeout;

    protected AbstractAnnouncer(String name) {
        this.name = name;
    }

    @Override
    public void merge(S source) {
        this.active = this.merge(this.active, ((AbstractAnnouncer)source).active);
        this.enabled = this.merge(this.enabled, ((AbstractAnnouncer)source).enabled);
        this.connectTimeout = this.merge(this.connectTimeout, ((AbstractAnnouncer)source).connectTimeout);
        this.readTimeout = this.merge(this.readTimeout, ((AbstractAnnouncer)source).readTimeout);
        this.setExtraProperties(this.merge(this.extraProperties, ((AbstractAnnouncer)source).extraProperties));
    }

    protected boolean isSet() {
        return this.active != null || this.connectTimeout != null || this.readTimeout != null || !this.extraProperties.isEmpty();
    }

    @Override
    public String getPrefix() {
        return this.name;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.active = Active.NEVER;
        }
        this.enabled = this.active.check((Active.Releaseable)project);
        if (project.isSnapshot() && !this.isSnapshotSupported()) {
            this.enabled = false;
        }
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of((String)str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    @Override
    public boolean isSnapshotSupported() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", this.active);
        props.put("connectTimeout", this.connectTimeout);
        props.put("readTimeout", this.readTimeout);
        this.asMap(full, props);
        props.put("extraProperties", this.getResolvedExtraProperties());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.getName(), props);
        return map;
    }

    protected abstract void asMap(boolean var1, Map<String, Object> var2);
}

