/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.announce;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.AbstractAnnouncer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.util.StringUtils;

public final class TwitterAnnouncer
extends AbstractAnnouncer<TwitterAnnouncer, org.jreleaser.model.api.announce.TwitterAnnouncer> {
    private final List<String> statuses = new ArrayList<String>();
    private String consumerKey;
    private String consumerSecret;
    private String accessToken;
    private String accessTokenSecret;
    private String status;
    private String statusTemplate;
    private final org.jreleaser.model.api.announce.TwitterAnnouncer immutable = new org.jreleaser.model.api.announce.TwitterAnnouncer(){

        public String getType() {
            return "twitter";
        }

        public String getConsumerKey() {
            return TwitterAnnouncer.this.consumerKey;
        }

        public String getConsumerSecret() {
            return TwitterAnnouncer.this.consumerSecret;
        }

        public String getAccessToken() {
            return TwitterAnnouncer.this.accessToken;
        }

        public String getAccessTokenSecret() {
            return TwitterAnnouncer.this.accessTokenSecret;
        }

        public String getStatus() {
            return TwitterAnnouncer.this.status;
        }

        public List<String> getStatuses() {
            return Collections.unmodifiableList(TwitterAnnouncer.this.statuses);
        }

        public String getStatusTemplate() {
            return TwitterAnnouncer.this.statusTemplate;
        }

        public String getName() {
            return TwitterAnnouncer.this.name;
        }

        public boolean isSnapshotSupported() {
            return TwitterAnnouncer.this.isSnapshotSupported();
        }

        public Active getActive() {
            return TwitterAnnouncer.this.active;
        }

        public boolean isEnabled() {
            return TwitterAnnouncer.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(TwitterAnnouncer.this.asMap(full));
        }

        public String getPrefix() {
            return TwitterAnnouncer.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(TwitterAnnouncer.this.extraProperties);
        }

        public Integer getConnectTimeout() {
            return TwitterAnnouncer.this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return TwitterAnnouncer.this.readTimeout;
        }
    };

    public TwitterAnnouncer() {
        super("twitter");
    }

    @Override
    public org.jreleaser.model.api.announce.TwitterAnnouncer asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(TwitterAnnouncer source) {
        super.merge(source);
        this.consumerKey = this.merge(this.consumerKey, source.consumerKey);
        this.consumerSecret = this.merge(this.consumerSecret, source.consumerSecret);
        this.accessToken = this.merge(this.accessToken, source.accessToken);
        this.accessTokenSecret = this.merge(this.accessTokenSecret, source.accessTokenSecret);
        this.status = this.merge(this.status, source.status);
        this.setStatuses(this.merge(this.statuses, source.statuses));
        this.statusTemplate = this.merge(this.statusTemplate, source.statusTemplate);
    }

    public String getResolvedStatusTemplate(JReleaserContext context, Map<String, Object> extraProps) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("tagName", context.getModel().getRelease().getReleaser().getEffectiveTagName(context.getModel()));
        props.putAll(extraProps);
        Path templatePath = context.getBasedir().resolve(this.statusTemplate);
        try {
            BufferedReader reader = Files.newBufferedReader(templatePath);
            return MustacheUtils.applyTemplate((Reader)reader, props);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
        }
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessTokenSecret() {
        return this.accessTokenSecret;
    }

    public void setAccessTokenSecret(String accessTokenSecret) {
        this.accessTokenSecret = accessTokenSecret;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<String> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<String> statuses) {
        this.statuses.clear();
        this.statuses.addAll(statuses);
    }

    public String getStatusTemplate() {
        return this.statusTemplate;
    }

    public void setStatusTemplate(String statusTemplate) {
        this.statusTemplate = statusTemplate;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("consumerKey", StringUtils.isNotBlank((String)this.consumerKey) ? "************" : "**unset**");
        props.put("consumerSecret", StringUtils.isNotBlank((String)this.consumerSecret) ? "************" : "**unset**");
        props.put("accessToken", StringUtils.isNotBlank((String)this.accessToken) ? "************" : "**unset**");
        props.put("accessTokenSecret", StringUtils.isNotBlank((String)this.accessTokenSecret) ? "************" : "**unset**");
        props.put("status", this.status);
        props.put("statuses", this.statuses);
        props.put("statusTemplate", this.statusTemplate);
    }
}

