/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jreleaser.model.api.packagers.DockerConfiguration;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.util.StringUtils;

public interface DockerConfiguration
extends Domain,
ExtraProperties,
Activatable {
    public static final String TYPE = "docker";
    public static final String LABEL_OCI_IMAGE_TITLE = "org.opencontainers.image.title";
    public static final String LABEL_OCI_IMAGE_DESCRIPTION = "org.opencontainers.image.description";
    public static final String LABEL_OCI_IMAGE_REVISION = "org.opencontainers.image.revision";
    public static final String LABEL_OCI_IMAGE_VERSION = "org.opencontainers.image.version";
    public static final String LABEL_OCI_IMAGE_LICENSES = "org.opencontainers.image.licenses";
    public static final String LABEL_OCI_IMAGE_URL = "org.opencontainers.image.url";

    public String getTemplateDirectory();

    public void setTemplateDirectory(String var1);

    public List<String> getSkipTemplates();

    public void setSkipTemplates(List<String> var1);

    public void addSkipTemplates(List<String> var1);

    public void addSkipTemplate(String var1);

    public String getBaseImage();

    public void setBaseImage(String var1);

    public Map<String, String> getLabels();

    public void setLabels(Map<String, String> var1);

    public void addLabels(Map<String, String> var1);

    public void addLabel(String var1, String var2);

    public Set<String> getImageNames();

    public void setImageNames(Set<String> var1);

    public void addImageName(String var1);

    public List<String> getBuildArgs();

    public void setBuildArgs(List<String> var1);

    public void addBuildArg(String var1);

    public List<String> getPreCommands();

    public void setPreCommands(List<String> var1);

    public List<String> getPostCommands();

    public void setPostCommands(List<String> var1);

    public Set<? extends Registry> getRegistries();

    public void setRegistries(Set<? extends Registry> var1);

    public void addRegistry(Registry var1);

    public boolean isUseLocalArtifact();

    public void setUseLocalArtifact(Boolean var1);

    public boolean isUseLocalArtifactSet();

    public Buildx getBuildx();

    public void setBuildx(Buildx var1);

    public static final class Buildx
    extends AbstractModelObject<Buildx>
    implements Domain {
        private final List<String> createBuilderFlags = new ArrayList<String>();
        private final List<String> platforms = new ArrayList<String>();
        private Boolean enabled;
        private final DockerConfiguration.Buildx immutable = new DockerConfiguration.Buildx(){

            public boolean isEnabled() {
                return this.isEnabled();
            }

            public List<String> getCreateBuilderFlags() {
                return Collections.unmodifiableList(createBuilderFlags);
            }

            public List<String> getPlatforms() {
                return Collections.unmodifiableList(platforms);
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public DockerConfiguration.Buildx asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Buildx source) {
            this.enabled = this.merge(this.enabled, source.enabled);
            this.setCreateBuilderFlags(this.merge(this.createBuilderFlags, source.createBuilderFlags));
            this.setPlatforms(this.merge(this.platforms, source.platforms));
        }

        public List<String> getCreateBuilderFlags() {
            return this.createBuilderFlags;
        }

        public void setCreateBuilderFlags(List<String> createBuilderFlags) {
            this.createBuilderFlags.clear();
            this.createBuilderFlags.addAll(createBuilderFlags);
        }

        public List<String> getPlatforms() {
            return this.platforms;
        }

        public void setPlatforms(List<String> platforms) {
            this.platforms.clear();
            this.platforms.addAll(platforms);
        }

        public boolean isEnabled() {
            return this.enabled != null && this.enabled != false;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabledSet() {
            return this.enabled != null;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            if (!full && !this.isEnabled()) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.isEnabled());
            map.put("createBuilderFlags", this.createBuilderFlags);
            map.put("platforms", this.platforms);
            return map;
        }
    }

    public static final class Registry
    extends AbstractModelObject<Registry>
    implements Domain,
    Comparable<Registry> {
        public static final String DEFAULT_NAME = "DEFAULT";
        private String server;
        private String serverName = "DEFAULT";
        private String repositoryName;
        private String username;
        private String password;
        private final DockerConfiguration.Registry immutable = new DockerConfiguration.Registry(){

            public String getServer() {
                return server;
            }

            public String getServerName() {
                return serverName;
            }

            public String getRepositoryName() {
                return repositoryName;
            }

            public String getUsername() {
                return username;
            }

            public String getPassword() {
                return password;
            }

            public int compareTo(DockerConfiguration.Registry o) {
                if (null == o) {
                    return -1;
                }
                return serverName.compareTo(o.getServerName());
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public DockerConfiguration.Registry asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Registry source) {
            this.server = this.merge(this.server, source.server);
            this.serverName = this.merge(this.serverName, source.serverName);
            this.repositoryName = this.merge(this.repositoryName, source.repositoryName);
            this.username = this.merge(this.username, source.username);
            this.password = this.merge(this.password, source.password);
        }

        public String getServer() {
            return this.server;
        }

        public void setServer(String server) {
            this.server = server;
        }

        public String getServerName() {
            return this.serverName;
        }

        public void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public String getRepositoryName() {
            return this.repositoryName;
        }

        public void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("server", this.server);
            map.put("serverName", this.serverName);
            map.put("repositoryName", this.repositoryName);
            map.put("username", this.username);
            map.put("password", StringUtils.isNotBlank((String)this.password) ? "************" : "**unset**");
            return map;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Registry that = (Registry)o;
            return this.serverName.equals(that.serverName);
        }

        public int hashCode() {
            return Objects.hash(this.serverName);
        }

        @Override
        public int compareTo(Registry o) {
            if (null == o) {
                return -1;
            }
            return this.serverName.compareTo(o.getServerName());
        }
    }
}

