/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.upload;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.Http;
import org.jreleaser.model.api.upload.ArtifactoryUploader;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.upload.AbstractUploader;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.FileType;
import org.jreleaser.util.StringUtils;

public final class ArtifactoryUploader
extends AbstractUploader<org.jreleaser.model.api.upload.ArtifactoryUploader, ArtifactoryUploader> {
    private final List<ArtifactoryRepository> repositories = new ArrayList<ArtifactoryRepository>();
    private String host;
    private String username;
    private String password;
    private Http.Authorization authorization;
    private final org.jreleaser.model.api.upload.ArtifactoryUploader immutable = new org.jreleaser.model.api.upload.ArtifactoryUploader(){
        private List<? extends ArtifactoryUploader.ArtifactoryRepository> repositories;

        public String getHost() {
            return ArtifactoryUploader.this.host;
        }

        public String getUsername() {
            return ArtifactoryUploader.this.username;
        }

        public String getPassword() {
            return ArtifactoryUploader.this.password;
        }

        public Http.Authorization getAuthorization() {
            return ArtifactoryUploader.this.authorization;
        }

        public List<? extends ArtifactoryUploader.ArtifactoryRepository> getRepositories() {
            if (null == this.repositories) {
                this.repositories = ArtifactoryUploader.this.repositories.stream().map(ArtifactoryRepository::asImmutable).collect(Collectors.toList());
            }
            return this.repositories;
        }

        public String getType() {
            return ArtifactoryUploader.this.type;
        }

        public String getName() {
            return ArtifactoryUploader.this.name;
        }

        public boolean isSnapshotSupported() {
            return ArtifactoryUploader.this.isSnapshotSupported();
        }

        public boolean isArtifacts() {
            return ArtifactoryUploader.this.isArtifacts();
        }

        public boolean isFiles() {
            return ArtifactoryUploader.this.isFiles();
        }

        public boolean isSignatures() {
            return ArtifactoryUploader.this.isSignatures();
        }

        public boolean isChecksums() {
            return ArtifactoryUploader.this.isChecksums();
        }

        public Active getActive() {
            return ArtifactoryUploader.this.active;
        }

        public boolean isEnabled() {
            return ArtifactoryUploader.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(ArtifactoryUploader.this.asMap(full));
        }

        public String getPrefix() {
            return ArtifactoryUploader.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(ArtifactoryUploader.this.extraProperties);
        }

        public Integer getConnectTimeout() {
            return ArtifactoryUploader.this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return ArtifactoryUploader.this.readTimeout;
        }
    };

    public ArtifactoryUploader() {
        super("artifactory");
    }

    @Override
    public org.jreleaser.model.api.upload.ArtifactoryUploader asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(ArtifactoryUploader source) {
        super.merge(source);
        this.host = this.merge(this.host, source.host);
        this.username = this.merge(this.username, source.username);
        this.password = this.merge(this.password, source.password);
        this.authorization = this.merge(this.authorization, source.authorization);
        this.setRepositories(this.merge(this.repositories, source.repositories));
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Http.Authorization getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(Http.Authorization authorization) {
        this.authorization = authorization;
    }

    public void setAuthorization(String authorization) {
        this.authorization = Http.Authorization.of((String)authorization);
    }

    public List<ArtifactoryRepository> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<ArtifactoryRepository> repositories) {
        this.repositories.clear();
        this.repositories.addAll(repositories);
    }

    public void addRepository(ArtifactoryRepository repository) {
        if (null != repository) {
            this.repositories.add(repository);
        }
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("authorization", this.authorization);
        props.put("host", this.host);
        props.put("username", StringUtils.isNotBlank((String)this.username) ? "************" : "**unset**");
        props.put("password", StringUtils.isNotBlank((String)this.password) ? "************" : "**unset**");
        List repositories = this.repositories.stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList());
        if (!repositories.isEmpty()) {
            props.put("repositories", repositories);
        }
    }

    public Http.Authorization resolveAuthorization() {
        if (null == this.authorization) {
            this.authorization = Http.Authorization.BEARER;
        }
        return this.authorization;
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, Artifact artifact) {
        return this.resolveUrl(context.fullProps(), artifact);
    }

    @Override
    public String getResolvedDownloadUrl(Map<String, Object> props, Artifact artifact) {
        return this.resolveUrl(props, artifact);
    }

    public String getResolvedUploadUrl(JReleaserContext context, Artifact artifact) {
        return this.resolveUrl(context.fullProps(), artifact);
    }

    private String resolveUrl(Map<String, Object> props, Artifact artifact) {
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>(this.artifactProps(props, artifact));
        p.put("artifactoryHost", this.host);
        Optional<ArtifactoryRepository> repository = this.repositories.stream().filter(r -> r.handles(artifact)).findFirst();
        if (repository.isPresent()) {
            p.put("repositoryPath", repository.get().getPath());
            String url = "{{artifactoryHost}}/{{repositoryPath}}";
            return Templates.resolveTemplate((String)url, p);
        }
        return "";
    }

    public static final class ArtifactoryRepository
    extends AbstractModelObject<ArtifactoryRepository>
    implements Domain,
    Activatable {
        private final Set<FileType> fileTypes = new LinkedHashSet<FileType>();
        private Active active;
        private boolean enabled;
        private String path;
        private final ArtifactoryUploader.ArtifactoryRepository immutable = new ArtifactoryUploader.ArtifactoryRepository(){

            public String getPath() {
                return path;
            }

            public Set<FileType> getFileTypes() {
                return Collections.unmodifiableSet(this.getFileTypes());
            }

            public Active getActive() {
                return active;
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public ArtifactoryUploader.ArtifactoryRepository asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(ArtifactoryRepository source) {
            this.active = this.merge(this.active, source.active);
            this.enabled = this.merge(this.enabled, source.enabled);
            this.path = this.merge(this.path, source.path);
            this.setFileTypes(source.fileTypes);
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public void disable() {
            this.active = Active.NEVER;
            this.enabled = false;
        }

        public boolean resolveEnabled(Project project) {
            if (null == this.active) {
                this.active = Active.RELEASE;
            }
            this.enabled = this.active.check((Active.Releaseable)project);
            return this.enabled;
        }

        @Override
        public Active getActive() {
            return this.active;
        }

        @Override
        public void setActive(Active active) {
            this.active = active;
        }

        @Override
        public void setActive(String str) {
            this.setActive(Active.of((String)str));
        }

        @Override
        public boolean isActiveSet() {
            return this.active != null;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public Set<FileType> getFileTypes() {
            return this.fileTypes;
        }

        public void setFileTypes(Set<FileType> fileTypes) {
            this.fileTypes.clear();
            this.fileTypes.addAll(fileTypes);
        }

        public void addFileType(FileType fileType) {
            this.fileTypes.add(fileType);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.isEnabled());
            map.put("active", this.active);
            map.put("path", this.path);
            map.put("fileTypes", this.fileTypes);
            return map;
        }

        public boolean handles(Artifact artifact) {
            if (!this.enabled) {
                return false;
            }
            if (this.fileTypes.isEmpty()) {
                return true;
            }
            String artifactFileName = artifact.getResolvedPath().getFileName().toString();
            String artifactName = StringUtils.getFilename((String)artifactFileName, (Collection)FileType.getSupportedExtensions());
            String archiveFormat = artifactFileName.substring(artifactName.length() + 1);
            FileType fileType = FileType.of((String)archiveFormat);
            return this.fileTypes.contains(fileType);
        }
    }
}

