/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.MastodonAnnouncer;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class MastodonAnnouncerValidator
extends Validator {
    public static void validateMastodon(JReleaserContext context, MastodonAnnouncer mastodon, Errors errors) {
        context.getLogger().debug("announce.mastodon");
        if (!mastodon.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((String)mastodon.getHost())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"mastodon.host"}));
        }
        mastodon.setAccessToken(MastodonAnnouncerValidator.checkProperty(context, "MASTODON_ACCESS_TOKEN", "announce.mastodon.accessToken", mastodon.getAccessToken(), errors, context.isDryrun()));
        if (StringUtils.isNotBlank((String)mastodon.getStatusTemplate()) && !Files.exists(context.getBasedir().resolve(mastodon.getStatusTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"mastodon.statusTemplate", mastodon.getStatusTemplate()}));
        }
        if (StringUtils.isBlank((String)mastodon.getStatus()) && StringUtils.isBlank((String)mastodon.getStatusTemplate()) && mastodon.getStatuses().isEmpty()) {
            mastodon.setStatus(RB.$((String)"default.release.message", (Object[])new Object[0]));
        }
        MastodonAnnouncerValidator.validateTimeout(mastodon);
    }
}

