/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.hooks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.api.hooks.Hook;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Domain;

public interface Hook
extends Domain,
Activatable {
    public Filter getFilter();

    public void setFilter(Filter var1);

    public boolean isContinueOnError();

    public void setContinueOnError(Boolean var1);

    public boolean isContinueOnErrorSet();

    public static class Filter
    extends AbstractModelObject<Filter>
    implements Domain {
        private static final long serialVersionUID = 8811064830998012126L;
        private final Set<String> includes = new LinkedHashSet<String>();
        private final Set<String> excludes = new LinkedHashSet<String>();
        @JsonIgnore
        private final Hook.Filter immutable = new Hook.Filter(){
            private static final long serialVersionUID = -6995455963355646704L;

            public Set<String> getIncludes() {
                return Collections.unmodifiableSet(includes);
            }

            public Set<String> getExcludes() {
                return Collections.unmodifiableSet(excludes);
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public Hook.Filter asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Filter source) {
            this.setIncludes(this.merge(this.includes, source.includes));
            this.setExcludes(this.merge(this.excludes, source.excludes));
        }

        public Set<String> getResolvedIncludes() {
            return this.includes.stream().map(String::toLowerCase).collect(Collectors.toSet());
        }

        public Set<String> getResolvedExcludes() {
            return this.excludes.stream().map(String::toLowerCase).collect(Collectors.toSet());
        }

        public Set<String> getIncludes() {
            return this.includes;
        }

        public void setIncludes(Set<String> includes) {
            this.includes.clear();
            this.includes.addAll(includes);
        }

        public Set<String> getExcludes() {
            return this.excludes;
        }

        public void setExcludes(Set<String> excludes) {
            this.excludes.clear();
            this.excludes.addAll(excludes);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("includes", this.getResolvedIncludes());
            map.put("excludes", this.getResolvedExcludes());
            return map;
        }
    }
}

