/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.upload;

import java.util.Collection;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.upload.GiteaUploader;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class GiteaUploaderValidator {
    private GiteaUploaderValidator() {
    }

    public static void validateGiteaUploader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, GiteaUploader> gitea = context.getModel().getUpload().getGitea();
        if (!gitea.isEmpty()) {
            context.getLogger().debug("upload.gitea");
        }
        for (Map.Entry<String, GiteaUploader> e : gitea.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig()) continue;
            GiteaUploaderValidator.validateGiteaUploader(context, e.getValue(), errors);
        }
    }

    private static void validateGiteaUploader(JReleaserContext context, GiteaUploader gitea, Errors errors) {
        context.getLogger().debug("upload.gitea.{}", new Object[]{gitea.getName()});
        Validator.resolveActivatable(context, (Activatable)gitea, CollectionUtils.listOf((Object[])new String[]{"upload.gitea." + gitea.getName(), "upload.gitea"}), "NEVER");
        if (!gitea.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!(gitea.isArtifacts() || gitea.isFiles() || gitea.isSignatures())) {
            errors.warning(RB.$((String)"WARNING.validation.uploader.no.artifacts", (Object[])new Object[]{gitea.getType(), gitea.getName()}));
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            gitea.disable();
            return;
        }
        String baseKey1 = "upload.gitea." + gitea.getName();
        String baseKey2 = "upload.gitea";
        String baseKey3 = "gitea." + gitea.getName();
        String baseKey4 = "gitea";
        gitea.setToken(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + ".token", baseKey2 + ".token", baseKey3 + ".token", baseKey4 + ".token"}), baseKey1 + ".token", gitea.getToken(), errors, context.isDryrun()));
        gitea.setHost(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + ".host", baseKey2 + ".host", baseKey3 + ".host", baseKey4 + ".host"}), baseKey1 + ".host", gitea.getHost(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)gitea.getPackageName())) {
            gitea.setPackageName(gitea.getName());
        }
        if (StringUtils.isBlank((String)gitea.getPackageVersion())) {
            gitea.setPackageVersion("{{projectVersion}}");
        }
        if (StringUtils.isBlank((String)gitea.getOwner())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{baseKey1 + ".owner"}));
        }
        Validator.validateTimeout(gitea);
    }
}

