/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.upload;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.upload.SftpUploader;
import org.jreleaser.model.internal.validation.common.SshValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class SftpUploaderValidator {
    private SftpUploaderValidator() {
    }

    public static void validateSftpUploader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, SftpUploader> sftp = context.getModel().getUpload().getSftp();
        if (!sftp.isEmpty()) {
            context.getLogger().debug("upload.sftp");
        }
        for (Map.Entry<String, SftpUploader> e : sftp.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig()) continue;
            SftpUploaderValidator.validateSftpUploader(context, e.getValue(), errors);
        }
    }

    private static void validateSftpUploader(JReleaserContext context, SftpUploader sftp, Errors errors) {
        context.getLogger().debug("upload.sftp.{}", new Object[]{sftp.getName()});
        Validator.resolveActivatable(context, (Activatable)sftp, CollectionUtils.listOf((Object[])new String[]{"upload.sftp." + sftp.getName(), "upload.sftp"}), "NEVER");
        if (!sftp.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!(sftp.isArtifacts() || sftp.isFiles() || sftp.isSignatures())) {
            errors.warning(RB.$((String)"WARNING.validation.uploader.no.artifacts", (Object[])new Object[]{sftp.getType(), sftp.getName()}));
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            sftp.disable();
            return;
        }
        SshValidator.validateSsh(context, sftp, sftp.getType(), sftp.getName(), "upload.", errors);
        if (StringUtils.isBlank((String)sftp.getPath())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"upload.sftp." + sftp.getName() + ".path"}));
        }
        Validator.validateTimeout(sftp);
    }
}

