/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.tool;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.sdk.command.Command;
import org.jreleaser.sdk.command.CommandException;
import org.jreleaser.sdk.tool.DownloadableTool;
import org.jreleaser.sdk.tool.ToolException;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class AbstractTool {
    protected final JReleaserContext context;
    protected final DownloadableTool tool;
    protected final String name;
    protected final String version;
    protected final boolean verifyErrorOutput;

    public AbstractTool(JReleaserContext context, String name, String version) {
        this(context, name, version, false);
    }

    public AbstractTool(JReleaserContext context, String name, String version, boolean verifyErrorOutput) {
        this.version = StringUtils.requireNonBlank((String)version, (String)"'version' must not be blank");
        this.name = StringUtils.requireNonBlank((String)name, (String)"'name' must not be blank");
        this.context = context;
        this.verifyErrorOutput = verifyErrorOutput;
        this.tool = new DownloadableTool(context.getLogger(), name, version, PlatformUtils.getCurrentFull(), true);
    }

    public boolean setup() throws ToolException {
        if (!this.tool.verify()) {
            if (this.tool.isEnabled()) {
                try {
                    this.tool.download();
                }
                catch (Exception e) {
                    throw new ToolException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), e);
                }
                if (this.tool.verify()) {
                    return true;
                }
            }
            this.context.getLogger().warn(RB.$((String)"tool_verify_error", (Object[])new Object[]{this.name, this.tool.getVersion()}));
            return false;
        }
        return true;
    }

    protected Command.Result executeCommand(CommandExecution execution) throws CommandException {
        return execution.execute();
    }

    static interface CommandExecution {
        public Command.Result execute() throws CommandException;
    }
}

