/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.artifactory;

import feign.form.FormData;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.deploy.DeployException;
import org.jreleaser.model.spi.upload.UploadException;
import org.jreleaser.sdk.commons.AbstractMavenDeployer;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.ChecksumUtils;

public class ArtifactoryMavenDeployer
extends AbstractMavenDeployer<org.jreleaser.model.api.deploy.maven.ArtifactoryMavenDeployer, org.jreleaser.model.internal.deploy.maven.ArtifactoryMavenDeployer> {
    private org.jreleaser.model.internal.deploy.maven.ArtifactoryMavenDeployer deployer;

    public ArtifactoryMavenDeployer(JReleaserContext context) {
        super(context);
    }

    public org.jreleaser.model.internal.deploy.maven.ArtifactoryMavenDeployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(org.jreleaser.model.internal.deploy.maven.ArtifactoryMavenDeployer deployer) {
        this.deployer = deployer;
    }

    public String getType() {
        return "artifactory";
    }

    public void deploy(String name) throws DeployException {
        Set deployables = this.collectDeployables();
        if (deployables.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"artifacts.no.match", (Object[])new Object[0]));
        }
        String baseUrl = this.deployer.getResolvedUrl(this.context.fullProps());
        String username = this.deployer.getUsername();
        String password = this.deployer.getPassword();
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        for (AbstractMavenDeployer.Deployable deployable : deployables) {
            if (deployable.isChecksum()) continue;
            Path localPath = Paths.get(deployable.getStagingRepository(), deployable.getPath(), deployable.getFilename());
            this.context.getLogger().info(" - {}", new Object[]{deployable.getFilename()});
            if (this.context.isDryrun()) continue;
            try {
                FormData data = ClientUtils.toFormData((Path)localPath);
                LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
                switch (this.deployer.resolveAuthorization()) {
                    case BASIC: {
                        String auth = username + ":" + password;
                        byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.UTF_8));
                        auth = new String(encodedAuth, StandardCharsets.UTF_8);
                        headers.put("Authorization", "Basic " + auth);
                        break;
                    }
                    case BEARER: {
                        headers.put("Authorization", "Bearer " + password);
                        break;
                    }
                }
                headers.put("X-Checksum-Deploy", "false");
                headers.put("X-Checksum-Sha1", ChecksumUtils.checksum((Algorithm)Algorithm.SHA_1, (byte[])data.getData()));
                headers.put("X-Checksum-Sha256", ChecksumUtils.checksum((Algorithm)Algorithm.SHA_256, (byte[])data.getData()));
                headers.put("X-Checksum", ChecksumUtils.checksum((Algorithm)Algorithm.MD5, (byte[])data.getData()));
                String url = baseUrl + deployable.getFullDeployPath();
                ClientUtils.putFile((JReleaserLogger)this.context.getLogger(), (String)url, (int)this.deployer.getConnectTimeout(), (int)this.deployer.getReadTimeout(), (FormData)data, headers);
            }
            catch (IOException | UploadException e) {
                this.context.getLogger().trace(e);
                throw new DeployException(RB.$((String)"ERROR_unexpected_deploy", (Object[])new Object[]{this.context.getBasedir().relativize(localPath)}), e);
            }
        }
    }
}

