/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.announcers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.lib.GpgSigner;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.model.spi.release.Repository;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.git.JReleaserGpgSigner;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.StringUtils;

public class ArticleAnnouncer
implements Announcer<org.jreleaser.model.api.announce.ArticleAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.ArticleAnnouncer article;

    public ArticleAnnouncer(JReleaserContext context) {
        this.context = context;
        this.article = context.getModel().getAnnounce().getArticle();
    }

    public org.jreleaser.model.api.announce.ArticleAnnouncer getAnnouncer() {
        return this.article.asImmutable();
    }

    public String getName() {
        return "article";
    }

    public boolean isEnabled() {
        return this.article.isEnabled();
    }

    public void announce() throws AnnounceException {
        Path prepareDirectory = this.context.getPrepareDirectory().resolve("article");
        TemplateContext props = this.prepareFiles(prepareDirectory);
        this.publishToRepository(prepareDirectory, props);
    }

    private TemplateContext prepareFiles(Path prepareDirectory) throws AnnounceException {
        Path templateDirectory = this.context.getBasedir().resolve(this.article.getTemplateDirectory());
        try {
            FileUtils.deleteFiles((Path)prepareDirectory);
            Files.createDirectories(prepareDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new AnnounceException(RB.$((String)"ERROR_unexpected_article_announcer", (Object[])new Object[]{this.context.relativizeToBasedir(templateDirectory)}), (Throwable)e);
        }
        this.context.getLogger().debug(RB.$((String)"announcer.article.resolve.templates", (Object[])new Object[0]));
        TemplateContext props = this.context.fullProps();
        this.context.getChangelog().apply(props);
        this.context.getModel().getRelease().getReleaser().fillProps(props, this.context.getModel());
        props.setAll(this.article.resolvedExtraProperties());
        try {
            for (Artifact file : this.article.getFiles()) {
                Path input = file.getResolvedPath(this.context, templateDirectory, true);
                Path output = file.getResolvedTransform(this.context, prepareDirectory);
                if (null == output) {
                    output = file.getResolvedPath(this.context, prepareDirectory, false);
                }
                BufferedReader reader = Files.newBufferedReader(input);
                try {
                    this.context.getLogger().debug(RB.$((String)"announcer.article.eval.template", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(input)});
                    String content = MustacheUtils.applyTemplate((Reader)reader, (TemplateContext)props);
                    this.context.getLogger().debug(RB.$((String)"announcer.article.write.template", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(input)});
                    this.writeFile(content, output);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
        }
        catch (JReleaserException e) {
            this.context.getLogger().warn(e.getMessage());
            this.context.getLogger().trace((Throwable)e);
            throw new AnnounceException(RB.$((String)"ERROR_unexpected_template_resolution", (Object[])new Object[]{this.context.relativizeToBasedir(templateDirectory)}), (Throwable)e);
        }
        catch (IOException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new AnnounceException(RB.$((String)"ERROR_unexpected_template_resolution", (Object[])new Object[]{this.context.relativizeToBasedir(templateDirectory)}), (Throwable)e);
        }
        return props;
    }

    private void publishToRepository(Path prepareDirectory, TemplateContext props) throws AnnounceException {
        this.context.getLogger().info(RB.$((String)"repository.setup", (Object[])new Object[0]), new Object[]{this.article.getRepository().getCanonicalRepoName()});
        if (this.context.isDryrun()) {
            return;
        }
        BaseReleaser releaser = this.context.getModel().getRelease().getReleaser();
        try {
            boolean mustBranch;
            this.context.getLogger().debug(RB.$((String)"repository.locate", (Object[])new Object[0]), new Object[]{this.article.getRepository().getCanonicalRepoName()});
            Repository repository = this.context.getReleaser().maybeCreateRepository(this.article.getRepository().getOwner(), this.article.getRepository().getResolvedName(), this.resolveGitToken(releaser));
            UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider(this.resolveGitUsername(releaser), this.resolveGitToken(releaser));
            this.context.getLogger().debug(RB.$((String)"repository.clone", (Object[])new Object[0]), new Object[]{repository.getHttpUrl()});
            Path directory = Files.createTempDirectory("jreleaser-" + this.article.getRepository().getResolvedName(), new FileAttribute[0]);
            String pullBranch = this.article.getRepository().getBranch();
            String pushBranch = Templates.resolveTemplate((String)this.article.getRepository().getBranchPush(), (TemplateContext)props);
            Git git = ((CloneCommand)Git.cloneRepository().setCredentialsProvider((CredentialsProvider)credentialsProvider)).setBranch(pullBranch).setDirectory(directory.toFile()).setURI(repository.getHttpUrl()).call();
            boolean emptyRepository = true;
            try {
                Iterator iterator = git.log().call().iterator();
                if (iterator.hasNext()) {
                    RevCommit commit = (RevCommit)iterator.next();
                    emptyRepository = false;
                }
            }
            catch (NoHeadException noHeadException) {
                // empty catch block
            }
            boolean bl = mustBranch = !pushBranch.equals(pullBranch);
            if (mustBranch && !emptyRepository) {
                this.context.getLogger().debug(RB.$((String)"repository.branching", (Object[])new Object[]{pushBranch}));
                git.checkout().setName(pushBranch).setCreateBranch(true).call();
            }
            this.copyFiles(prepareDirectory, directory);
            git.add().addFilepattern(".").call();
            this.context.getLogger().debug(RB.$((String)"repository.commit.setup", (Object[])new Object[0]));
            CommitCommand commitCommand = git.commit().setAll(true).setMessage(this.article.getRepository().getResolvedCommitMessage(props)).setAuthor(this.article.getCommitAuthor().getName(), this.article.getCommitAuthor().getEmail());
            commitCommand.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            commitCommand = commitCommand.setSign(Boolean.valueOf(releaser.isSign())).setSigningKey("**********").setGpgSigner((GpgSigner)new JReleaserGpgSigner(this.context, releaser.isSign()));
            commitCommand.call();
            if (mustBranch && emptyRepository) {
                this.context.getLogger().debug(RB.$((String)"repository.branching", (Object[])new Object[]{pushBranch}));
                git.checkout().setName(pushBranch).setCreateBranch(true).call();
            }
            this.context.getLogger().info(RB.$((String)"repository.push", (Object[])new Object[0]), new Object[]{this.article.getRepository().getCanonicalRepoName()});
            this.context.getLogger().debug(RB.$((String)"repository.commit.push", (Object[])new Object[0]));
            ((PushCommand)git.push().setDryRun(false).setPushAll().setCredentialsProvider((CredentialsProvider)credentialsProvider)).call();
        }
        catch (Exception e) {
            throw new AnnounceException(RB.$((String)"ERROR_unexpected_repository_update", (Object[])new Object[]{this.article.getRepository().getCanonicalRepoName()}), (Throwable)e);
        }
    }

    private void copyFiles(Path source, Path destination) throws IOException {
        this.context.getLogger().debug(RB.$((String)"repository.copy.files", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(source)});
        if (!FileUtils.copyFilesRecursive((JReleaserLogger)this.context.getLogger(), (Path)source, (Path)destination)) {
            throw new IOException(RB.$((String)"ERROR_repository_copy_files", (Object[])new Object[]{this.context.relativizeToBasedir(source)}));
        }
    }

    private String resolveGitUsername(BaseReleaser<?, ?> releaser) {
        String username = this.article.getRepository().getUsername();
        return StringUtils.isNotBlank((String)username) ? username : releaser.getUsername();
    }

    private String resolveGitToken(BaseReleaser<?, ?> releaser) {
        String token = this.article.getRepository().getToken();
        return StringUtils.isNotBlank((String)token) ? token : releaser.getToken();
    }

    private void writeFile(String content, Path outputFile) throws AnnounceException {
        try {
            FileUtils.createDirectoriesWithFullAccess((Path)outputFile.getParent());
            Files.write(outputFile, content.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new AnnounceException(RB.$((String)"ERROR_unexpected_error_writing_file", (Object[])new Object[]{outputFile.toAbsolutePath()}), (Throwable)e);
        }
    }
}

