/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.assemble;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.internal.assemble.Assembler;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.FileSet;
import org.jreleaser.model.internal.common.Glob;
import org.jreleaser.model.internal.platform.Platform;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.util.StringUtils;

public abstract class AbstractAssembler<S extends AbstractAssembler<S, A>, A extends org.jreleaser.model.api.assemble.Assembler>
extends AbstractActivatable<S>
implements Assembler<A> {
    private static final long serialVersionUID = 2073602358432833033L;
    @JsonIgnore
    private final Set<Artifact> outputs = new LinkedHashSet<Artifact>();
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private final Set<Artifact> artifacts = new LinkedHashSet<Artifact>();
    private final List<Glob> files = new ArrayList<Glob>();
    private final List<FileSet> fileSets = new ArrayList<FileSet>();
    private final Platform platform = new Platform();
    private final Set<String> skipTemplates = new LinkedHashSet<String>();
    @JsonIgnore
    private final String type;
    @JsonIgnore
    private String name;
    private String templateDirectory;
    protected Boolean exported;
    private Stereotype stereotype;

    protected AbstractAssembler(String type) {
        this.type = type;
    }

    @Override
    public void merge(S source) {
        super.merge(source);
        this.exported = this.merge(this.exported, ((AbstractAssembler)source).exported);
        this.name = this.merge(this.name, ((AbstractAssembler)source).getName());
        this.platform.merge(((AbstractAssembler)source).getPlatform());
        this.stereotype = this.merge(this.stereotype, ((AbstractAssembler)source).getStereotype());
        this.templateDirectory = this.merge(this.templateDirectory, ((AbstractAssembler)source).getTemplateDirectory());
        this.setSkipTemplates(this.merge(this.skipTemplates, ((AbstractAssembler)source).getSkipTemplates()));
        this.setOutputs(this.merge(this.outputs, ((AbstractAssembler)source).getOutputs()));
        this.setArtifacts(this.merge(this.artifacts, ((AbstractAssembler)source).getArtifacts()));
        this.setFileSets(this.merge(this.fileSets, ((AbstractAssembler)source).getFileSets()));
        this.setFiles(this.merge(this.files, ((AbstractAssembler)source).getFiles()));
        this.setExtraProperties(this.merge(this.extraProperties, ((AbstractAssembler)source).getExtraProperties()));
    }

    @Override
    public TemplateContext props() {
        TemplateContext props = new TemplateContext();
        MustacheUtils.applyTemplates((TemplateContext)props, this.resolvedExtraProperties());
        props.set("distributionName", (Object)this.name);
        props.set("distributionStereotype", (Object)this.getStereotype());
        return props;
    }

    @Override
    public Stereotype getStereotype() {
        return this.stereotype;
    }

    @Override
    public void setStereotype(Stereotype stereotype) {
        this.stereotype = stereotype;
    }

    @Override
    public void setStereotype(String str) {
        this.setStereotype(Stereotype.of((String)str));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public void setPlatform(Platform platform) {
        this.platform.merge(platform);
    }

    @Override
    public String getTemplateDirectory() {
        return this.templateDirectory;
    }

    @Override
    public void setTemplateDirectory(String templateDirectory) {
        this.templateDirectory = templateDirectory;
    }

    @Override
    public Set<String> getSkipTemplates() {
        return this.skipTemplates;
    }

    @Override
    public void setSkipTemplates(Set<String> skipTemplates) {
        this.skipTemplates.clear();
        this.skipTemplates.addAll(skipTemplates);
    }

    @Override
    public void addSkipTemplates(Set<String> templates) {
        this.skipTemplates.addAll(templates);
    }

    @Override
    public void addSkipTemplate(String template) {
        if (StringUtils.isNotBlank((String)template)) {
            this.skipTemplates.add(template.trim());
        }
    }

    @Override
    public boolean isExported() {
        return null == this.exported || this.exported != false;
    }

    @Override
    public void setExported(Boolean exported) {
        this.exported = exported;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Set<Artifact> getOutputs() {
        return Artifact.sortArtifacts(this.outputs);
    }

    @Override
    public void setOutputs(Set<Artifact> output) {
        this.outputs.clear();
        this.outputs.addAll(output);
    }

    @Override
    public void addOutput(Artifact artifact) {
        if (null != artifact) {
            this.outputs.add(artifact);
        }
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public String prefix() {
        return this.getType();
    }

    @Override
    public Set<Artifact> getArtifacts() {
        return Artifact.sortArtifacts(this.artifacts);
    }

    @Override
    public void setArtifacts(Set<Artifact> artifacts) {
        this.artifacts.clear();
        this.artifacts.addAll(artifacts);
    }

    @Override
    public void addArtifacts(Set<Artifact> artifacts) {
        this.artifacts.addAll(artifacts);
    }

    @Override
    public void addArtifact(Artifact artifact) {
        if (null != artifact) {
            this.artifacts.add(artifact);
        }
    }

    @Override
    public List<Glob> getFiles() {
        return this.files;
    }

    @Override
    public void setFiles(List<Glob> files) {
        this.files.clear();
        this.files.addAll(files);
    }

    @Override
    public void addFiles(List<Glob> files) {
        this.files.addAll(files);
    }

    @Override
    public void addFile(Glob file) {
        if (null != file) {
            this.files.add(file);
        }
    }

    @Override
    public List<FileSet> getFileSets() {
        return this.fileSets;
    }

    @Override
    public void setFileSets(List<FileSet> fileSets) {
        this.fileSets.clear();
        this.fileSets.addAll(fileSets);
    }

    @Override
    public void addFileSets(List<FileSet> files) {
        this.fileSets.addAll(files);
    }

    @Override
    public void addFileSet(FileSet file) {
        if (null != file) {
            this.fileSets.add(file);
        }
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("exported", this.isExported());
        props.put("active", this.getActive());
        props.put("stereotype", this.stereotype);
        if (full || this.platform.isSet()) {
            props.put("platform", this.platform.asMap(full));
        }
        this.asMap(full, props);
        props.put("templateDirectory", this.templateDirectory);
        props.put("skipTemplates", this.skipTemplates);
        LinkedHashMap<String, Map<String, Object>> mappedArtifacts = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Artifact artifact : this.artifacts) {
            mappedArtifacts.put("artifact " + i++, artifact.asMap(full));
        }
        props.put("artifacts", mappedArtifacts);
        LinkedHashMap<String, Map<String, Object>> mappedFiles = new LinkedHashMap<String, Map<String, Object>>();
        for (i = 0; i < this.files.size(); ++i) {
            mappedFiles.put("file " + i, this.files.get(i).asMap(full));
        }
        props.put("files", mappedFiles);
        LinkedHashMap<String, Map<String, Object>> mappedFileSets = new LinkedHashMap<String, Map<String, Object>>();
        for (i = 0; i < this.fileSets.size(); ++i) {
            mappedFileSets.put("fileSet " + i, this.fileSets.get(i).asMap(full));
        }
        props.put("fileSets", mappedFileSets);
        props.put("extraProperties", this.getExtraProperties());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.getName(), props);
        return map;
    }

    protected abstract void asMap(boolean var1, Map<String, Object> var2);
}

