/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.packagers;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.api.packagers.WingetPackager;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.WingetPackager;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.validation.common.ExtraPropertiesValidator;
import org.jreleaser.model.internal.validation.common.TemplateValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.distributions.DistributionsValidator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class WingetPackagerValidator {
    private static final Pattern PATTERN_PACKAGE_IDENTIFIER = Pattern.compile("^[^\\.\\s\\\\/:\\*\\?\"<>\\|\\x01-\\x1f]{1,32}(\\.[^\\.\\s\\\\/:\\*\\?\"<>\\|\\x01-\\x1f]{1,32}){1,3}$");
    private static final Pattern PATTERN_PACKAGE_VERSION = Pattern.compile("^[^\\\\/:\\*\\?\"<>\\|\\x01-\\x1f]+$");
    private static final Pattern PATTERN_LOCALE = Pattern.compile("^([a-zA-Z]{2,3}|[iI]-[a-zA-Z]+|[xX]-[a-zA-Z]{1,8})(-[a-zA-Z]{1,8})*$");
    private static final Pattern PATTERN_MINIMUM_OS_VERSION = Pattern.compile("^(0|[1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])(\\.(0|[1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])){0,3}$");

    private WingetPackagerValidator() {
    }

    public static void validateWinget(JReleaserContext context, Distribution distribution, WingetPackager packager, Errors errors) {
        context.getLogger().debug("distribution.{}." + packager.getType(), new Object[]{distribution.getName()});
        JReleaserModel model = context.getModel();
        WingetPackager parentPackager = model.getPackagers().getWinget();
        Validator.resolveActivatable(context, (Activatable)packager, "distributions." + distribution.getName() + "." + packager.getType(), parentPackager);
        if (!packager.resolveEnabled(context.getModel().getProject(), distribution)) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        BaseReleaser<?, ?> service = model.getRelease().getReleaser();
        if (!service.isReleaseSupported()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.release", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.isEmpty()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            errors.warning(RB.$((String)"WARNING.validation.packager.no.artifacts", (Object[])new Object[]{distribution.getName(), packager.getType(), packager.getSupportedFileExtensions(distribution.getType())}));
            packager.disable();
            return;
        }
        if (candidateArtifacts.size() > 1 && distribution.getType() == Distribution.DistributionType.NATIVE_PACKAGE) {
            errors.configuration(RB.$((String)"validation_packager_multiple_artifacts", (Object[])new Object[]{"distribution." + distribution.getName() + ".winget"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.multiple.artifacts", (Object[])new Object[0]));
            errors.warning(RB.$((String)"WARNING.validation.packager.multiple.artifacts", (Object[])new Object[]{distribution.getName(), packager.getType(), candidateArtifacts.stream().map(Artifact::getPath).collect(Collectors.toList())}));
            packager.disable();
            return;
        }
        if (StringUtils.isBlank((String)packager.getRepository().getName())) {
            packager.getRepository().setName("winget-" + distribution.getName());
        }
        packager.getRepository().setTapName("winget-" + distribution.getName());
        Validator.validateCommitAuthor(packager, parentPackager);
        WingetPackager.WingetRepository repository = packager.getRepository();
        Validator.validateRepository(context, distribution, repository, parentPackager.getRepository(), "winget.repository");
        TemplateValidator.validateTemplate(context, distribution, packager, parentPackager, errors);
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        Validator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        DistributionsValidator.validateArtifactPlatforms(distribution, packager, candidateArtifacts, errors);
        if (StringUtils.isBlank((String)packager.getDefaultLocale())) {
            packager.setDefaultLocale(parentPackager.getDefaultLocale());
        }
        if (StringUtils.isBlank((String)packager.getDefaultLocale())) {
            packager.setDefaultLocale("en-US");
        }
        if (!PATTERN_LOCALE.matcher(packager.getDefaultLocale()).matches()) {
            errors.configuration(RB.$((String)"validation_is_invalid", (Object[])new Object[]{"distribution." + distribution.getName() + ".winget.defaultLocale", packager.getDefaultLocale()}));
        }
        if (StringUtils.isBlank((String)packager.getMoniker())) {
            packager.setMoniker(parentPackager.getMoniker());
        }
        if (StringUtils.isBlank((String)packager.getMoniker())) {
            packager.setMoniker(distribution.getExecutable().getName());
        }
        if (StringUtils.isBlank((String)packager.getMinimumOsVersion())) {
            packager.setMinimumOsVersion(parentPackager.getMinimumOsVersion());
        }
        if (StringUtils.isBlank((String)packager.getMinimumOsVersion())) {
            packager.setMinimumOsVersion("10.0.0.0");
        }
        if (!PATTERN_MINIMUM_OS_VERSION.matcher(packager.getMinimumOsVersion()).matches()) {
            errors.configuration(RB.$((String)"validation_is_invalid", (Object[])new Object[]{"distribution." + distribution.getName() + ".winget.minimumOsVersion", packager.getMinimumOsVersion()}));
        }
        WingetPackagerValidator.validateWingetPackage(context, distribution, packager, parentPackager, errors);
        WingetPackagerValidator.validateWingetPublisher(context, distribution, packager, parentPackager, errors);
        WingetPackagerValidator.validateWingetInstaller(context, distribution, packager, parentPackager, errors);
        if (StringUtils.isBlank((String)packager.getProductCode())) {
            packager.setProductCode(parentPackager.getProductCode());
        }
        if (StringUtils.isBlank((String)packager.getProductCode())) {
            packager.setProductCode(packager.getPackage().getName() + " {{projectVersion}}");
        }
        if (StringUtils.isBlank((String)packager.getAuthor())) {
            packager.setAuthor(parentPackager.getAuthor());
        }
        ArrayList<String> tags = new ArrayList<String>();
        tags.addAll(context.getModel().getProject().getTags());
        tags.addAll(parentPackager.getTags());
        tags.addAll(packager.getTags());
        packager.setTags(tags);
    }

    private static void validateWingetPackage(JReleaserContext context, Distribution distribution, WingetPackager packager, WingetPackager parentPackager, Errors errors) {
        if (StringUtils.isBlank((String)packager.getPackage().getName())) {
            packager.getPackage().setName(parentPackager.getPackage().getName());
        }
        if (StringUtils.isBlank((String)packager.getPackage().getName())) {
            packager.getPackage().setName(distribution.getName());
        }
        if (StringUtils.isBlank((String)packager.getPackage().getIdentifier())) {
            packager.getPackage().setIdentifier(parentPackager.getPackage().getIdentifier());
        }
        if (StringUtils.isBlank((String)packager.getPackage().getIdentifier())) {
            String vendor = context.getModel().getProject().getVendor();
            if (StringUtils.isBlank((String)vendor)) {
                errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{"distribution." + distribution.getName() + ".winget.package.identifier"}));
            } else {
                packager.getPackage().setIdentifier(vendor + "." + packager.getPackage().getName());
            }
        }
        if (StringUtils.isNotBlank((String)packager.getPackage().getIdentifier()) && !PATTERN_PACKAGE_IDENTIFIER.matcher(packager.getPackage().getIdentifier()).matches()) {
            errors.configuration(RB.$((String)"validation_is_invalid", (Object[])new Object[]{"distribution." + distribution.getName() + ".winget.package.identifier", packager.getPackage().getIdentifier()}));
        }
        if (StringUtils.isBlank((String)packager.getPackage().getVersion())) {
            packager.getPackage().setVersion(parentPackager.getPackage().getVersion());
        }
        if (StringUtils.isBlank((String)packager.getPackage().getVersion())) {
            packager.getPackage().setVersion(context.getModel().getProject().getResolvedVersion());
        }
        if (!PATTERN_PACKAGE_VERSION.matcher(packager.getPackage().getVersion()).matches()) {
            errors.configuration(RB.$((String)"validation_is_invalid", (Object[])new Object[]{"distribution." + distribution.getName() + ".winget.package.version", packager.getPackage().getVersion()}));
        }
        if (StringUtils.isBlank((String)packager.getPackage().getUrl())) {
            packager.getPackage().setUrl(parentPackager.getPackage().getUrl());
        }
        if (StringUtils.isBlank((String)packager.getPackage().getUrl())) {
            packager.getPackage().setUrl(context.getModel().getProject().getLinks().getHomepage());
        }
    }

    private static void validateWingetPublisher(JReleaserContext context, Distribution distribution, WingetPackager packager, WingetPackager parentPackager, Errors errors) {
        if (StringUtils.isBlank((String)packager.getPublisher().getName())) {
            packager.getPublisher().setName(parentPackager.getPublisher().getName());
        }
        if (StringUtils.isBlank((String)packager.getPublisher().getName())) {
            packager.getPublisher().setName(context.getModel().getProject().getVendor());
        }
        if (StringUtils.isBlank((String)packager.getPublisher().getName())) {
            errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{"distribution." + distribution.getName() + ".winget.publisher.name"}));
        }
        if (StringUtils.isBlank((String)packager.getPublisher().getUrl())) {
            packager.getPublisher().setUrl(parentPackager.getPublisher().getUrl());
        }
        if (StringUtils.isBlank((String)packager.getPublisher().getUrl())) {
            packager.getPublisher().setUrl(context.getModel().getProject().getLinks().getHomepage());
        }
        if (StringUtils.isBlank((String)packager.getPublisher().getSupportUrl())) {
            packager.getPublisher().setSupportUrl(parentPackager.getPublisher().getSupportUrl());
        }
        if (StringUtils.isBlank((String)packager.getPublisher().getSupportUrl())) {
            packager.getPublisher().setSupportUrl(context.getModel().getProject().getLinks().getBugTracker());
        }
    }

    private static void validateWingetInstaller(JReleaserContext context, Distribution distribution, WingetPackager packager, WingetPackager parentPackager, Errors errors) {
        if (packager.getInstaller().getModes().isEmpty()) {
            packager.getInstaller().setModes(parentPackager.getInstaller().getModes());
        }
        if (packager.getInstaller().getModes().isEmpty()) {
            packager.getInstaller().getModes().add(WingetPackager.Installer.Mode.SILENT);
            packager.getInstaller().getModes().add(WingetPackager.Installer.Mode.SILENT_WITH_PROGRESS);
        }
        if (distribution.getType() == Distribution.DistributionType.NATIVE_IMAGE || distribution.getType() == Distribution.DistributionType.BINARY || distribution.getType() == Distribution.DistributionType.JAVA_BINARY || distribution.getType() == Distribution.DistributionType.JLINK) {
            packager.getInstaller().setType(WingetPackager.Installer.Type.ZIP);
            packager.getInstaller().getModes().clear();
            packager.getInstaller().setUpgradeBehavior((WingetPackager.Installer.UpgradeBehavior)null);
            packager.getInstaller().setScope((WingetPackager.Installer.Scope)null);
        }
    }

    public static void postValidateWinget(JReleaserContext context, Distribution distribution, WingetPackager packager, Errors errors) {
        if (!packager.isEnabled()) {
            return;
        }
        context.getLogger().debug("distribution.{}.winget", new Object[]{distribution.getName()});
        Project project = context.getModel().getProject();
        if (StringUtils.isBlank((String)project.getLinks().getLicense())) {
            errors.configuration(RB.$((String)"ERROR_project_no_license_url", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((String)packager.getAuthor()) && !project.getAuthors().isEmpty()) {
            packager.setAuthor(project.getAuthors().get(0));
        }
    }
}

