/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.JvmKotlinType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.intrinsics.JavaClassProperty;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class CallReceiver
extends StackValue {
    private final StackValue dispatchReceiver;
    private final StackValue extensionReceiver;
    private final Type secondReceiverType;
    private final KotlinType secondReceiverKotlinType;

    private CallReceiver(@NotNull StackValue dispatchReceiver, @NotNull StackValue extensionReceiver, @NotNull Type type2, @Nullable KotlinType kotlinType, @Nullable Type secondReceiverType, @Nullable KotlinType secondReceiverKotlinType) {
        if (dispatchReceiver == null) {
            CallReceiver.$$$reportNull$$$0(0);
        }
        if (extensionReceiver == null) {
            CallReceiver.$$$reportNull$$$0(1);
        }
        if (type2 == null) {
            CallReceiver.$$$reportNull$$$0(2);
        }
        super(type2, kotlinType, dispatchReceiver.canHaveSideEffects() || extensionReceiver.canHaveSideEffects());
        this.dispatchReceiver = dispatchReceiver;
        this.extensionReceiver = extensionReceiver;
        this.secondReceiverType = secondReceiverType;
        this.secondReceiverKotlinType = secondReceiverKotlinType;
    }

    public StackValue withoutReceiverArgument() {
        return new CallReceiver(this.dispatchReceiver, CallReceiver.none(), this.type, this.kotlinType, this.secondReceiverType, this.secondReceiverKotlinType);
    }

    public static StackValue generateCallReceiver(@NotNull ResolvedCall<?> resolvedCall2, @NotNull ExpressionCodegen codegen2, @Nullable Callable callableMethod, @Nullable ReceiverParameterDescriptor dispatchReceiverParameter2, @NotNull StackValue dispatchReceiver, @Nullable ReceiverParameterDescriptor extensionReceiverParameter2, @NotNull StackValue extensionReceiver) {
        JvmKotlinType jvmKotlinType;
        if (resolvedCall2 == null) {
            CallReceiver.$$$reportNull$$$0(3);
        }
        if (codegen2 == null) {
            CallReceiver.$$$reportNull$$$0(4);
        }
        if (dispatchReceiver == null) {
            CallReceiver.$$$reportNull$$$0(5);
        }
        if (extensionReceiver == null) {
            CallReceiver.$$$reportNull$$$0(6);
        }
        KotlinTypeMapper typeMapper2 = codegen2.typeMapper;
        GenerationState state = codegen2.getState();
        Type secondReceiverType = null;
        KotlinType secondReceiverKotlinType = null;
        if (extensionReceiverParameter2 != null) {
            jvmKotlinType = CallReceiver.calcExtensionReceiverType(resolvedCall2, extensionReceiverParameter2, typeMapper2, callableMethod, state);
            if (dispatchReceiverParameter2 != null) {
                JvmKotlinType dispatchReceiverInfo = CallReceiver.calcDispatchReceiverType(resolvedCall2, dispatchReceiverParameter2, typeMapper2, callableMethod);
                secondReceiverType = dispatchReceiverInfo.getType();
                secondReceiverKotlinType = dispatchReceiverInfo.getKotlinType();
            }
        } else if (dispatchReceiverParameter2 != null) {
            jvmKotlinType = CallReceiver.calcDispatchReceiverType(resolvedCall2, dispatchReceiverParameter2, typeMapper2, callableMethod);
        } else if (CallReceiver.isLocalFunCall(callableMethod)) {
            Type calleeType = callableMethod.getGenerateCalleeType();
            assert (calleeType != null) : "Could not get callee type for " + resolvedCall2;
            jvmKotlinType = new JvmKotlinType(calleeType, null);
        } else {
            jvmKotlinType = new JvmKotlinType(Type.VOID_TYPE, null);
        }
        return new CallReceiver(dispatchReceiver, extensionReceiver, jvmKotlinType.getType(), jvmKotlinType.getKotlinType(), secondReceiverType, secondReceiverKotlinType);
    }

    private static JvmKotlinType calcDispatchReceiverType(@NotNull ResolvedCall<?> resolvedCall2, @Nullable ReceiverParameterDescriptor dispatchReceiver, @NotNull KotlinTypeMapper typeMapper2, @Nullable Callable callableMethod) {
        if (resolvedCall2 == null) {
            CallReceiver.$$$reportNull$$$0(7);
        }
        if (typeMapper2 == null) {
            CallReceiver.$$$reportNull$$$0(8);
        }
        if (dispatchReceiver == null) {
            return null;
        }
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        if (CodegenUtilKt.isJvmStaticInObjectOrClassOrInterface(descriptor2)) {
            return new JvmKotlinType(Type.VOID_TYPE, null);
        }
        DeclarationDescriptor container = descriptor2.getContainingDeclaration();
        if (callableMethod != null) {
            if (InlineClassesUtilsKt.isInlineClass(container)) {
                ClassDescriptor classDescriptor = (ClassDescriptor)container;
                return new JvmKotlinType(typeMapper2.mapType(classDescriptor), classDescriptor.getDefaultType());
            }
            return new JvmKotlinType(callableMethod.getDispatchReceiverType(), callableMethod.getDispatchReceiverKotlinType());
        }
        if (container instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)container;
            return new JvmKotlinType(typeMapper2.mapType(classDescriptor), classDescriptor.getDefaultType());
        }
        KotlinType dispatchReceiverType = dispatchReceiver.getReturnType();
        return new JvmKotlinType(typeMapper2.mapType(dispatchReceiverType), dispatchReceiverType);
    }

    private static JvmKotlinType calcExtensionReceiverType(@NotNull ResolvedCall<?> resolvedCall2, @Nullable ReceiverParameterDescriptor extensionReceiver, @NotNull KotlinTypeMapper typeMapper2, @Nullable Callable callableMethod, @NotNull GenerationState state) {
        if (resolvedCall2 == null) {
            CallReceiver.$$$reportNull$$$0(9);
        }
        if (typeMapper2 == null) {
            CallReceiver.$$$reportNull$$$0(10);
        }
        if (state == null) {
            CallReceiver.$$$reportNull$$$0(11);
        }
        if (extensionReceiver == null) {
            return null;
        }
        Object descriptor2 = resolvedCall2.getCandidateDescriptor();
        if (descriptor2 instanceof PropertyDescriptor && state.getIntrinsics().getIntrinsic((PropertyDescriptor)descriptor2) != JavaClassProperty.INSTANCE) {
            ReceiverParameterDescriptor receiverCandidate = descriptor2.getExtensionReceiverParameter();
            assert (receiverCandidate != null);
            return new JvmKotlinType(typeMapper2.mapType(receiverCandidate.getType()), receiverCandidate.getType());
        }
        return callableMethod != null ? new JvmKotlinType(callableMethod.getExtensionReceiverType(), callableMethod.getExtensionReceiverKotlinType()) : new JvmKotlinType(typeMapper2.mapType(extensionReceiver.getType()), extensionReceiver.getType());
    }

    @Override
    public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
        boolean hasExtensionReceiver;
        if (type2 == null) {
            CallReceiver.$$$reportNull$$$0(12);
        }
        if (v == null) {
            CallReceiver.$$$reportNull$$$0(13);
        }
        StackValue currentExtensionReceiver = this.extensionReceiver;
        boolean bl = hasExtensionReceiver = this.extensionReceiver != CallReceiver.none();
        if (this.extensionReceiver instanceof StackValue.SafeCall) {
            currentExtensionReceiver.put(currentExtensionReceiver.type, currentExtensionReceiver.kotlinType, v);
            currentExtensionReceiver = StackValue.onStack(currentExtensionReceiver.type, currentExtensionReceiver.kotlinType);
        }
        Type dispatchReceiverType = CallReceiver.calcDispatchReceiver(this.secondReceiverType, hasExtensionReceiver, this.dispatchReceiver.type, type2);
        KotlinType dispatchReceiverKotlinType = CallReceiver.calcDispatchReceiver(this.secondReceiverKotlinType, hasExtensionReceiver, this.dispatchReceiver.kotlinType, kotlinType);
        this.dispatchReceiver.put(dispatchReceiverType, dispatchReceiverKotlinType, v);
        currentExtensionReceiver.moveToTopOfStack(hasExtensionReceiver ? type2 : currentExtensionReceiver.type, hasExtensionReceiver ? kotlinType : currentExtensionReceiver.kotlinType, v, dispatchReceiverType.getSize());
    }

    private static <T> T calcDispatchReceiver(T secondType, boolean hasExtensionReceiver, T dispatchReceiverType, T defaultType2) {
        if (secondType != null) {
            return secondType;
        }
        return hasExtensionReceiver ? dispatchReceiverType : defaultType2;
    }

    @Override
    public void dup(@NotNull InstructionAdapter v, boolean withReceiver) {
        if (v == null) {
            CallReceiver.$$$reportNull$$$0(14);
        }
        AsmUtil.dup(v, this.extensionReceiver.type, this.dispatchReceiver.type);
    }

    @NotNull
    public StackValue getDispatchReceiver() {
        StackValue stackValue = this.dispatchReceiver;
        if (stackValue == null) {
            CallReceiver.$$$reportNull$$$0(15);
        }
        return stackValue;
    }

    @NotNull
    public StackValue getExtensionReceiver() {
        StackValue stackValue = this.extensionReceiver;
        if (stackValue == null) {
            CallReceiver.$$$reportNull$$$0(16);
        }
        return stackValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dispatchReceiver";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionReceiver";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codegen";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/CallReceiver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/CallReceiver";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDispatchReceiver";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionReceiver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateCallReceiver";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calcDispatchReceiverType";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "calcExtensionReceiverType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "putSelector";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "dup";
                break;
            }
            case 15: 
            case 16: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

