/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.intrinsics;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethods;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\tH\u0002J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\tH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/codegen/intrinsics/IntrinsicsMap;", "", "()V", "intrinsicsMap", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/codegen/intrinsics/IntrinsicsMap$Key;", "Lorg/jetbrains/kotlin/codegen/intrinsics/IntrinsicMethod;", "getIntrinsic", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "getKey", "getReceiverParameterFqName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "registerIntrinsic", "", "owner", "Lorg/jetbrains/kotlin/name/FqName;", "receiverParameter", "name", "", "valueParameterCount", "", "impl", "valueParameterCountForKey", "member", "Key", "backend"})
public final class IntrinsicsMap {
    @NotNull
    private final HashMap<Key, IntrinsicMethod> intrinsicsMap = new HashMap();

    private final int valueParameterCountForKey(CallableMemberDescriptor member2) {
        return member2 instanceof PropertyDescriptor ? -1 : member2.getValueParameters().size();
    }

    public final void registerIntrinsic(@NotNull FqName owner, @Nullable FqNameUnsafe receiverParameter, @NotNull String name2, int valueParameterCount, @NotNull IntrinsicMethod impl) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(impl, "impl");
        Map map2 = this.intrinsicsMap;
        Object object = owner.toUnsafe();
        Intrinsics.checkNotNullExpressionValue(object, "owner.toUnsafe()");
        object = new Key((FqNameUnsafe)object, receiverParameter, name2, valueParameterCount);
        map2.put(object, impl);
    }

    @Nullable
    public final IntrinsicMethod getIntrinsic(@NotNull CallableMemberDescriptor descriptor2) {
        IntrinsicMethod intrinsicMethod;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        IntrinsicMethod intrinsicMethod2 = this.intrinsicsMap.get(this.getKey(descriptor2));
        if (intrinsicMethod2 == null) {
            intrinsicMethod = null;
        } else {
            IntrinsicMethod intrinsicMethod3;
            IntrinsicMethod it = intrinsicMethod3 = intrinsicMethod2;
            boolean bl = false;
            intrinsicMethod = it.isApplicableToOverload(descriptor2.getOriginal()) ? intrinsicMethod3 : null;
        }
        return intrinsicMethod;
    }

    private final Key getKey(CallableMemberDescriptor descriptor2) {
        Object object = DescriptorUtils.getFqName(descriptor2.getContainingDeclaration());
        Intrinsics.checkNotNullExpressionValue(object, "getFqName(descriptor.containingDeclaration)");
        FqNameUnsafe fqNameUnsafe = object;
        FqNameUnsafe fqNameUnsafe2 = this.getReceiverParameterFqName(descriptor2);
        object = descriptor2.getName().asString();
        Intrinsics.checkNotNullExpressionValue(object, "descriptor.name.asString()");
        return new Key(fqNameUnsafe, fqNameUnsafe2, (String)object, this.valueParameterCountForKey(descriptor2));
    }

    private final FqNameUnsafe getReceiverParameterFqName(CallableMemberDescriptor descriptor2) {
        DeclarationDescriptorNonRoot declarationDescriptorNonRoot = descriptor2.getExtensionReceiverParameter();
        if (declarationDescriptorNonRoot == null) {
            return null;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = declarationDescriptorNonRoot;
        ReceiverParameterDescriptor receiverParameter = receiverParameterDescriptor;
        ClassifierDescriptor classifierDescriptor = receiverParameter.getType().getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return null;
        }
        declarationDescriptorNonRoot = classifierDescriptor;
        DeclarationDescriptorNonRoot classifier2 = declarationDescriptorNonRoot;
        return classifier2 instanceof TypeParameterDescriptor ? IntrinsicMethods.RECEIVER_PARAMETER_FQ_NAME : DescriptorUtils.getFqName(classifier2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\n\u001a\u00020\u0003H\u00c2\u0003J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\t\u0010\f\u001a\u00020\u0006H\u00c2\u0003J\t\u0010\r\u001a\u00020\bH\u00c2\u0003J3\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0006H\u00d6\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/codegen/intrinsics/IntrinsicsMap$Key;", "", "owner", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "receiverParameter", "name", "", "valueParameterCount", "", "(Lorg/jetbrains/kotlin/name/FqNameUnsafe;Lorg/jetbrains/kotlin/name/FqNameUnsafe;Ljava/lang/String;I)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "backend"})
    private static final class Key {
        @NotNull
        private final FqNameUnsafe owner;
        @Nullable
        private final FqNameUnsafe receiverParameter;
        @NotNull
        private final String name;
        private final int valueParameterCount;

        public Key(@NotNull FqNameUnsafe owner, @Nullable FqNameUnsafe receiverParameter, @NotNull String name2, int valueParameterCount) {
            Intrinsics.checkNotNullParameter(owner, "owner");
            Intrinsics.checkNotNullParameter(name2, "name");
            this.owner = owner;
            this.receiverParameter = receiverParameter;
            this.name = name2;
            this.valueParameterCount = valueParameterCount;
        }

        @NotNull
        public final Key copy(@NotNull FqNameUnsafe owner, @Nullable FqNameUnsafe receiverParameter, @NotNull String name2, int valueParameterCount) {
            Intrinsics.checkNotNullParameter(owner, "owner");
            Intrinsics.checkNotNullParameter(name2, "name");
            return new Key(owner, receiverParameter, name2, valueParameterCount);
        }

        public static /* synthetic */ Key copy$default(Key key, FqNameUnsafe fqNameUnsafe, FqNameUnsafe fqNameUnsafe2, String string2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                fqNameUnsafe = key.owner;
            }
            if ((n2 & 2) != 0) {
                fqNameUnsafe2 = key.receiverParameter;
            }
            if ((n2 & 4) != 0) {
                string2 = key.name;
            }
            if ((n2 & 8) != 0) {
                n = key.valueParameterCount;
            }
            return key.copy(fqNameUnsafe, fqNameUnsafe2, string2, n);
        }

        @NotNull
        public String toString() {
            return "Key(owner=" + this.owner + ", receiverParameter=" + this.receiverParameter + ", name=" + this.name + ", valueParameterCount=" + this.valueParameterCount + ')';
        }

        public int hashCode() {
            int result2 = this.owner.hashCode();
            result2 = result2 * 31 + (this.receiverParameter == null ? 0 : this.receiverParameter.hashCode());
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.valueParameterCount);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key key = (Key)other;
            if (!Intrinsics.areEqual(this.owner, key.owner)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.receiverParameter, key.receiverParameter)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.name, key.name)) {
                return false;
            }
            return this.valueParameterCount == key.valueParameterCount;
        }
    }
}

