/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.collect;

import java.util.Comparator;
import org.jetbrains.kotlin.com.google.common.annotations.GwtIncompatible;
import org.jetbrains.kotlin.com.google.common.annotations.VisibleForTesting;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.BoundType;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSortedMultiset;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSortedSet;
import org.jetbrains.kotlin.com.google.common.collect.Multiset;
import org.jetbrains.kotlin.com.google.common.collect.Multisets;
import org.jetbrains.kotlin.com.google.common.collect.Ordering;
import org.jetbrains.kotlin.com.google.common.collect.RegularImmutableSortedSet;
import org.jetbrains.kotlin.com.google.common.primitives.Ints;

@GwtIncompatible
final class RegularImmutableSortedMultiset<E>
extends ImmutableSortedMultiset<E> {
    private static final long[] ZERO_CUMULATIVE_COUNTS = new long[]{0L};
    static final ImmutableSortedMultiset<Comparable> NATURAL_EMPTY_MULTISET = new RegularImmutableSortedMultiset(Ordering.natural());
    @VisibleForTesting
    final transient RegularImmutableSortedSet<E> elementSet;
    private final transient long[] cumulativeCounts;
    private final transient int offset;
    private final transient int length;

    RegularImmutableSortedMultiset(Comparator<? super E> comparator) {
        this.elementSet = ImmutableSortedSet.emptySet(comparator);
        this.cumulativeCounts = ZERO_CUMULATIVE_COUNTS;
        this.offset = 0;
        this.length = 0;
    }

    RegularImmutableSortedMultiset(RegularImmutableSortedSet<E> elementSet, long[] cumulativeCounts, int offset2, int length) {
        this.elementSet = elementSet;
        this.cumulativeCounts = cumulativeCounts;
        this.offset = offset2;
        this.length = length;
    }

    private int getCount(int index2) {
        return (int)(this.cumulativeCounts[this.offset + index2 + 1] - this.cumulativeCounts[this.offset + index2]);
    }

    @Override
    Multiset.Entry<E> getEntry(int index2) {
        return Multisets.immutableEntry(this.elementSet.asList().get(index2), this.getCount(index2));
    }

    @Override
    public Multiset.Entry<E> firstEntry() {
        return this.isEmpty() ? null : this.getEntry(0);
    }

    @Override
    public Multiset.Entry<E> lastEntry() {
        return this.isEmpty() ? null : this.getEntry(this.length - 1);
    }

    @Override
    public int count(Object element) {
        int index2 = this.elementSet.indexOf(element);
        return index2 >= 0 ? this.getCount(index2) : 0;
    }

    @Override
    public int size() {
        long size = this.cumulativeCounts[this.offset + this.length] - this.cumulativeCounts[this.offset];
        return Ints.saturatedCast(size);
    }

    @Override
    public ImmutableSortedSet<E> elementSet() {
        return this.elementSet;
    }

    @Override
    public ImmutableSortedMultiset<E> headMultiset(E upperBound, BoundType boundType) {
        return this.getSubMultiset(0, this.elementSet.headIndex(upperBound, Preconditions.checkNotNull(boundType) == BoundType.CLOSED));
    }

    @Override
    public ImmutableSortedMultiset<E> tailMultiset(E lowerBound, BoundType boundType) {
        return this.getSubMultiset(this.elementSet.tailIndex(lowerBound, Preconditions.checkNotNull(boundType) == BoundType.CLOSED), this.length);
    }

    ImmutableSortedMultiset<E> getSubMultiset(int from2, int to) {
        Preconditions.checkPositionIndexes(from2, to, this.length);
        if (from2 == to) {
            return RegularImmutableSortedMultiset.emptyMultiset(this.comparator());
        }
        if (from2 == 0 && to == this.length) {
            return this;
        }
        RegularImmutableSortedSet<E> subElementSet = this.elementSet.getSubSet(from2, to);
        return new RegularImmutableSortedMultiset<E>(subElementSet, this.cumulativeCounts, this.offset + from2, to - from2);
    }

    @Override
    boolean isPartialView() {
        return this.offset > 0 || this.length < this.cumulativeCounts.length - 1;
    }
}

