/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.internal;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableList;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.google.common.collect.Ordering;
import org.jetbrains.kotlin.com.google.common.primitives.Primitives;
import org.jetbrains.kotlin.com.google.inject.Binding;
import org.jetbrains.kotlin.com.google.inject.ConfigurationException;
import org.jetbrains.kotlin.com.google.inject.CreationException;
import org.jetbrains.kotlin.com.google.inject.Injector;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.ProvisionException;
import org.jetbrains.kotlin.com.google.inject.Scope;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.com.google.inject.internal.ErrorsException;
import org.jetbrains.kotlin.com.google.inject.internal.InternalProvisionException;
import org.jetbrains.kotlin.com.google.inject.internal.Messages;
import org.jetbrains.kotlin.com.google.inject.internal.util.SourceProvider;
import org.jetbrains.kotlin.com.google.inject.spi.ElementSource;
import org.jetbrains.kotlin.com.google.inject.spi.Message;
import org.jetbrains.kotlin.com.google.inject.spi.ScopeBinding;
import org.jetbrains.kotlin.com.google.inject.spi.TypeConverterBinding;
import org.jetbrains.kotlin.com.google.inject.spi.TypeListenerBinding;

public final class Errors
implements Serializable {
    private static final int MAX_MATCHING_TYPES_REPORTED = 3;
    private static final int MAX_RELATED_TYPES_REPORTED = 3;
    private static final ImmutableSet<Class<?>> COMMON_AMBIGUOUS_TYPES = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(Object.class)).add(String.class)).addAll(Primitives.allWrapperTypes())).build();
    private final Errors root;
    private final Errors parent;
    private final Object source;
    private List<Message> errors;
    private static final String CONSTRUCTOR_RULES = "Classes must have either one (and only one) constructor annotated with @Inject or a zero-argument constructor that is not private.";

    static <T> T checkNotNull(T reference, String name2) {
        if (reference != null) {
            return reference;
        }
        NullPointerException npe = new NullPointerException(name2);
        throw new ConfigurationException(ImmutableSet.of(new Message(npe.toString(), npe)));
    }

    static void checkConfiguration(boolean condition, String format2, Object ... args2) {
        if (condition) {
            return;
        }
        throw new ConfigurationException(ImmutableSet.of(new Message(Errors.format(format2, args2))));
    }

    public Errors() {
        this.root = this;
        this.parent = null;
        this.source = SourceProvider.UNKNOWN_SOURCE;
    }

    public Errors(Object source) {
        this.root = this;
        this.parent = null;
        this.source = source;
    }

    private Errors(Errors parent2, Object source) {
        this.root = parent2.root;
        this.parent = parent2;
        this.source = source;
    }

    public Errors withSource(Object source) {
        return source == this.source || source == SourceProvider.UNKNOWN_SOURCE ? this : new Errors(this, source);
    }

    public Errors missingImplementation(Key key) {
        return this.addMessage("No implementation for %s was bound.", key);
    }

    <T> Errors missingImplementationWithHint(Key<T> key, Injector injector) {
        StringBuilder sb = new StringBuilder();
        sb.append(Errors.format("No implementation for %s was bound.", key));
        ArrayList<String> possibleMatches = new ArrayList<String>();
        TypeLiteral<T> type2 = key.getTypeLiteral();
        List<Binding<T>> sameTypes = injector.findBindingsByType(type2);
        if (!sameTypes.isEmpty()) {
            sb.append(Errors.format("%n  Did you mean?", new Object[0]));
            int howMany = Math.min(sameTypes.size(), 3);
            for (int i = 0; i < howMany; ++i) {
                sb.append(Errors.format("%n    * %s", sameTypes.get(i).getKey()));
            }
            int remaining = sameTypes.size() - 3;
            if (remaining > 0) {
                String plural = remaining == 1 ? "" : "s";
                sb.append(Errors.format("%n    %d more binding%s with other annotations.", remaining, plural));
            }
        } else {
            String want = type2.toString();
            Map<Key<?>, Binding<?>> bindingMap = injector.getAllBindings();
            for (Key<?> bindingKey : bindingMap.keySet()) {
                String have = bindingKey.getTypeLiteral().toString();
                if (!have.contains(want) && !want.contains(have)) continue;
                Formatter fmt = new Formatter();
                Messages.formatSource(fmt, bindingMap.get(bindingKey).getSource());
                String match2 = String.format("%s bound%s", Errors.convert(bindingKey), fmt.toString());
                possibleMatches.add(match2);
                if (possibleMatches.size() <= 3) continue;
                break;
            }
            if (possibleMatches.size() > 0 && possibleMatches.size() <= 3) {
                sb.append(Errors.format("%n  Did you mean?", new Object[0]));
                for (String possibleMatch : possibleMatches) {
                    sb.append(Errors.format("%n    %s", possibleMatch));
                }
            }
        }
        if (sameTypes.isEmpty() && possibleMatches.isEmpty() && key.getAnnotation() == null && COMMON_AMBIGUOUS_TYPES.contains(key.getTypeLiteral().getRawType())) {
            sb.append(Errors.format("%nThe key seems very generic, did you forget an annotation?", new Object[0]));
        }
        return this.addMessage(sb.toString(), new Object[0]);
    }

    public Errors jitDisabled(Key<?> key) {
        return this.addMessage("Explicit bindings are required and %s is not explicitly bound.", key);
    }

    public Errors jitDisabledInParent(Key<?> key) {
        return this.addMessage("Explicit bindings are required and %s would be bound in a parent injector.%nPlease add an explicit binding for it, either in the child or the parent.", key);
    }

    public Errors atInjectRequired(Class clazz) {
        return this.addMessage("Explicit @Inject annotations are required on constructors, but %s has no constructors annotated with @Inject.", clazz);
    }

    public Errors converterReturnedNull(String stringValue, Object source, TypeLiteral<?> type2, TypeConverterBinding typeConverterBinding) {
        return this.addMessage("Received null converting '%s' (bound at %s) to %s%n using %s.", stringValue, Errors.convert(source), type2, typeConverterBinding);
    }

    public Errors conversionTypeError(String stringValue, Object source, TypeLiteral<?> type2, TypeConverterBinding typeConverterBinding, Object converted) {
        return this.addMessage("Type mismatch converting '%s' (bound at %s) to %s%n using %s.%n Converter returned %s.", stringValue, Errors.convert(source), type2, typeConverterBinding, converted);
    }

    public Errors conversionError(String stringValue, Object source, TypeLiteral<?> type2, TypeConverterBinding typeConverterBinding, RuntimeException cause) {
        return this.errorInUserCode(cause, "Error converting '%s' (bound at %s) to %s%n using %s.%n Reason: %s", stringValue, Errors.convert(source), type2, typeConverterBinding, cause);
    }

    public Errors ambiguousTypeConversion(String stringValue, Object source, TypeLiteral<?> type2, TypeConverterBinding a, TypeConverterBinding b) {
        return this.addMessage("Multiple converters can convert '%s' (bound at %s) to %s:%n %s and%n %s.%n Please adjust your type converter configuration to avoid overlapping matches.", stringValue, Errors.convert(source), type2, a, b);
    }

    public Errors bindingToProvider() {
        return this.addMessage("Binding to Provider is not allowed.", new Object[0]);
    }

    public Errors notASubtype(Class<?> implementationType, Class<?> type2) {
        return this.addMessage("%s doesn't extend %s.", implementationType, type2);
    }

    public Errors recursiveImplementationType() {
        return this.addMessage("@ImplementedBy points to the same class it annotates.", new Object[0]);
    }

    public Errors recursiveProviderType() {
        return this.addMessage("@ProvidedBy points to the same class it annotates.", new Object[0]);
    }

    public Errors missingRuntimeRetention(Class<? extends Annotation> annotation2) {
        return this.addMessage(Errors.format("Please annotate %s with @Retention(RUNTIME).", annotation2), new Object[0]);
    }

    public Errors missingScopeAnnotation(Class<? extends Annotation> annotation2) {
        return this.addMessage(Errors.format("Please annotate %s with @ScopeAnnotation.", annotation2), new Object[0]);
    }

    public Errors optionalConstructor(Constructor constructor2) {
        return this.addMessage("%s is annotated @Inject(optional=true), but constructors cannot be optional.", constructor2);
    }

    public Errors cannotBindToGuiceType(String simpleName2) {
        return this.addMessage("Binding to core guice framework type is not allowed: %s.", simpleName2);
    }

    public Errors scopeNotFound(Class<? extends Annotation> scopeAnnotation) {
        return this.addMessage("No scope is bound to %s.", scopeAnnotation);
    }

    public Errors scopeAnnotationOnAbstractType(Class<? extends Annotation> scopeAnnotation, Class<?> type2, Object source) {
        return this.addMessage("%s is annotated with %s, but scope annotations are not supported for abstract types.%n Bound at %s.", type2, scopeAnnotation, Errors.convert(source));
    }

    public Errors misplacedBindingAnnotation(Member member2, Annotation bindingAnnotation) {
        return this.addMessage("%s is annotated with %s, but binding annotations should be applied to its parameters instead.", member2, bindingAnnotation);
    }

    public Errors missingConstructor(Class<?> implementation2) {
        return this.addMessage("Could not find a suitable constructor in %s. Classes must have either one (and only one) constructor annotated with @Inject or a zero-argument constructor that is not private.", implementation2);
    }

    public Errors tooManyConstructors(Class<?> implementation2) {
        return this.addMessage("%s has more than one constructor annotated with @Inject. Classes must have either one (and only one) constructor annotated with @Inject or a zero-argument constructor that is not private.", implementation2);
    }

    public Errors constructorNotDefinedByType(Constructor<?> constructor2, TypeLiteral<?> type2) {
        return this.addMessage("%s does not define %s", type2, constructor2);
    }

    public Errors duplicateScopes(ScopeBinding existing, Class<? extends Annotation> annotationType, Scope scope2) {
        return this.addMessage("Scope %s is already bound to %s at %s.%n Cannot bind %s.", existing.getScope(), annotationType, existing.getSource(), scope2);
    }

    public Errors voidProviderMethod() {
        return this.addMessage("Provider methods must return a value. Do not return void.", new Object[0]);
    }

    public Errors missingConstantValues() {
        return this.addMessage("Missing constant value. Please call to(...).", new Object[0]);
    }

    public Errors cannotInjectInnerClass(Class<?> type2) {
        return this.addMessage("Injecting into inner classes is not supported.  Please use a 'static' class (top-level or nested) instead of %s.", type2);
    }

    public Errors duplicateBindingAnnotations(Member member2, Class<? extends Annotation> a, Class<? extends Annotation> b) {
        return this.addMessage("%s has more than one annotation annotated with @BindingAnnotation: %s and %s", member2, a, b);
    }

    public Errors staticInjectionOnInterface(Class<?> clazz) {
        return this.addMessage("%s is an interface, but interfaces have no static injection points.", clazz);
    }

    public Errors cannotInjectFinalField(Field field2) {
        return this.addMessage("Injected field %s cannot be final.", field2);
    }

    public Errors cannotInjectAbstractMethod(Method method) {
        return this.addMessage("Injected method %s cannot be abstract.", method);
    }

    public Errors cannotInjectNonVoidMethod(Method method) {
        return this.addMessage("Injected method %s must return void.", method);
    }

    public Errors cannotInjectMethodWithTypeParameters(Method method) {
        return this.addMessage("Injected method %s cannot declare type parameters of its own.", method);
    }

    public Errors duplicateScopeAnnotations(Class<? extends Annotation> a, Class<? extends Annotation> b) {
        return this.addMessage("More than one scope annotation was found: %s and %s.", a, b);
    }

    public Errors recursiveBinding() {
        return this.addMessage("Binding points to itself.", new Object[0]);
    }

    public Errors bindingAlreadySet(Key<?> key, Object source) {
        return this.addMessage("A binding to %s was already configured at %s.", key, Errors.convert(source));
    }

    public Errors jitBindingAlreadySet(Key<?> key) {
        return this.addMessage("A just-in-time binding to %s was already configured on a parent injector.", key);
    }

    public Errors childBindingAlreadySet(Key<?> key, Set<Object> sources) {
        Formatter allSources = new Formatter();
        for (Object source : sources) {
            if (source == null) {
                allSources.format("%n    (bound by a just-in-time binding)", new Object[0]);
                continue;
            }
            allSources.format("%n    bound at %s", source);
        }
        Errors errors = this.addMessage("Unable to create binding for %s. It was already configured on one or more child injectors or private modules%s%n  If it was in a PrivateModule, did you forget to expose the binding?", key, allSources.out());
        return errors;
    }

    public Errors errorCheckingDuplicateBinding(Key<?> key, Object source, Throwable t) {
        return this.addMessage("A binding to %s was already configured at %s and an error was thrown while checking duplicate bindings.  Error: %s", key, Errors.convert(source), t);
    }

    public Errors errorNotifyingTypeListener(TypeListenerBinding listener, TypeLiteral<?> type2, Throwable cause) {
        return this.errorInUserCode(cause, "Error notifying TypeListener %s (bound at %s) of %s.%n Reason: %s", listener.getListener(), Errors.convert(listener.getSource()), type2, cause);
    }

    public Errors exposedButNotBound(Key<?> key) {
        return this.addMessage("Could not expose() %s, it must be explicitly bound.", key);
    }

    public Errors keyNotFullySpecified(TypeLiteral<?> typeLiteral) {
        return this.addMessage("%s cannot be used as a key; It is not fully specified.", typeLiteral);
    }

    public Errors errorEnhancingClass(Class<?> clazz, Throwable cause) {
        return this.errorInUserCode(cause, "Unable to method intercept: %s", clazz);
    }

    public static Collection<Message> getMessagesFromThrowable(Throwable throwable) {
        if (throwable instanceof ProvisionException) {
            return ((ProvisionException)throwable).getErrorMessages();
        }
        if (throwable instanceof ConfigurationException) {
            return ((ConfigurationException)throwable).getErrorMessages();
        }
        if (throwable instanceof CreationException) {
            return ((CreationException)throwable).getErrorMessages();
        }
        return ImmutableSet.of();
    }

    public Errors errorInUserCode(Throwable cause, String messageFormat, Object ... arguments2) {
        Collection<Message> messages = Errors.getMessagesFromThrowable(cause);
        if (!messages.isEmpty()) {
            return this.merge(messages);
        }
        return this.addMessage(cause, messageFormat, arguments2);
    }

    public Errors cannotInjectRawProvider() {
        return this.addMessage("Cannot inject a Provider that has no type parameter", new Object[0]);
    }

    public Errors cannotInjectRawMembersInjector() {
        return this.addMessage("Cannot inject a MembersInjector that has no type parameter", new Object[0]);
    }

    public Errors cannotInjectTypeLiteralOf(Type unsupportedType) {
        return this.addMessage("Cannot inject a TypeLiteral of %s", unsupportedType);
    }

    public Errors cannotInjectRawTypeLiteral() {
        return this.addMessage("Cannot inject a TypeLiteral that has no type parameter", new Object[0]);
    }

    public void throwCreationExceptionIfErrorsExist() {
        if (!this.hasErrors()) {
            return;
        }
        throw new CreationException(this.getMessages());
    }

    public void throwConfigurationExceptionIfErrorsExist() {
        if (!this.hasErrors()) {
            return;
        }
        throw new ConfigurationException(this.getMessages());
    }

    public void throwProvisionExceptionIfErrorsExist() {
        if (!this.hasErrors()) {
            return;
        }
        throw new ProvisionException(this.getMessages());
    }

    public Errors merge(Collection<Message> messages) {
        List<Object> sources = this.getSources();
        for (Message message2 : messages) {
            this.addMessage(Messages.mergeSources(sources, message2));
        }
        return this;
    }

    public Errors merge(Errors moreErrors) {
        if (moreErrors.root == this.root || moreErrors.root.errors == null) {
            return this;
        }
        this.merge(moreErrors.root.errors);
        return this;
    }

    public Errors merge(InternalProvisionException ipe) {
        this.merge(ipe.getErrors());
        return this;
    }

    private List<Object> getSources() {
        ArrayList<Object> sources = Lists.newArrayList();
        Errors e = this;
        while (e != null) {
            if (e.source != SourceProvider.UNKNOWN_SOURCE) {
                sources.add(0, e.source);
            }
            e = e.parent;
        }
        return sources;
    }

    public void throwIfNewErrors(int expectedSize) throws ErrorsException {
        if (this.size() == expectedSize) {
            return;
        }
        throw this.toException();
    }

    public ErrorsException toException() {
        return new ErrorsException(this);
    }

    public boolean hasErrors() {
        return this.root.errors != null;
    }

    public Errors addMessage(String messageFormat, Object ... arguments2) {
        return this.addMessage(null, messageFormat, arguments2);
    }

    private Errors addMessage(Throwable cause, String messageFormat, Object ... arguments2) {
        this.addMessage(Messages.create(cause, this.getSources(), messageFormat, arguments2));
        return this;
    }

    public Errors addMessage(Message message2) {
        if (this.root.errors == null) {
            this.root.errors = Lists.newArrayList();
        }
        this.root.errors.add(message2);
        return this;
    }

    public static String format(String messageFormat, Object ... arguments2) {
        return Messages.format(messageFormat, arguments2);
    }

    public List<Message> getMessages() {
        if (this.root.errors == null) {
            return ImmutableList.of();
        }
        return new Ordering<Message>(){

            @Override
            public int compare(Message a, Message b) {
                return a.getSource().compareTo(b.getSource());
            }
        }.sortedCopy(this.root.errors);
    }

    public int size() {
        return this.root.errors == null ? 0 : this.root.errors.size();
    }

    public static Object convert(Object o) {
        return Messages.convert(o);
    }

    public static Object convert(Object o, ElementSource source) {
        return Messages.convert(o, source);
    }

    public static void formatSource(Formatter formatter, Object source) {
        Messages.formatSource(formatter, source);
    }
}

