/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.roots.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.VolatileNotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;

public class PackageDirectoryCache {
    private static final Logger LOG = Logger.getInstance(PackageDirectoryCache.class);
    private final MultiMap<String, VirtualFile> myRootsByPackagePrefix;
    private final Map<String, PackageInfo> myDirectoriesByPackageNameCache;
    private final Set<String> myNonExistentPackages;

    public PackageDirectoryCache(@NotNull MultiMap<String, VirtualFile> rootsByPackagePrefix) {
        if (rootsByPackagePrefix == null) {
            PackageDirectoryCache.$$$reportNull$$$0(0);
        }
        this.myRootsByPackagePrefix = MultiMap.create();
        this.myDirectoriesByPackageNameCache = new ConcurrentHashMap<String, PackageInfo>();
        this.myNonExistentPackages = Collections.newSetFromMap(new ConcurrentHashMap());
        for (String prefix : rootsByPackagePrefix.keySet()) {
            for (VirtualFile file2 : rootsByPackagePrefix.get(prefix)) {
                if (!file2.isValid()) {
                    LOG.error("Invalid root: " + file2);
                    continue;
                }
                this.myRootsByPackagePrefix.putValue(prefix, file2);
            }
        }
    }

    @NotNull
    public List<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName) {
        PackageInfo info;
        if (packageName == null) {
            PackageDirectoryCache.$$$reportNull$$$0(1);
        }
        List<VirtualFile> list2 = (info = this.getPackageInfo(packageName)) == null ? Collections.emptyList() : Collections.unmodifiableList(info.myPackageDirectories);
        if (list2 == null) {
            PackageDirectoryCache.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Nullable
    private PackageInfo getPackageInfo(@NotNull String packageName) {
        PackageInfo info;
        if (packageName == null) {
            PackageDirectoryCache.$$$reportNull$$$0(3);
        }
        if ((info = this.myDirectoriesByPackageNameCache.get(packageName)) == null && !this.myNonExistentPackages.contains(packageName)) {
            if (packageName.length() > Registry.intValue("java.max.package.name.length") || StringUtil.containsAnyChar(packageName, ";[/")) {
                return null;
            }
            SmartList<VirtualFile> result2 = new SmartList<VirtualFile>();
            if (StringUtil.isNotEmpty(packageName) && !StringUtil.startsWithChar(packageName, '.')) {
                int i = packageName.lastIndexOf(46);
                while (true) {
                    PackageInfo parentInfo;
                    if ((parentInfo = this.getPackageInfo(i > 0 ? packageName.substring(0, i) : "")) != null) {
                        result2.addAll(parentInfo.getSubPackageDirectories(packageName.substring(i + 1)));
                    }
                    if (i < 0) break;
                    i = packageName.lastIndexOf(46, i - 1);
                    ProgressManager.checkCanceled();
                }
            }
            for (VirtualFile file2 : this.myRootsByPackagePrefix.get(packageName)) {
                if (!file2.isDirectory() || !file2.isValid()) continue;
                result2.add(file2);
            }
            if (!result2.isEmpty()) {
                info = new PackageInfo(packageName, result2);
                this.myDirectoriesByPackageNameCache.put(packageName, info);
            } else {
                this.myNonExistentPackages.add(packageName);
            }
        }
        return info;
    }

    @NotNull
    public Set<String> getSubpackageNames(@NotNull String packageName) {
        PackageInfo info;
        if (packageName == null) {
            PackageDirectoryCache.$$$reportNull$$$0(4);
        }
        Set<String> set = (info = this.getPackageInfo(packageName)) == null ? Collections.emptySet() : Collections.unmodifiableSet(info.mySubPackages.getValue().keySet());
        if (set == null) {
            PackageDirectoryCache.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public static PackageDirectoryCache createCache(@NotNull List<? extends VirtualFile> roots2) {
        if (roots2 == null) {
            PackageDirectoryCache.$$$reportNull$$$0(10);
        }
        MultiMap<String, VirtualFile> map2 = MultiMap.create();
        map2.putValues("", roots2);
        return new PackageDirectoryCache(map2);
    }

    protected boolean isPackageDirectory(@NotNull VirtualFile dir, @NotNull String packageName) {
        if (dir == null) {
            PackageDirectoryCache.$$$reportNull$$$0(11);
        }
        if (packageName == null) {
            PackageDirectoryCache.$$$reportNull$$$0(12);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsByPackagePrefix";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/roots/impl/PackageDirectoryCache";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/roots/impl/PackageDirectoryCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoriesByPackageName";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubpackageNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoriesByPackageName";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPackageInfo";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSubpackageNames";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createCache";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isPackageDirectory";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class PackageInfo {
        @NotNull
        final String myQname;
        @NotNull
        final List<? extends VirtualFile> myPackageDirectories;
        final NotNullLazyValue<MultiMap<String, VirtualFile>> mySubPackages;

        PackageInfo(@NotNull String qname, List<? extends VirtualFile> packageDirectories) {
            if (qname == null) {
                PackageInfo.$$$reportNull$$$0(0);
            }
            if (packageDirectories == null) {
                PackageInfo.$$$reportNull$$$0(1);
            }
            this.mySubPackages = new VolatileNotNullLazyValue<MultiMap<String, VirtualFile>>(){

                @Override
                @NotNull
                protected MultiMap<String, VirtualFile> compute() {
                    MultiMap<String, VirtualFile> result2 = MultiMap.createLinked();
                    for (VirtualFile virtualFile2 : PackageInfo.this.myPackageDirectories) {
                        ProgressManager.checkCanceled();
                        for (VirtualFile child : virtualFile2.getChildren()) {
                            String packageName;
                            String childName = child.getName();
                            String string2 = packageName = PackageInfo.this.myQname.isEmpty() ? childName : PackageInfo.this.myQname + "." + childName;
                            if (!child.isDirectory() || !PackageDirectoryCache.this.isPackageDirectory(child, packageName)) continue;
                            result2.putValue(childName, child);
                        }
                    }
                    MultiMap<String, VirtualFile> multiMap = result2;
                    if (multiMap == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return multiMap;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/roots/impl/PackageDirectoryCache$PackageInfo$1", "compute"));
                }
            };
            this.myQname = qname;
            this.myPackageDirectories = packageDirectories;
        }

        @NotNull
        Collection<VirtualFile> getSubPackageDirectories(String shortName) {
            Collection<VirtualFile> collection = this.mySubPackages.getValue().get(shortName);
            if (collection == null) {
                PackageInfo.$$$reportNull$$$0(2);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qname";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageDirectories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/roots/impl/PackageDirectoryCache$PackageInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/roots/impl/PackageDirectoryCache$PackageInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubPackageDirectories";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

