/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationCheckerUtilsKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMemberFunctionsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkFunction", "containingDeclaration", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "checkers"})
public final class FirMemberFunctionsChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirMemberFunctionsChecker INSTANCE = new FirMemberFunctionsChecker();

    private FirMemberFunctionsChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter2, "reporter");
        for (FirDeclaration member2 : declaration2.getDeclarations()) {
            if (!(member2 instanceof FirSimpleFunction)) continue;
            this.checkFunction(declaration2, (FirSimpleFunction)member2, context2, reporter2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkFunction(FirClass containingDeclaration, FirSimpleFunction function, CheckerContext context, DiagnosticReporter reporter) {
        block13: {
            block14: {
                var6_5 = function.getSource();
                if (var6_5 == null) {
                    return;
                }
                source = var6_5;
                if (source.getKind() instanceof FirFakeSourceElementKind) {
                    return;
                }
                functionSymbol = function.getSymbol();
                modifierList = FirKeywordUtilsKt.getModifierList(source);
                var9_8 = KtTokens.ABSTRACT_KEYWORD;
                Intrinsics.checkNotNullExpressionValue(var9_8, "ABSTRACT_KEYWORD");
                hasAbstractModifier = FirKeywordUtilsKt.contains(modifierList, var9_8);
                $this$isAbstract$iv = function;
                $i$f$isAbstract = false;
                v0 = isAbstract = $this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT != false || hasAbstractModifier != false;
                if (!isAbstract) break block13;
                if (!(containingDeclaration instanceof FirRegularClass)) break block14;
                $this$canHaveAbstractDeclaration$iv = (FirRegularClass)containingDeclaration;
                $i$f$getCanHaveAbstractDeclaration = false;
                $this$isAbstract$iv$iv = $this$canHaveAbstractDeclaration$iv;
                $i$f$isAbstract = false;
                if ($this$isAbstract$iv$iv.getStatus().getModality() == Modality.ABSTRACT) ** GOTO lbl-1000
                $this$isSealed$iv$iv = $this$canHaveAbstractDeclaration$iv;
                $i$f$isSealed = false;
                if ($this$isSealed$iv$iv.getStatus().getModality() == Modality.SEALED) ** GOTO lbl-1000
                $this$isEnumClass$iv$iv = $this$canHaveAbstractDeclaration$iv;
                $i$f$isEnumClass = false;
                $this$isEnumClass$iv$iv$iv = $this$isEnumClass$iv$iv.getClassKind();
                $i$f$isEnumClass = false;
                v1 = $this$isEnumClass$iv$iv$iv == ClassKind.ENUM_CLASS;
                if (v1) lbl-1000:
                // 3 sources

                {
                    v2 = true;
                } else {
                    v2 = false;
                }
                if (!v2) {
                    DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getABSTRACT_FUNCTION_IN_NON_ABSTRACT_CLASS(), (Object)functionSymbol, (Object)((FirRegularClass)containingDeclaration).getSymbol(), context, null, 32, null);
                }
            }
            $this$hasBody$iv = function;
            $i$f$getHasBody = false;
            if ($this$hasBody$iv.getBody() != null) {
                DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getABSTRACT_FUNCTION_WITH_BODY(), (Object)functionSymbol, context, null, 16, null);
            }
        }
        isInsideExpectClass = FirDeclarationCheckerUtilsKt.isInsideExpectClass(containingDeclaration, context);
        $this$isEnumClass$iv$iv = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue($this$isEnumClass$iv$iv, "OPEN_KEYWORD");
        hasOpenModifier = FirKeywordUtilsKt.contains(modifierList, (KtModifierKeywordToken)$this$isEnumClass$iv$iv);
        $this$hasBody$iv = function;
        $i$f$getHasBody = false;
        if (!($this$hasBody$iv.getBody() != null)) {
            $this$isInterface$iv = containingDeclaration;
            $i$f$isInterface = false;
            $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
            $i$f$isInterface = false;
            v3 = $this$isInterface$iv$iv == ClassKind.INTERFACE;
            if (v3) {
                $this$visibility$iv = function;
                $i$f$getVisibility = false;
                if (Visibilities.INSTANCE.isPrivate($this$visibility$iv.getStatus().getVisibility())) {
                    DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getPRIVATE_FUNCTION_WITH_NO_BODY(), (Object)functionSymbol, context, null, 16, null);
                }
                if (!isInsideExpectClass && !hasAbstractModifier && hasOpenModifier) {
                    DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getREDUNDANT_OPEN_IN_INTERFACE(), context, null, 8, null);
                }
            } else if (!isInsideExpectClass && !hasAbstractModifier) {
                $this$isExternal$iv = function;
                $i$f$isExternal = false;
                if (!$this$isExternal$iv.getStatus().isExternal()) {
                    DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getNON_ABSTRACT_FUNCTION_WITH_NO_BODY(), (Object)functionSymbol, context, null, 16, null);
                }
            }
        }
        FirDeclarationCheckerUtilsKt.checkExpectDeclarationVisibilityAndBody(function, source, reporter, context);
    }
}

