/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactoryForDeprecation0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArrayOfCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirPartiallyResolvedArgumentList;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirNamedVarargChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirNamedVarargChecker
extends FirExpressionChecker<FirCall> {
    @NotNull
    public static final FirNamedVarargChecker INSTANCE = new FirNamedVarargChecker();

    private FirNamedVarargChecker() {
    }

    @Override
    public void check(@NotNull FirCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter2, "reporter");
        if (!(expression2 instanceof FirFunctionCall || expression2 instanceof FirAnnotationCall || expression2 instanceof FirDelegatedConstructorCall)) {
            return;
        }
        boolean isAnnotation = expression2 instanceof FirAnnotationCall;
        FirDiagnosticFactoryForDeprecation0 errorFactory = isAnnotation ? FirErrors.INSTANCE.getASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_ANNOTATION() : FirErrors.INSTANCE.getASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_FUNCTION();
        boolean allowAssignArray = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(isAnnotation ? LanguageFeature.AssigningArraysToVarargsInNamedFormInAnnotations : LanguageFeature.AllowAssigningArrayElementsToVarargsInNamedFormForFunctions);
        FirCall entry = expression2;
        boolean $i$f$getArgumentMapping = false;
        FirArgumentList argumentList$iv = entry.getArgumentList();
        LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : (argumentList$iv instanceof FirPartiallyResolvedArgumentList ? ((FirPartiallyResolvedArgumentList)argumentList$iv).getMapping() : null);
        if (linkedHashMap == null) {
            return;
        }
        LinkedHashMap<FirExpression, FirValueParameter> argumentMap = linkedHashMap;
        for (Map.Entry entry2 : ((Map)argumentMap).entrySet()) {
            FirExpression argument2 = (FirExpression)entry2.getKey();
            FirValueParameter parameter = (FirValueParameter)entry2.getValue();
            if (!parameter.isVararg()) continue;
            if (argument2 instanceof FirVarargArgumentsExpression) {
                Iterable $this$forEach$iv = ((FirVarargArgumentsExpression)argument2).getArguments();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirExpression p0 = (FirExpression)element$iv;
                    boolean bl = false;
                    FirNamedVarargChecker.check$checkArgument(allowAssignArray, reporter2, errorFactory, context2, p0);
                }
                continue;
            }
            FirNamedVarargChecker.check$checkArgument(allowAssignArray, reporter2, errorFactory, context2, argument2);
        }
    }

    private static final void check$checkArgument(boolean allowAssignArray, DiagnosticReporter $reporter, FirDiagnosticFactoryForDeprecation0 errorFactory, CheckerContext $context, FirExpression argument2) {
        if (!(argument2 instanceof FirNamedArgumentExpression)) {
            return;
        }
        if (((FirNamedArgumentExpression)argument2).isSpread()) {
            return;
        }
        FirTypeRef typeRef = ((FirNamedArgumentExpression)argument2).getExpression().getTypeRef();
        if (typeRef instanceof FirErrorTypeRef) {
            return;
        }
        if (((FirNamedArgumentExpression)argument2).getExpression() instanceof FirArrayOfCall) {
            return;
        }
        if (allowAssignArray && FirTypeUtilsKt.isArrayType(typeRef)) {
            return;
        }
        DiagnosticReporterKt.reportOn$default($reporter, ((FirNamedArgumentExpression)argument2).getExpression().getSource(), errorFactory, $context, null, 8, null);
    }
}

