/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.IrFileSerializer;
import org.jetbrains.kotlin.backend.common.serialization.proto.PirBodyCarrier;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.persistent.PersistentIrBodyBase;
import org.jetbrains.kotlin.ir.declarations.persistent.PersistentIrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.persistent.PersistentIrElementBase;
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.AnonymousInitializerCarrier;
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.BodyCarrier;
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.Carrier;
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.ClassCarrier;
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.ConstructorCarrier;
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.EnumEntryCarrier;
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.ErrorDeclarationCarrier;
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.FieldCarrier;
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.FunctionCarrier;
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.LocalDelegatedPropertyCarrier;
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.PropertyCarrier;
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.TypeAliasCarrier;
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.TypeParameterCarrier;
import org.jetbrains.kotlin.ir.declarations.persistent.carriers.ValueParameterCarrier;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBodyKind;
import org.jetbrains.kotlin.ir.serialization.CarrierSerializer;
import org.jetbrains.kotlin.ir.serialization.IrCarrierSerializerImpl;
import org.jetbrains.kotlin.ir.serialization.SerializedCarriers;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.library.impl.IrMemoryArrayWriter;
import org.jetbrains.kotlin.library.impl.IrMemoryIntArrayWriter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0002J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0006J\u0014\u0010(\u001a\u00020\u000e2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0002J\u000e\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020\tR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0010\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/ir/serialization/CarrierSerializer;", "", "fileSerializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileSerializer;", "bodies", "", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "signaturer", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "(Lorg/jetbrains/kotlin/backend/common/serialization/IrFileSerializer;Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "bodyCarriers", "", "", "getBodyCarriers", "()Ljava/util/List;", "bodyToIndex", "", "", "declarationCarriers", "getDeclarationCarriers", "getFileSerializer", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrFileSerializer;", "removedOn", "getRemovedOn", "serializerImpl", "Lorg/jetbrains/kotlin/ir/serialization/IrCarrierSerializerImpl;", "getSignaturer", "()Lkotlin/jvm/functions/Function1;", "signatures", "getSignatures", "build", "Lorg/jetbrains/kotlin/ir/serialization/SerializedCarriers;", "serializeBodyCarrier", "bodyCarrier", "Lorg/jetbrains/kotlin/ir/declarations/persistent/carriers/BodyCarrier;", "serializeBodyCarriers", "", "body", "serializeCarriers", "element", "Lorg/jetbrains/kotlin/ir/declarations/persistent/PersistentIrElementBase;", "serializeDeclarationCarrier", "declaration", "ir.tree.persistent"})
final class CarrierSerializer {
    @NotNull
    private final IrFileSerializer fileSerializer;
    @NotNull
    private final Function1<IrDeclaration, IdSignature> signaturer;
    @NotNull
    private final Map<IrBody, Integer> bodyToIndex;
    @NotNull
    private final IrCarrierSerializerImpl serializerImpl;
    @NotNull
    private final List<Integer> signatures;
    @NotNull
    private final List<byte[]> declarationCarriers;
    @NotNull
    private final List<byte[]> bodyCarriers;
    @NotNull
    private final List<Integer> removedOn;

    /*
     * WARNING - void declaration
     */
    public CarrierSerializer(@NotNull IrFileSerializer fileSerializer, @NotNull List<? extends IrBody> bodies2, @NotNull Function1<? super IrDeclaration, ? extends IdSignature> signaturer) {
        Map map2;
        Intrinsics.checkNotNullParameter(fileSerializer, "fileSerializer");
        Intrinsics.checkNotNullParameter(bodies2, "bodies");
        Intrinsics.checkNotNullParameter(signaturer, "signaturer");
        this.fileSerializer = fileSerializer;
        this.signaturer = signaturer;
        Map map3 = map2 = (Map)new LinkedHashMap();
        CarrierSerializer carrierSerializer = this;
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = bodies2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void irBody;
            void map4;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrBody irBody2 = (IrBody)item$iv;
            int index2 = n;
            boolean bl2 = false;
            void var16_17 = map4;
            Integer n2 = index2;
            var16_17.put(irBody, n2);
        }
        Unit unit2 = Unit.INSTANCE;
        carrierSerializer.bodyToIndex = map2;
        this.serializerImpl = new IrCarrierSerializerImpl(this.fileSerializer, (Function1<? super IrBody, Integer>)new Function1<IrBody, Integer>(this){
            final /* synthetic */ CarrierSerializer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull IrBody it) {
                int n;
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter(it, "it");
                        if (!(it instanceof IrSyntheticBody)) break block5;
                        IrSyntheticBodyKind irSyntheticBodyKind = ((IrSyntheticBody)it).getKind();
                        int n2 = serializerImpl.WhenMappings.$EnumSwitchMapping$0[irSyntheticBodyKind.ordinal()];
                        switch (n2) {
                            case 1: {
                                n = -1;
                                break block6;
                            }
                            case 2: {
                                n = -2;
                                break block6;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    Integer n3 = (Integer)CarrierSerializer.access$getBodyToIndex$p(this.this$0).get(it);
                    if (n3 == null) {
                        throw new IllegalStateException("".toString());
                    }
                    n = n3;
                }
                return n;
            }
        });
        this.signatures = new ArrayList();
        this.declarationCarriers = new ArrayList();
        this.bodyCarriers = new ArrayList();
        this.removedOn = new ArrayList();
    }

    @NotNull
    public final IrFileSerializer getFileSerializer() {
        return this.fileSerializer;
    }

    @NotNull
    public final Function1<IrDeclaration, IdSignature> getSignaturer() {
        return this.signaturer;
    }

    @NotNull
    public final List<Integer> getSignatures() {
        return this.signatures;
    }

    @NotNull
    public final List<byte[]> getDeclarationCarriers() {
        return this.declarationCarriers;
    }

    @NotNull
    public final List<byte[]> getBodyCarriers() {
        return this.bodyCarriers;
    }

    @NotNull
    public final List<Integer> getRemovedOn() {
        return this.removedOn;
    }

    @NotNull
    public final SerializedCarriers build() {
        return new SerializedCarriers(new IrMemoryIntArrayWriter(this.signatures).writeIntoMemory(), new IrMemoryArrayWriter(this.declarationCarriers).writeIntoMemory(), new IrMemoryArrayWriter(this.bodyCarriers).writeIntoMemory(), new IrMemoryIntArrayWriter(this.removedOn).writeIntoMemory());
    }

    public final void serializeDeclarationCarrier(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        if (declaration2 instanceof PersistentIrDeclarationBase) {
            IdSignature signature2 = this.signaturer.invoke(declaration2);
            CarrierSerializer carrierSerializer = this;
            ((Collection)carrierSerializer.signatures).add(this.fileSerializer.protoIdSignature(signature2));
            carrierSerializer = this;
            ((Collection)carrierSerializer.declarationCarriers).add(this.serializeCarriers((PersistentIrElementBase)((Object)declaration2)));
            carrierSerializer = this;
            ((Collection)carrierSerializer.removedOn).add(((PersistentIrDeclarationBase)declaration2).getRemovedOn());
        }
    }

    public final void serializeBodyCarriers(@NotNull IrBody body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        if (body2 instanceof PersistentIrBodyBase) {
            CarrierSerializer carrierSerializer = this;
            ((Collection)carrierSerializer.bodyCarriers).add(this.serializeCarriers((PersistentIrElementBase)((Object)body2)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] serializeCarriers(PersistentIrElementBase<?> element) {
        void $this$mapTo$iv$iv;
        Carrier[] values2;
        IrCarrierSerializerImpl irCarrierSerializerImpl;
        IrCarrierSerializerImpl $this$serializeCarriers_u24lambda_u2d3 = irCarrierSerializerImpl = this.serializerImpl;
        boolean bl = false;
        Carrier[] carrierArray = element.getValues();
        Carrier[] $this$map$iv = values2 = (Carrier[])ArraysKt.plus(carrierArray == null ? new Carrier[]{} : carrierArray, element);
        boolean $i$f$map = false;
        Carrier[] carrierArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var12_11 = $this$mapTo$iv$iv;
        int n = 0;
        int n2 = ((void)var12_11).length;
        while (n < n2) {
            byte[] byArray;
            void it;
            void item$iv$iv = var12_11[n];
            ++n;
            void var16_15 = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void var19_18 = it;
            if (var19_18 instanceof AnonymousInitializerCarrier) {
                byArray = $this$serializeCarriers_u24lambda_u2d3.serializeAnonymousInitializerCarrier((AnonymousInitializerCarrier)it);
            } else if (var19_18 instanceof ClassCarrier) {
                byArray = $this$serializeCarriers_u24lambda_u2d3.serializeClassCarrier((ClassCarrier)it);
            } else if (var19_18 instanceof ConstructorCarrier) {
                byArray = $this$serializeCarriers_u24lambda_u2d3.serializeConstructorCarrier((ConstructorCarrier)it);
            } else if (var19_18 instanceof EnumEntryCarrier) {
                byArray = $this$serializeCarriers_u24lambda_u2d3.serializeEnumEntryCarrier((EnumEntryCarrier)it);
            } else if (var19_18 instanceof ErrorDeclarationCarrier) {
                byArray = $this$serializeCarriers_u24lambda_u2d3.serializeErrorDeclarationCarrier((ErrorDeclarationCarrier)it);
            } else if (var19_18 instanceof FieldCarrier) {
                byArray = $this$serializeCarriers_u24lambda_u2d3.serializeFieldCarrier((FieldCarrier)it);
            } else if (var19_18 instanceof FunctionCarrier) {
                byArray = $this$serializeCarriers_u24lambda_u2d3.serializeFunctionCarrier((FunctionCarrier)it);
            } else if (var19_18 instanceof LocalDelegatedPropertyCarrier) {
                byArray = $this$serializeCarriers_u24lambda_u2d3.serializeLocalDelegatedPropertyCarrier((LocalDelegatedPropertyCarrier)it);
            } else if (var19_18 instanceof PropertyCarrier) {
                byArray = $this$serializeCarriers_u24lambda_u2d3.serializePropertyCarrier((PropertyCarrier)it);
            } else if (var19_18 instanceof TypeAliasCarrier) {
                byArray = $this$serializeCarriers_u24lambda_u2d3.serializeTypeAliasCarrier((TypeAliasCarrier)it);
            } else if (var19_18 instanceof TypeParameterCarrier) {
                byArray = $this$serializeCarriers_u24lambda_u2d3.serializeTypeParameterCarrier((TypeParameterCarrier)it);
            } else if (var19_18 instanceof ValueParameterCarrier) {
                byArray = $this$serializeCarriers_u24lambda_u2d3.serializeValueParameterCarrier((ValueParameterCarrier)it);
            } else if (var19_18 instanceof BodyCarrier) {
                byArray = this.serializeBodyCarrier((BodyCarrier)it);
            } else {
                throw new IllegalStateException("unknown Carrier".toString());
            }
            byte[] byArray2 = byArray;
            collection.add(byArray2);
        }
        List carriers = (List)destination$iv$iv;
        return new IrMemoryArrayWriter(carriers).writeIntoMemory();
    }

    private final byte[] serializeBodyCarrier(BodyCarrier bodyCarrier) {
        PirBodyCarrier.Builder proto = PirBodyCarrier.newBuilder();
        proto.setLastModified(bodyCarrier.getLastModified());
        Object object = bodyCarrier.getContainerFieldSymbol();
        if (object != null) {
            IrSymbol irSymbol2;
            IrSymbol it = irSymbol2 = object;
            boolean bl = false;
            proto.setContainerFieldSymbol(this.serializerImpl.getFileSerializer().serializeIrSymbol(it));
        }
        object = proto.build().toByteArray();
        Intrinsics.checkNotNullExpressionValue(object, "proto.build().toByteArray()");
        return object;
    }

    public static final /* synthetic */ Map access$getBodyToIndex$p(CarrierSerializer $this) {
        return $this.bodyToIndex;
    }
}

