/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.codec.binary;

import org.jetbrains.kotlin.org.apache.commons.codec.binary.BaseNCodec;
import org.jetbrains.kotlin.org.apache.commons.codec.binary.StringUtils;

public class Base64
extends BaseNCodec {
    static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    private static final byte[] STANDARD_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] URL_SAFE_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private final byte[] encodeTable;
    private final byte[] decodeTable = DECODE_TABLE;
    private final byte[] lineSeparator;
    private final int decodeSize;
    private final int encodeSize;

    public Base64() {
        this(0);
    }

    public Base64(boolean urlSafe) {
        this(76, CHUNK_SEPARATOR, urlSafe);
    }

    public Base64(int lineLength) {
        this(lineLength, CHUNK_SEPARATOR);
    }

    public Base64(int lineLength, byte[] lineSeparator) {
        this(lineLength, lineSeparator, false);
    }

    public Base64(int lineLength, byte[] lineSeparator, boolean urlSafe) {
        super(3, 4, lineLength, lineSeparator == null ? 0 : lineSeparator.length);
        if (lineSeparator != null) {
            if (this.containsAlphabetOrPad(lineSeparator)) {
                String sep = StringUtils.newStringUtf8(lineSeparator);
                throw new IllegalArgumentException("lineSeparator must not contain base64 characters: [" + sep + "]");
            }
            if (lineLength > 0) {
                this.encodeSize = 4 + lineSeparator.length;
                this.lineSeparator = new byte[lineSeparator.length];
                System.arraycopy(lineSeparator, 0, this.lineSeparator, 0, lineSeparator.length);
            } else {
                this.encodeSize = 4;
                this.lineSeparator = null;
            }
        } else {
            this.encodeSize = 4;
            this.lineSeparator = null;
        }
        this.decodeSize = this.encodeSize - 1;
        this.encodeTable = urlSafe ? URL_SAFE_ENCODE_TABLE : STANDARD_ENCODE_TABLE;
    }

    @Override
    void encode(byte[] in, int inPos, int inAvail, BaseNCodec.Context context2) {
        if (context2.eof) {
            return;
        }
        if (inAvail < 0) {
            context2.eof = true;
            if (0 == context2.modulus && this.lineLength == 0) {
                return;
            }
            byte[] buffer = this.ensureBufferSize(this.encodeSize, context2);
            int savedPos = context2.pos;
            switch (context2.modulus) {
                case 0: {
                    break;
                }
                case 1: {
                    buffer[context2.pos++] = this.encodeTable[context2.ibitWorkArea >> 2 & 0x3F];
                    buffer[context2.pos++] = this.encodeTable[context2.ibitWorkArea << 4 & 0x3F];
                    if (this.encodeTable != STANDARD_ENCODE_TABLE) break;
                    buffer[context2.pos++] = this.pad;
                    buffer[context2.pos++] = this.pad;
                    break;
                }
                case 2: {
                    buffer[context2.pos++] = this.encodeTable[context2.ibitWorkArea >> 10 & 0x3F];
                    buffer[context2.pos++] = this.encodeTable[context2.ibitWorkArea >> 4 & 0x3F];
                    buffer[context2.pos++] = this.encodeTable[context2.ibitWorkArea << 2 & 0x3F];
                    if (this.encodeTable != STANDARD_ENCODE_TABLE) break;
                    buffer[context2.pos++] = this.pad;
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible modulus " + context2.modulus);
                }
            }
            context2.currentLinePos += context2.pos - savedPos;
            if (this.lineLength > 0 && context2.currentLinePos > 0) {
                System.arraycopy(this.lineSeparator, 0, buffer, context2.pos, this.lineSeparator.length);
                context2.pos += this.lineSeparator.length;
            }
        } else {
            for (int i = 0; i < inAvail; ++i) {
                int b;
                byte[] buffer = this.ensureBufferSize(this.encodeSize, context2);
                context2.modulus = (context2.modulus + 1) % 3;
                if ((b = in[inPos++]) < 0) {
                    b += 256;
                }
                context2.ibitWorkArea = (context2.ibitWorkArea << 8) + b;
                if (0 != context2.modulus) continue;
                buffer[context2.pos++] = this.encodeTable[context2.ibitWorkArea >> 18 & 0x3F];
                buffer[context2.pos++] = this.encodeTable[context2.ibitWorkArea >> 12 & 0x3F];
                buffer[context2.pos++] = this.encodeTable[context2.ibitWorkArea >> 6 & 0x3F];
                buffer[context2.pos++] = this.encodeTable[context2.ibitWorkArea & 0x3F];
                context2.currentLinePos += 4;
                if (this.lineLength <= 0 || this.lineLength > context2.currentLinePos) continue;
                System.arraycopy(this.lineSeparator, 0, buffer, context2.pos, this.lineSeparator.length);
                context2.pos += this.lineSeparator.length;
                context2.currentLinePos = 0;
            }
        }
    }

    @Override
    void decode(byte[] in, int inPos, int inAvail, BaseNCodec.Context context2) {
        if (context2.eof) {
            return;
        }
        if (inAvail < 0) {
            context2.eof = true;
        }
        for (int i = 0; i < inAvail; ++i) {
            byte result2;
            byte b;
            byte[] buffer = this.ensureBufferSize(this.decodeSize, context2);
            if ((b = in[inPos++]) == this.pad) {
                context2.eof = true;
                break;
            }
            if (b < 0 || b >= DECODE_TABLE.length || (result2 = DECODE_TABLE[b]) < 0) continue;
            context2.modulus = (context2.modulus + 1) % 4;
            context2.ibitWorkArea = (context2.ibitWorkArea << 6) + result2;
            if (context2.modulus != 0) continue;
            buffer[context2.pos++] = (byte)(context2.ibitWorkArea >> 16 & 0xFF);
            buffer[context2.pos++] = (byte)(context2.ibitWorkArea >> 8 & 0xFF);
            buffer[context2.pos++] = (byte)(context2.ibitWorkArea & 0xFF);
        }
        if (context2.eof && context2.modulus != 0) {
            byte[] buffer = this.ensureBufferSize(this.decodeSize, context2);
            switch (context2.modulus) {
                case 1: {
                    break;
                }
                case 2: {
                    context2.ibitWorkArea >>= 4;
                    buffer[context2.pos++] = (byte)(context2.ibitWorkArea & 0xFF);
                    break;
                }
                case 3: {
                    context2.ibitWorkArea >>= 2;
                    buffer[context2.pos++] = (byte)(context2.ibitWorkArea >> 8 & 0xFF);
                    buffer[context2.pos++] = (byte)(context2.ibitWorkArea & 0xFF);
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible modulus " + context2.modulus);
                }
            }
        }
    }

    public static byte[] encodeBase64(byte[] binaryData) {
        return Base64.encodeBase64(binaryData, false);
    }

    public static byte[] encodeBase64(byte[] binaryData, boolean isChunked) {
        return Base64.encodeBase64(binaryData, isChunked, false);
    }

    public static byte[] encodeBase64(byte[] binaryData, boolean isChunked, boolean urlSafe) {
        return Base64.encodeBase64(binaryData, isChunked, urlSafe, Integer.MAX_VALUE);
    }

    public static byte[] encodeBase64(byte[] binaryData, boolean isChunked, boolean urlSafe, int maxResultSize) {
        if (binaryData == null || binaryData.length == 0) {
            return binaryData;
        }
        Base64 b64 = isChunked ? new Base64(urlSafe) : new Base64(0, CHUNK_SEPARATOR, urlSafe);
        long len = b64.getEncodedLength(binaryData);
        if (len > (long)maxResultSize) {
            throw new IllegalArgumentException("Input array too big, the output array would be bigger (" + len + ") than the specified maximum size of " + maxResultSize);
        }
        return b64.encode(binaryData);
    }

    public static byte[] decodeBase64(byte[] base64Data) {
        return new Base64().decode(base64Data);
    }

    @Override
    protected boolean isInAlphabet(byte octet) {
        return octet >= 0 && octet < this.decodeTable.length && this.decodeTable[octet] != -1;
    }
}

