/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.protocol;

import org.jetbrains.kotlin.org.apache.http.HttpConnection;
import org.jetbrains.kotlin.org.apache.http.HttpHost;
import org.jetbrains.kotlin.org.apache.http.HttpRequest;
import org.jetbrains.kotlin.org.apache.http.protocol.BasicHttpContext;
import org.jetbrains.kotlin.org.apache.http.protocol.HttpContext;
import org.jetbrains.kotlin.org.apache.http.util.Args;

public class HttpCoreContext
implements HttpContext {
    private final HttpContext context;

    public static HttpCoreContext adapt(HttpContext context2) {
        Args.notNull(context2, "HTTP context");
        return context2 instanceof HttpCoreContext ? (HttpCoreContext)context2 : new HttpCoreContext(context2);
    }

    public HttpCoreContext(HttpContext context2) {
        this.context = context2;
    }

    public HttpCoreContext() {
        this.context = new BasicHttpContext();
    }

    @Override
    public Object getAttribute(String id) {
        return this.context.getAttribute(id);
    }

    @Override
    public void setAttribute(String id, Object obj) {
        this.context.setAttribute(id, obj);
    }

    public <T> T getAttribute(String attribname, Class<T> clazz) {
        Args.notNull(clazz, "Attribute class");
        Object obj = this.getAttribute(attribname);
        if (obj == null) {
            return null;
        }
        return clazz.cast(obj);
    }

    public HttpConnection getConnection() {
        return this.getAttribute("http.connection", HttpConnection.class);
    }

    public HttpRequest getRequest() {
        return this.getAttribute("http.request", HttpRequest.class);
    }

    public boolean isRequestSent() {
        Boolean b = this.getAttribute("http.request_sent", Boolean.class);
        return b != null && b != false;
    }

    public HttpHost getTargetHost() {
        return this.getAttribute("http.target_host", HttpHost.class);
    }
}

