/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.org.apache.maven.model.Dependency;
import org.jetbrains.kotlin.org.apache.maven.model.InputLocation;
import org.jetbrains.kotlin.org.apache.maven.model.InputLocationTracker;

public class DependencyManagement
implements Serializable,
Cloneable,
InputLocationTracker {
    private List<Dependency> dependencies;
    private Map<Object, InputLocation> locations;
    private InputLocation location;
    private InputLocation dependenciesLocation;

    public DependencyManagement clone() {
        try {
            DependencyManagement copy2 = (DependencyManagement)super.clone();
            if (this.dependencies != null) {
                copy2.dependencies = new ArrayList<Dependency>();
                for (Dependency item : this.dependencies) {
                    copy2.dependencies.add(item.clone());
                }
            }
            if (copy2.locations != null) {
                copy2.locations = new LinkedHashMap<Object, InputLocation>(copy2.locations);
            }
            return copy2;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public List<Dependency> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<Dependency>();
        }
        return this.dependencies;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            String string2 = (String)key;
            int n = -1;
            switch (string2.hashCode()) {
                case 0: {
                    if (!string2.equals("")) break;
                    n = 0;
                    break;
                }
                case 503774505: {
                    if (!string2.equals("dependencies")) break;
                    n = 1;
                }
            }
            switch (n) {
                case 0: {
                    return this.location;
                }
                case 1: {
                    return this.dependenciesLocation;
                }
            }
            return this.getOtherLocation(key);
        }
        return this.getOtherLocation(key);
    }

    public void setLocation(Object key, InputLocation location2) {
        if (key instanceof String) {
            String string2 = (String)key;
            int n = -1;
            switch (string2.hashCode()) {
                case 0: {
                    if (!string2.equals("")) break;
                    n = 0;
                    break;
                }
                case 503774505: {
                    if (!string2.equals("dependencies")) break;
                    n = 1;
                }
            }
            switch (n) {
                case 0: {
                    this.location = location2;
                    return;
                }
                case 1: {
                    this.dependenciesLocation = location2;
                    return;
                }
            }
            this.setOtherLocation(key, location2);
            return;
        }
        this.setOtherLocation(key, location2);
    }

    public void setOtherLocation(Object key, InputLocation location2) {
        if (location2 != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location2);
        }
    }

    private InputLocation getOtherLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public void setDependencies(List<Dependency> dependencies2) {
        this.dependencies = dependencies2;
    }
}

