/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.model.interpolation;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.apache.maven.model.Activation;
import org.jetbrains.kotlin.org.apache.maven.model.ActivationFile;
import org.jetbrains.kotlin.org.apache.maven.model.ActivationOS;
import org.jetbrains.kotlin.org.apache.maven.model.ActivationProperty;
import org.jetbrains.kotlin.org.apache.maven.model.Build;
import org.jetbrains.kotlin.org.apache.maven.model.BuildBase;
import org.jetbrains.kotlin.org.apache.maven.model.CiManagement;
import org.jetbrains.kotlin.org.apache.maven.model.Contributor;
import org.jetbrains.kotlin.org.apache.maven.model.Dependency;
import org.jetbrains.kotlin.org.apache.maven.model.DependencyManagement;
import org.jetbrains.kotlin.org.apache.maven.model.Developer;
import org.jetbrains.kotlin.org.apache.maven.model.DistributionManagement;
import org.jetbrains.kotlin.org.apache.maven.model.Exclusion;
import org.jetbrains.kotlin.org.apache.maven.model.Extension;
import org.jetbrains.kotlin.org.apache.maven.model.IssueManagement;
import org.jetbrains.kotlin.org.apache.maven.model.License;
import org.jetbrains.kotlin.org.apache.maven.model.MailingList;
import org.jetbrains.kotlin.org.apache.maven.model.Model;
import org.jetbrains.kotlin.org.apache.maven.model.ModelBase;
import org.jetbrains.kotlin.org.apache.maven.model.Notifier;
import org.jetbrains.kotlin.org.apache.maven.model.Organization;
import org.jetbrains.kotlin.org.apache.maven.model.Parent;
import org.jetbrains.kotlin.org.apache.maven.model.Plugin;
import org.jetbrains.kotlin.org.apache.maven.model.PluginExecution;
import org.jetbrains.kotlin.org.apache.maven.model.PluginManagement;
import org.jetbrains.kotlin.org.apache.maven.model.Prerequisites;
import org.jetbrains.kotlin.org.apache.maven.model.Profile;
import org.jetbrains.kotlin.org.apache.maven.model.Relocation;
import org.jetbrains.kotlin.org.apache.maven.model.ReportPlugin;
import org.jetbrains.kotlin.org.apache.maven.model.ReportSet;
import org.jetbrains.kotlin.org.apache.maven.model.Reporting;
import org.jetbrains.kotlin.org.apache.maven.model.Repository;
import org.jetbrains.kotlin.org.apache.maven.model.RepositoryBase;
import org.jetbrains.kotlin.org.apache.maven.model.RepositoryPolicy;
import org.jetbrains.kotlin.org.apache.maven.model.Resource;
import org.jetbrains.kotlin.org.apache.maven.model.Scm;
import org.jetbrains.kotlin.org.apache.maven.model.Site;
import org.jetbrains.kotlin.org.apache.maven.model.building.ModelBuildingRequest;
import org.jetbrains.kotlin.org.apache.maven.model.building.ModelProblem;
import org.jetbrains.kotlin.org.apache.maven.model.building.ModelProblemCollector;
import org.jetbrains.kotlin.org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.jetbrains.kotlin.org.apache.maven.model.interpolation.AbstractStringBasedModelInterpolator;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.InterpolationException;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.ValueSource;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.Xpp3Dom;

@Named
@Singleton
public class StringVisitorModelInterpolator
extends AbstractStringBasedModelInterpolator {
    @Override
    public Model interpolateModel(Model model, File projectDir, ModelBuildingRequest config, ModelProblemCollector problems) {
        List<ValueSource> valueSources = this.createValueSources(model, projectDir, config, problems);
        List<? extends InterpolationPostProcessor> postProcessors = this.createPostProcessors(model, projectDir, config);
        InnerInterpolator innerInterpolator = this.createInterpolator(valueSources, postProcessors, problems);
        new ModelVisitor(innerInterpolator).visit(model);
        return model;
    }

    private InnerInterpolator createInterpolator(List<? extends ValueSource> valueSources, List<? extends InterpolationPostProcessor> postProcessors, final ModelProblemCollector problems) {
        final HashMap cache2 = new HashMap();
        final StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.setCacheAnswers(true);
        for (ValueSource valueSource : valueSources) {
            interpolator.addValueSource(valueSource);
        }
        for (InterpolationPostProcessor interpolationPostProcessor : postProcessors) {
            interpolator.addPostProcessor(interpolationPostProcessor);
        }
        final RecursionInterceptor recursionInterceptor = this.createRecursionInterceptor();
        return new InnerInterpolator(){

            @Override
            public String interpolate(String value2) {
                if (value2 != null && value2.contains("${")) {
                    String c = (String)cache2.get(value2);
                    if (c == null) {
                        try {
                            c = interpolator.interpolate(value2, recursionInterceptor);
                        }
                        catch (InterpolationException e) {
                            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage(e.getMessage()).setException(e));
                        }
                        cache2.put(value2, c);
                    }
                    return c;
                }
                return value2;
            }
        };
    }

    private static final class ModelVisitor {
        private final InnerInterpolator interpolator;

        ModelVisitor(InnerInterpolator interpolator) {
            this.interpolator = interpolator;
        }

        void visit(Model model) {
            if (model != null) {
                String intInceptionYear;
                String orgInceptionYear;
                String intChildProjectUrlInheritAppendPath;
                String orgChildProjectUrlInheritAppendPath;
                String intUrl;
                String orgUrl;
                String intDescription;
                String orgDescription;
                String intName;
                String orgName;
                String intPackaging;
                String orgPackaging;
                String intVersion;
                String orgVersion;
                String intArtifactId;
                String orgArtifactId;
                this.visit((ModelBase)model);
                String orgModelVersion = model.getModelVersion();
                String intModelVersion = this.interpolate(orgModelVersion);
                if (orgModelVersion != intModelVersion) {
                    model.setModelVersion(intModelVersion);
                }
                this.visit(model.getParent());
                String orgGroupId = model.getGroupId();
                String intGroupId = this.interpolate(orgGroupId);
                if (orgGroupId != intGroupId) {
                    model.setGroupId(intGroupId);
                }
                if ((orgArtifactId = model.getArtifactId()) != (intArtifactId = this.interpolate(orgArtifactId))) {
                    model.setArtifactId(intArtifactId);
                }
                if ((orgVersion = model.getVersion()) != (intVersion = this.interpolate(orgVersion))) {
                    model.setVersion(intVersion);
                }
                if ((orgPackaging = model.getPackaging()) != (intPackaging = this.interpolate(orgPackaging))) {
                    model.setPackaging(intPackaging);
                }
                if ((orgName = model.getName()) != (intName = this.interpolate(orgName))) {
                    model.setName(intName);
                }
                if ((orgDescription = model.getDescription()) != (intDescription = this.interpolate(orgDescription))) {
                    model.setDescription(intDescription);
                }
                if ((orgUrl = model.getUrl()) != (intUrl = this.interpolate(orgUrl))) {
                    model.setUrl(intUrl);
                }
                if ((orgChildProjectUrlInheritAppendPath = model.getChildProjectUrlInheritAppendPath()) != (intChildProjectUrlInheritAppendPath = this.interpolate(orgChildProjectUrlInheritAppendPath))) {
                    model.setChildProjectUrlInheritAppendPath(intChildProjectUrlInheritAppendPath);
                }
                if ((orgInceptionYear = model.getInceptionYear()) != (intInceptionYear = this.interpolate(orgInceptionYear))) {
                    model.setInceptionYear(intInceptionYear);
                }
                this.visit(model.getOrganization());
                for (License license : model.getLicenses()) {
                    this.visit(license);
                }
                for (Developer developer : model.getDevelopers()) {
                    this.visit(developer);
                }
                for (Contributor contributor : model.getContributors()) {
                    this.visit(contributor);
                }
                for (MailingList mailingList : model.getMailingLists()) {
                    this.visit(mailingList);
                }
                this.visit(model.getPrerequisites());
                this.visit(model.getScm());
                this.visit(model.getIssueManagement());
                this.visit(model.getCiManagement());
                this.visit(model.getBuild());
                for (Profile profile : model.getProfiles()) {
                    this.visit(profile);
                }
            }
        }

        private void visit(Parent parent2) {
            if (parent2 != null) {
                String val;
                String org = parent2.getGroupId();
                if (org != (val = this.interpolate(org))) {
                    parent2.setGroupId(val);
                }
                if ((org = parent2.getArtifactId()) != (val = this.interpolate(org))) {
                    parent2.setArtifactId(val);
                }
                if ((org = parent2.getVersion()) != (val = this.interpolate(org))) {
                    parent2.setVersion(val);
                }
                if ((org = parent2.getRelativePath()) != (val = this.interpolate(org))) {
                    parent2.setRelativePath(val);
                }
            }
        }

        private void visit(Organization organization) {
            if (organization != null) {
                String val;
                String org = organization.getName();
                if (org != (val = this.interpolate(org))) {
                    organization.setName(val);
                }
                if ((org = organization.getUrl()) != (val = this.interpolate(org))) {
                    organization.setUrl(val);
                }
            }
        }

        private void visit(License license) {
            if (license != null) {
                String val;
                String org = license.getName();
                if (org != (val = this.interpolate(org))) {
                    license.setName(val);
                }
                if ((org = license.getUrl()) != (val = this.interpolate(org))) {
                    license.setUrl(val);
                }
                if ((org = license.getDistribution()) != (val = this.interpolate(org))) {
                    license.setDistribution(val);
                }
                if ((org = license.getComments()) != (val = this.interpolate(org))) {
                    license.setComments(val);
                }
            }
        }

        private void visit(Developer developer) {
            if (developer != null) {
                this.visit((Contributor)developer);
                String org = developer.getId();
                String val = this.interpolate(org);
                if (org != val) {
                    developer.setId(val);
                }
            }
        }

        private void visit(Contributor contributor) {
            if (contributor != null) {
                String val;
                String org = contributor.getName();
                if (org != (val = this.interpolate(org))) {
                    contributor.setName(val);
                }
                if ((org = contributor.getEmail()) != (val = this.interpolate(org))) {
                    contributor.setEmail(val);
                }
                if ((org = contributor.getUrl()) != (val = this.interpolate(org))) {
                    contributor.setUrl(val);
                }
                if ((org = contributor.getOrganization()) != (val = this.interpolate(org))) {
                    contributor.setOrganization(val);
                }
                if ((org = contributor.getOrganizationUrl()) != (val = this.interpolate(org))) {
                    contributor.setOrganizationUrl(val);
                }
                this.visit(contributor.getRoles());
            }
        }

        private void visit(MailingList mailingList) {
            if (mailingList != null) {
                String val;
                String org = mailingList.getName();
                if (org != (val = this.interpolate(org))) {
                    mailingList.setName(val);
                }
                if ((org = mailingList.getSubscribe()) != (val = this.interpolate(org))) {
                    mailingList.setSubscribe(val);
                }
                if ((org = mailingList.getUnsubscribe()) != (val = this.interpolate(org))) {
                    mailingList.setUnsubscribe(val);
                }
                if ((org = mailingList.getPost()) != (val = this.interpolate(org))) {
                    mailingList.setPost(val);
                }
                if ((org = mailingList.getArchive()) != (val = this.interpolate(org))) {
                    mailingList.setArchive(val);
                }
            }
        }

        private void visit(Prerequisites prerequisites) {
            String val;
            String org;
            if (prerequisites != null && (org = prerequisites.getMaven()) != (val = this.interpolate(org))) {
                prerequisites.setMaven(val);
            }
        }

        private void visit(Scm scm) {
            if (scm != null) {
                String val;
                String org = scm.getConnection();
                if (org != (val = this.interpolate(org))) {
                    scm.setConnection(val);
                }
                if ((org = scm.getDeveloperConnection()) != (val = this.interpolate(org))) {
                    scm.setDeveloperConnection(val);
                }
                if ((org = scm.getTag()) != (val = this.interpolate(org))) {
                    scm.setTag(val);
                }
                if ((org = scm.getUrl()) != (val = this.interpolate(org))) {
                    scm.setUrl(val);
                }
                if ((org = scm.getChildScmConnectionInheritAppendPath()) != (val = this.interpolate(org))) {
                    scm.setChildScmConnectionInheritAppendPath(val);
                }
                if ((org = scm.getChildScmDeveloperConnectionInheritAppendPath()) != (val = this.interpolate(org))) {
                    scm.setChildScmDeveloperConnectionInheritAppendPath(val);
                }
                if ((org = scm.getChildScmUrlInheritAppendPath()) != (val = this.interpolate(org))) {
                    scm.setChildScmUrlInheritAppendPath(val);
                }
            }
        }

        private void visit(IssueManagement issueManagement) {
            if (issueManagement != null) {
                String val;
                String org = issueManagement.getSystem();
                if (org != (val = this.interpolate(org))) {
                    issueManagement.setSystem(val);
                }
                if ((org = issueManagement.getUrl()) != (val = this.interpolate(org))) {
                    issueManagement.setUrl(val);
                }
            }
        }

        private void visit(CiManagement ciManagement) {
            if (ciManagement != null) {
                String val;
                String org = ciManagement.getSystem();
                if (org != (val = this.interpolate(org))) {
                    ciManagement.setSystem(val);
                }
                if ((org = ciManagement.getUrl()) != (val = this.interpolate(org))) {
                    ciManagement.setUrl(val);
                }
                for (Notifier notifier : ciManagement.getNotifiers()) {
                    this.visit(notifier);
                }
            }
        }

        private void visit(Notifier notifier) {
            if (notifier != null) {
                String val;
                String org = notifier.getType();
                if (org != (val = this.interpolate(org))) {
                    notifier.setType(val);
                }
                this.visit(notifier.getConfiguration());
            }
        }

        private void visit(BuildBase build2) {
            if (build2 != null) {
                for (Plugin plugin : build2.getPlugins()) {
                    this.visit(plugin);
                }
                this.visit(build2.getPluginManagement());
                String org = build2.getDefaultGoal();
                String val = this.interpolate(org);
                if (org != val) {
                    build2.setDefaultGoal(val);
                }
                for (Resource resource : build2.getResources()) {
                    this.visit(resource);
                }
                for (Resource resource : build2.getTestResources()) {
                    this.visit(resource);
                }
                org = build2.getDirectory();
                if (org != (val = this.interpolate(org))) {
                    build2.setDirectory(val);
                }
                if ((org = build2.getFinalName()) != (val = this.interpolate(org))) {
                    build2.setFinalName(val);
                }
                this.visit(build2.getFilters());
            }
        }

        private void visit(PluginManagement pluginManagement) {
            if (pluginManagement != null) {
                for (Plugin plugin : pluginManagement.getPlugins()) {
                    this.visit(plugin);
                }
            }
        }

        private void visit(Build build2) {
            if (build2 != null) {
                this.visit((BuildBase)build2);
                String org = build2.getSourceDirectory();
                String val = this.interpolate(org);
                if (org != val) {
                    build2.setSourceDirectory(val);
                }
                if ((org = build2.getScriptSourceDirectory()) != (val = this.interpolate(org))) {
                    build2.setScriptSourceDirectory(val);
                }
                if ((org = build2.getTestSourceDirectory()) != (val = this.interpolate(org))) {
                    build2.setTestSourceDirectory(val);
                }
                if ((org = build2.getOutputDirectory()) != (val = this.interpolate(org))) {
                    build2.setOutputDirectory(val);
                }
                if ((org = build2.getTestOutputDirectory()) != (val = this.interpolate(org))) {
                    build2.setTestOutputDirectory(val);
                }
                for (Extension extension : build2.getExtensions()) {
                    this.visit(extension);
                }
            }
        }

        private void visit(Resource resource) {
            if (resource != null) {
                this.visit(resource.getIncludes());
                this.visit(resource.getExcludes());
                String org = resource.getDirectory();
                String val = this.interpolate(org);
                if (org != val) {
                    resource.setDirectory(val);
                }
                if ((org = resource.getTargetPath()) != (val = this.interpolate(org))) {
                    resource.setTargetPath(val);
                }
                if ((org = resource.getFiltering()) != (val = this.interpolate(org))) {
                    resource.setFiltering(val);
                }
            }
        }

        private void visit(Plugin plugin) {
            if (plugin != null) {
                String val;
                String org = plugin.getInherited();
                if (org != (val = this.interpolate(org))) {
                    plugin.setInherited(val);
                }
                this.visit((Xpp3Dom)plugin.getConfiguration());
                org = plugin.getGroupId();
                val = this.interpolate(org);
                if (org != val) {
                    plugin.setGroupId(val);
                }
                if ((org = plugin.getArtifactId()) != (val = this.interpolate(org))) {
                    plugin.setArtifactId(val);
                }
                if ((org = plugin.getVersion()) != (val = this.interpolate(org))) {
                    plugin.setVersion(val);
                }
                if ((org = plugin.getExtensions()) != (val = this.interpolate(org))) {
                    plugin.setExtensions(val);
                }
                for (PluginExecution execution : plugin.getExecutions()) {
                    this.visit(execution);
                }
                for (Dependency dependency : plugin.getDependencies()) {
                    this.visit(dependency);
                }
            }
        }

        private void visit(PluginExecution execution) {
            if (execution != null) {
                String val;
                String org = execution.getInherited();
                if (org != (val = this.interpolate(org))) {
                    execution.setInherited(val);
                }
                this.visit((Xpp3Dom)execution.getConfiguration());
                org = execution.getId();
                val = this.interpolate(org);
                if (org != val) {
                    execution.setId(val);
                }
                if ((org = execution.getPhase()) != (val = this.interpolate(org))) {
                    execution.setPhase(val);
                }
                this.visit(execution.getGoals());
            }
        }

        private void visit(Xpp3Dom dom) {
            if (dom != null) {
                String val;
                String org = dom.getValue();
                if (org != (val = this.interpolate(org))) {
                    dom.setValue(val);
                }
                for (String attr : dom.getAttributeNames()) {
                    org = dom.getAttribute(attr);
                    if (org == (val = this.interpolate(org))) continue;
                    dom.setAttribute(attr, val);
                }
                int l = dom.getChildCount();
                for (int i = 0; i < l; ++i) {
                    this.visit(dom.getChild(i));
                }
            }
        }

        private void visit(Extension extension) {
            if (extension != null) {
                String val;
                String org = extension.getGroupId();
                if (org != (val = this.interpolate(org))) {
                    extension.setGroupId(val);
                }
                if ((org = extension.getArtifactId()) != (val = this.interpolate(org))) {
                    extension.setArtifactId(val);
                }
                if ((org = extension.getVersion()) != (val = this.interpolate(org))) {
                    extension.setVersion(val);
                }
            }
        }

        private void visit(Profile profile) {
            if (profile != null) {
                this.visit((ModelBase)profile);
                String org = profile.getId();
                String val = this.interpolate(org);
                if (org != val) {
                    profile.setId(val);
                }
                this.visit(profile.getActivation());
                this.visit(profile.getBuild());
            }
        }

        private void visit(Activation activation) {
            if (activation != null) {
                String val;
                String org = activation.getJdk();
                if (org != (val = this.interpolate(org))) {
                    activation.setJdk(val);
                }
                this.visit(activation.getOs());
                this.visit(activation.getProperty());
                this.visit(activation.getFile());
            }
        }

        private void visit(ActivationOS activationOS) {
            if (activationOS != null) {
                String val;
                String org = activationOS.getName();
                if (org != (val = this.interpolate(org))) {
                    activationOS.setName(val);
                }
                if ((org = activationOS.getFamily()) != (val = this.interpolate(org))) {
                    activationOS.setFamily(val);
                }
                if ((org = activationOS.getArch()) != (val = this.interpolate(org))) {
                    activationOS.setArch(val);
                }
                if ((org = activationOS.getVersion()) != (val = this.interpolate(org))) {
                    activationOS.setVersion(val);
                }
            }
        }

        private void visit(ActivationProperty activationProperty) {
            if (activationProperty != null) {
                String val;
                String org = activationProperty.getName();
                if (org != (val = this.interpolate(org))) {
                    activationProperty.setName(val);
                }
                if ((org = activationProperty.getValue()) != (val = this.interpolate(org))) {
                    activationProperty.setValue(val);
                }
            }
        }

        private void visit(ActivationFile activationFile) {
            if (activationFile != null) {
                String val;
                String org = activationFile.getMissing();
                if (org != (val = this.interpolate(org))) {
                    activationFile.setMissing(val);
                }
                if ((org = activationFile.getExists()) != (val = this.interpolate(org))) {
                    activationFile.setExists(val);
                }
            }
        }

        private void visit(ModelBase modelBase) {
            if (modelBase != null) {
                this.visit(modelBase.getModules());
                this.visit(modelBase.getDistributionManagement());
                this.visit(modelBase.getProperties());
                this.visit(modelBase.getDependencyManagement());
                for (Dependency dependency : modelBase.getDependencies()) {
                    this.visit(dependency);
                }
                for (Repository repository : modelBase.getRepositories()) {
                    this.visit(repository);
                }
                for (Repository repository : modelBase.getPluginRepositories()) {
                    this.visit(repository);
                }
                this.visit(modelBase.getReporting());
            }
        }

        private void visit(DistributionManagement distributionManagement) {
            if (distributionManagement != null) {
                this.visit(distributionManagement.getRepository());
                this.visit(distributionManagement.getSnapshotRepository());
                this.visit(distributionManagement.getSite());
                String org = distributionManagement.getDownloadUrl();
                String val = this.interpolate(org);
                if (org != val) {
                    distributionManagement.setDownloadUrl(val);
                }
                this.visit(distributionManagement.getRelocation());
            }
        }

        private void visit(Site site) {
            if (site != null) {
                String val;
                String org = site.getId();
                if (org != (val = this.interpolate(org))) {
                    site.setId(val);
                }
                if ((org = site.getName()) != (val = this.interpolate(org))) {
                    site.setName(val);
                }
                if ((org = site.getUrl()) != (val = this.interpolate(org))) {
                    site.setUrl(val);
                }
                if ((org = site.getChildSiteUrlInheritAppendPath()) != (val = this.interpolate(org))) {
                    site.setChildSiteUrlInheritAppendPath(val);
                }
            }
        }

        private void visit(Relocation relocation) {
            if (relocation != null) {
                String val;
                String org = relocation.getGroupId();
                if (org != (val = this.interpolate(org))) {
                    relocation.setGroupId(val);
                }
                if ((org = relocation.getArtifactId()) != (val = this.interpolate(org))) {
                    relocation.setArtifactId(val);
                }
                if ((org = relocation.getVersion()) != (val = this.interpolate(org))) {
                    relocation.setVersion(val);
                }
                if ((org = relocation.getMessage()) != (val = this.interpolate(org))) {
                    relocation.setMessage(val);
                }
            }
        }

        private void visit(DependencyManagement dependencyManagement) {
            if (dependencyManagement != null) {
                for (Dependency dependency : dependencyManagement.getDependencies()) {
                    this.visit(dependency);
                }
            }
        }

        private void visit(Repository repository) {
            if (repository != null) {
                this.visit((RepositoryBase)repository);
                this.visit(repository.getReleases());
                this.visit(repository.getSnapshots());
            }
        }

        private void visit(RepositoryBase repositoryBase) {
            if (repositoryBase != null) {
                String intLayout;
                String orgLayout;
                String intUrl;
                String orgUrl;
                String intName;
                String orgName;
                String intId;
                String orgId = repositoryBase.getId();
                if (orgId != (intId = this.interpolate(orgId))) {
                    repositoryBase.setId(intId);
                }
                if ((orgName = repositoryBase.getName()) != (intName = this.interpolate(orgName))) {
                    repositoryBase.setName(intName);
                }
                if ((orgUrl = repositoryBase.getUrl()) != (intUrl = this.interpolate(orgUrl))) {
                    repositoryBase.setUrl(intUrl);
                }
                if ((orgLayout = repositoryBase.getLayout()) != (intLayout = this.interpolate(orgLayout))) {
                    repositoryBase.setLayout(intLayout);
                }
            }
        }

        private void visit(RepositoryPolicy repositoryPolicy) {
            if (repositoryPolicy != null) {
                String intChecksumPolicy;
                String orgChecksumPolicy;
                String intUpdatePolicy;
                String orgUpdatePolicy;
                String intEnabled;
                String orgEnabled = repositoryPolicy.getEnabled();
                if (orgEnabled != (intEnabled = this.interpolate(orgEnabled))) {
                    repositoryPolicy.setEnabled(intEnabled);
                }
                if ((orgUpdatePolicy = repositoryPolicy.getUpdatePolicy()) != (intUpdatePolicy = this.interpolate(orgUpdatePolicy))) {
                    repositoryPolicy.setUpdatePolicy(intUpdatePolicy);
                }
                if ((orgChecksumPolicy = repositoryPolicy.getChecksumPolicy()) != (intChecksumPolicy = this.interpolate(orgChecksumPolicy))) {
                    repositoryPolicy.setChecksumPolicy(intChecksumPolicy);
                }
            }
        }

        private void visit(Dependency dependency) {
            if (dependency != null) {
                String val;
                String org = dependency.getGroupId();
                if (org != (val = this.interpolate(org))) {
                    dependency.setGroupId(val);
                    dependency.clearManagementKey();
                }
                if ((org = dependency.getArtifactId()) != (val = this.interpolate(org))) {
                    dependency.setArtifactId(val);
                    dependency.clearManagementKey();
                }
                if ((org = dependency.getVersion()) != (val = this.interpolate(org))) {
                    dependency.setVersion(val);
                }
                if ((org = dependency.getType()) != (val = this.interpolate(org))) {
                    dependency.setType(val);
                    dependency.clearManagementKey();
                }
                if ((org = dependency.getClassifier()) != (val = this.interpolate(org))) {
                    dependency.setClassifier(val);
                    dependency.clearManagementKey();
                }
                if ((org = dependency.getScope()) != (val = this.interpolate(org))) {
                    dependency.setScope(val);
                }
                if ((org = dependency.getSystemPath()) != (val = this.interpolate(org))) {
                    dependency.setSystemPath(val);
                }
                for (Exclusion exclusion : dependency.getExclusions()) {
                    this.visit(exclusion);
                }
                org = dependency.getOptional();
                if (org != (val = this.interpolate(org))) {
                    dependency.setOptional(val);
                }
            }
        }

        private void visit(Exclusion exclusion) {
            if (exclusion != null) {
                String val;
                String org = exclusion.getGroupId();
                if (org != (val = this.interpolate(org))) {
                    exclusion.setGroupId(val);
                }
                if ((org = exclusion.getArtifactId()) != (val = this.interpolate(org))) {
                    exclusion.setArtifactId(val);
                }
            }
        }

        private void visit(Reporting reporting) {
            if (reporting != null) {
                String val;
                String org = reporting.getExcludeDefaults();
                if (org != (val = this.interpolate(org))) {
                    reporting.setExcludeDefaults(val);
                }
                if ((org = reporting.getOutputDirectory()) != (val = this.interpolate(org))) {
                    reporting.setOutputDirectory(val);
                }
                for (ReportPlugin plugin : reporting.getPlugins()) {
                    this.visit(plugin);
                }
            }
        }

        private void visit(ReportPlugin plugin) {
            if (plugin != null) {
                String val;
                String org = plugin.getInherited();
                if (org != (val = this.interpolate(org))) {
                    plugin.setInherited(val);
                }
                this.visit((Xpp3Dom)plugin.getConfiguration());
                org = plugin.getGroupId();
                val = this.interpolate(org);
                if (org != val) {
                    plugin.setGroupId(val);
                }
                if ((org = plugin.getArtifactId()) != (val = this.interpolate(org))) {
                    plugin.setArtifactId(val);
                }
                if ((org = plugin.getVersion()) != (val = this.interpolate(org))) {
                    plugin.setVersion(val);
                }
                for (ReportSet reportSet : plugin.getReportSets()) {
                    this.visit(reportSet);
                }
            }
        }

        private void visit(ReportSet reportSet) {
            if (reportSet != null) {
                String val;
                String org = reportSet.getInherited();
                if (org != (val = this.interpolate(org))) {
                    reportSet.setInherited(val);
                }
                this.visit((Xpp3Dom)reportSet.getConfiguration());
                org = reportSet.getId();
                val = this.interpolate(org);
                if (org != val) {
                    reportSet.setId(val);
                }
                this.visit(reportSet.getReports());
            }
        }

        private void visit(Properties properties2) {
            if (properties2 != null) {
                for (Map.Entry<Object, Object> entry : properties2.entrySet()) {
                    String inter;
                    String value2;
                    Object v = entry.getValue();
                    if (!(v instanceof String) || (value2 = (String)v) == (inter = this.interpolate(value2))) continue;
                    entry.setValue(inter);
                }
            }
        }

        private void visit(List<String> list2) {
            if (list2 != null) {
                ListIterator<String> it = list2.listIterator();
                while (it.hasNext()) {
                    String inter;
                    String value2 = it.next();
                    if (value2 == (inter = this.interpolate(value2))) continue;
                    it.set(inter);
                }
            }
        }

        private String interpolate(String value2) {
            return this.interpolator.interpolate(value2);
        }
    }

    static interface InnerInterpolator {
        public String interpolate(String var1);
    }
}

