/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.terminal.impl.jna.win;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.kotlin.org.jline.terminal.impl.jna.win.AnsiOutputStream;
import org.jetbrains.kotlin.org.jline.terminal.impl.jna.win.Kernel32;

public final class WindowsAnsiOutputStream
extends AnsiOutputStream {
    private static final short[] ANSI_FOREGROUND_COLOR_MAP = new short[]{0, 4, 2, 6, 1, 5, 3, 7};
    private static final short[] ANSI_BACKGROUND_COLOR_MAP = new short[]{0, 64, 32, 96, 16, 80, 48, 112};
    private final Pointer console;
    private final Kernel32.CONSOLE_SCREEN_BUFFER_INFO info = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
    private final short originalColors;
    private boolean negative;
    private short savedX = (short)-1;
    private short savedY = (short)-1;

    public WindowsAnsiOutputStream(OutputStream os, Pointer console) throws IOException {
        super(os);
        this.console = console;
        this.getConsoleInfo();
        this.originalColors = this.info.wAttributes;
    }

    private void getConsoleInfo() throws IOException {
        this.out.flush();
        Kernel32.INSTANCE.GetConsoleScreenBufferInfo(this.console, this.info);
        if (this.negative) {
            this.info.wAttributes = this.invertAttributeColors(this.info.wAttributes);
        }
    }

    private void applyAttribute() throws IOException {
        this.out.flush();
        short attributes2 = this.info.wAttributes;
        if (this.negative) {
            attributes2 = this.invertAttributeColors(attributes2);
        }
        Kernel32.INSTANCE.SetConsoleTextAttribute(this.console, attributes2);
    }

    private short invertAttributeColors(short attributes2) {
        int fg = 0xF & attributes2;
        int bg = 0xF0 & attributes2;
        attributes2 = (short)(attributes2 & 0xFF00 | (fg <<= 4) | (bg >>= 4));
        return attributes2;
    }

    private void applyCursorPosition() throws IOException {
        Kernel32.INSTANCE.SetConsoleCursorPosition(this.console, this.info.dwCursorPosition);
    }

    @Override
    protected void processDefaultTextColor() throws IOException {
        this.info.wAttributes = (short)(this.info.wAttributes & 0xFFFFFFF0 | this.originalColors & 0xF);
        this.applyAttribute();
    }

    @Override
    protected void processDefaultBackgroundColor() throws IOException {
        this.info.wAttributes = (short)(this.info.wAttributes & 0xFFFFFF0F | this.originalColors & 0xF0);
        this.applyAttribute();
    }

    @Override
    protected void processEraseScreen(int eraseOption) throws IOException {
        this.getConsoleInfo();
        IntByReference written = new IntByReference();
        switch (eraseOption) {
            case 2: {
                Kernel32.COORD topLeft = new Kernel32.COORD();
                topLeft.X = 0;
                topLeft.Y = this.info.srWindow.Top;
                int screenLength = this.info.srWindow.height() * this.info.dwSize.X;
                Kernel32.INSTANCE.FillConsoleOutputCharacter(this.console, ' ', screenLength, topLeft, written);
                Kernel32.INSTANCE.FillConsoleOutputAttribute(this.console, this.info.wAttributes, screenLength, topLeft, written);
                break;
            }
            case 1: {
                Kernel32.COORD topLeft2 = new Kernel32.COORD();
                topLeft2.X = 0;
                topLeft2.Y = this.info.srWindow.Top;
                int lengthToCursor = (this.info.dwCursorPosition.Y - this.info.srWindow.Top) * this.info.dwSize.X + this.info.dwCursorPosition.X;
                Kernel32.INSTANCE.FillConsoleOutputCharacter(this.console, ' ', lengthToCursor, topLeft2, written);
                Kernel32.INSTANCE.FillConsoleOutputAttribute(this.console, this.info.wAttributes, lengthToCursor, topLeft2, written);
                break;
            }
            case 0: {
                int lengthToEnd = (this.info.srWindow.Bottom - this.info.dwCursorPosition.Y) * this.info.dwSize.X + (this.info.dwSize.X - this.info.dwCursorPosition.X);
                Kernel32.INSTANCE.FillConsoleOutputCharacter(this.console, ' ', lengthToEnd, this.info.dwCursorPosition, written);
                Kernel32.INSTANCE.FillConsoleOutputAttribute(this.console, this.info.wAttributes, lengthToEnd, this.info.dwCursorPosition, written);
            }
        }
    }

    @Override
    protected void processEraseLine(int eraseOption) throws IOException {
        this.getConsoleInfo();
        IntByReference written = new IntByReference();
        switch (eraseOption) {
            case 2: {
                Kernel32.COORD leftColCurrRow = new Kernel32.COORD(0, this.info.dwCursorPosition.Y);
                Kernel32.INSTANCE.FillConsoleOutputCharacter(this.console, ' ', this.info.dwSize.X, leftColCurrRow, written);
                Kernel32.INSTANCE.FillConsoleOutputAttribute(this.console, this.info.wAttributes, this.info.dwSize.X, leftColCurrRow, written);
                break;
            }
            case 1: {
                Kernel32.COORD leftColCurrRow2 = new Kernel32.COORD(0, this.info.dwCursorPosition.Y);
                Kernel32.INSTANCE.FillConsoleOutputCharacter(this.console, ' ', this.info.dwCursorPosition.X, leftColCurrRow2, written);
                Kernel32.INSTANCE.FillConsoleOutputAttribute(this.console, this.info.wAttributes, this.info.dwCursorPosition.X, leftColCurrRow2, written);
                break;
            }
            case 0: {
                int lengthToLastCol = this.info.dwSize.X - this.info.dwCursorPosition.X;
                Kernel32.INSTANCE.FillConsoleOutputCharacter(this.console, ' ', lengthToLastCol, this.info.dwCursorPosition, written);
                Kernel32.INSTANCE.FillConsoleOutputAttribute(this.console, this.info.wAttributes, lengthToLastCol, this.info.dwCursorPosition, written);
            }
        }
    }

    @Override
    protected void processCursorUpLine(int count2) throws IOException {
        this.getConsoleInfo();
        this.info.dwCursorPosition.X = 0;
        this.info.dwCursorPosition.Y = (short)Math.max(this.info.srWindow.Top, this.info.dwCursorPosition.Y - count2);
        this.applyCursorPosition();
    }

    @Override
    protected void processCursorDownLine(int count2) throws IOException {
        this.getConsoleInfo();
        this.info.dwCursorPosition.X = 0;
        this.info.dwCursorPosition.Y = (short)Math.min(this.info.dwSize.Y, this.info.dwCursorPosition.Y + count2);
        this.applyCursorPosition();
    }

    @Override
    protected void processCursorLeft(int count2) throws IOException {
        this.getConsoleInfo();
        this.info.dwCursorPosition.X = (short)Math.max(0, this.info.dwCursorPosition.X - count2);
        this.applyCursorPosition();
    }

    @Override
    protected void processCursorRight(int count2) throws IOException {
        this.getConsoleInfo();
        this.info.dwCursorPosition.X = (short)Math.min(this.info.srWindow.width(), this.info.dwCursorPosition.X + count2);
        this.applyCursorPosition();
    }

    @Override
    protected void processCursorDown(int count2) throws IOException {
        this.getConsoleInfo();
        this.info.dwCursorPosition.Y = (short)Math.min(this.info.dwSize.Y, this.info.dwCursorPosition.Y + count2);
        this.applyCursorPosition();
    }

    @Override
    protected void processCursorUp(int count2) throws IOException {
        this.getConsoleInfo();
        this.info.dwCursorPosition.Y = (short)Math.max(this.info.srWindow.Top, this.info.dwCursorPosition.Y - count2);
        this.applyCursorPosition();
    }

    @Override
    protected void processCursorTo(int row, int col) throws IOException {
        this.getConsoleInfo();
        this.info.dwCursorPosition.Y = (short)Math.max(this.info.srWindow.Top, Math.min(this.info.dwSize.Y, this.info.srWindow.Top + row - 1));
        this.info.dwCursorPosition.X = (short)Math.max(0, Math.min(this.info.srWindow.width(), col - 1));
        this.applyCursorPosition();
    }

    @Override
    protected void processCursorToColumn(int x) throws IOException {
        this.getConsoleInfo();
        this.info.dwCursorPosition.X = (short)Math.max(0, Math.min(this.info.srWindow.width(), x - 1));
        this.applyCursorPosition();
    }

    @Override
    protected void processSetForegroundColor(int color, boolean bright) throws IOException {
        this.info.wAttributes = (short)(this.info.wAttributes & 0xFFFFFFF8 | ANSI_FOREGROUND_COLOR_MAP[color]);
        this.info.wAttributes = (short)(this.info.wAttributes & 0xFFFFFFF7 | (bright ? 8 : 0));
        this.applyAttribute();
    }

    @Override
    protected void processSetBackgroundColor(int color, boolean bright) throws IOException {
        this.info.wAttributes = (short)(this.info.wAttributes & 0xFFFFFF8F | ANSI_BACKGROUND_COLOR_MAP[color]);
        this.info.wAttributes = (short)(this.info.wAttributes & 0xFFFFFF7F | (bright ? 128 : 0));
        this.applyAttribute();
    }

    @Override
    protected void processAttributeRest() throws IOException {
        this.info.wAttributes = (short)(this.info.wAttributes & 0xFFFFFF00 | this.originalColors);
        this.negative = false;
        this.applyAttribute();
    }

    @Override
    protected void processSetAttribute(int attribute) throws IOException {
        switch (attribute) {
            case 1: {
                this.info.wAttributes = (short)(this.info.wAttributes | 8);
                this.applyAttribute();
                break;
            }
            case 22: {
                this.info.wAttributes = (short)(this.info.wAttributes & 0xFFFFFFF7);
                this.applyAttribute();
                break;
            }
            case 4: {
                this.info.wAttributes = (short)(this.info.wAttributes | 0x80);
                this.applyAttribute();
                break;
            }
            case 24: {
                this.info.wAttributes = (short)(this.info.wAttributes & 0xFFFFFF7F);
                this.applyAttribute();
                break;
            }
            case 7: {
                this.negative = true;
                this.applyAttribute();
                break;
            }
            case 27: {
                this.negative = false;
                this.applyAttribute();
            }
        }
    }

    @Override
    protected void processSaveCursorPosition() throws IOException {
        this.getConsoleInfo();
        this.savedX = this.info.dwCursorPosition.X;
        this.savedY = this.info.dwCursorPosition.Y;
    }

    @Override
    protected void processRestoreCursorPosition() throws IOException {
        if (this.savedX != -1 && this.savedY != -1) {
            this.out.flush();
            this.info.dwCursorPosition.X = this.savedX;
            this.info.dwCursorPosition.Y = this.savedY;
            this.applyCursorPosition();
        }
    }

    @Override
    protected void processInsertLine(int optionInt) throws IOException {
        this.getConsoleInfo();
        Kernel32.SMALL_RECT scroll = new Kernel32.SMALL_RECT(this.info.srWindow);
        scroll.Top = this.info.dwCursorPosition.Y;
        Kernel32.COORD org = new Kernel32.COORD();
        org.X = 0;
        org.Y = (short)(this.info.dwCursorPosition.Y + optionInt);
        Kernel32.CHAR_INFO info = new Kernel32.CHAR_INFO(' ', this.originalColors);
        Kernel32.INSTANCE.ScrollConsoleScreenBuffer(this.console, scroll, scroll, org, info);
    }

    @Override
    protected void processDeleteLine(int optionInt) throws IOException {
        this.getConsoleInfo();
        Kernel32.SMALL_RECT scroll = new Kernel32.SMALL_RECT(this.info.srWindow);
        scroll.Top = this.info.dwCursorPosition.Y;
        Kernel32.COORD org = new Kernel32.COORD();
        org.X = 0;
        org.Y = (short)(this.info.dwCursorPosition.Y - optionInt);
        Kernel32.CHAR_INFO info = new Kernel32.CHAR_INFO(' ', this.originalColors);
        Kernel32.INSTANCE.ScrollConsoleScreenBuffer(this.console, scroll, scroll, org, info);
    }

    @Override
    protected void processChangeWindowTitle(String label) {
        Kernel32.INSTANCE.SetConsoleTitle(label);
    }
}

