/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.CallExpressionResolver;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/InstantiationOfAnnotationClassesCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class InstantiationOfAnnotationClassesCallChecker
implements CallChecker {
    @NotNull
    public static final InstantiationOfAnnotationClassesCallChecker INSTANCE = new InstantiationOfAnnotationClassesCallChecker();

    private InstantiationOfAnnotationClassesCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        boolean supported;
        KtCallExpression ktCallExpression;
        ConstructorDescriptor constructorDescriptor;
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.InstantiationOfAnnotationClasses)) {
            return;
        }
        Object object = resolvedCall2.getResultingDescriptor();
        ConstructorDescriptor constructorDescriptor2 = constructorDescriptor = object instanceof ConstructorDescriptor ? (ConstructorDescriptor)object : null;
        if (constructorDescriptor == null) {
            return;
        }
        ConstructorDescriptor calledDescriptor = constructorDescriptor;
        object = calledDescriptor.getConstructedClass();
        Intrinsics.checkNotNullExpressionValue(object, "calledDescriptor.constructedClass");
        Object constructedClass = object;
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        KtCallExpression ktCallExpression2 = ktCallExpression = ktElement instanceof KtCallExpression ? (KtCallExpression)ktElement : null;
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression expression2 = ktCallExpression;
        if (DescriptorUtils.isAnnotationClass((DeclarationDescriptor)constructedClass) && !CallExpressionResolver.Companion.canInstantiateAnnotationClass(expression2, context2.getTrace()) && (supported = constructedClass.getDeclaredTypeParameters().isEmpty())) {
            context2.getTrace().report(Errors.ANNOTATION_CLASS_CONSTRUCTOR_CALL.on((KtCallExpression)((PsiElement)expression2)));
        }
    }
}

