/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J.\u0010\u001b\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001c*\u00020\u001f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u001eH\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "checkFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "checkMemberReceiver", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "memberDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "checkParameterBounds", "checkProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkSupertypes", "checkTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "findVisibilityExposure", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "base", "checkers"})
public final class FirExposedVisibilityDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExposedVisibilityDeclarationChecker INSTANCE = new FirExposedVisibilityDeclarationChecker();

    private FirExposedVisibilityDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter2, "reporter");
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirAnonymousFunction) {
            return;
        }
        if (firDeclaration instanceof FirTypeAlias) {
            this.checkTypeAlias((FirTypeAlias)declaration, reporter2, context);
        } else if (firDeclaration instanceof FirProperty) {
            this.checkProperty((FirProperty)declaration, reporter2, context);
        } else if (firDeclaration instanceof FirFunction) {
            this.checkFunction((FirFunction)declaration, reporter2, context);
        } else if (firDeclaration instanceof FirRegularClass) {
            this.checkClass((FirRegularClass)declaration, reporter2, context);
        }
    }

    private final void checkClass(FirRegularClass declaration, DiagnosticReporter reporter2, CheckerContext context) {
        this.checkSupertypes(declaration, reporter2, context);
        this.checkParameterBounds(declaration, reporter2, context);
    }

    private final void checkSupertypes(FirRegularClass declaration, DiagnosticReporter reporter2, CheckerContext context) {
        Object classVisibility;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        Object object = $this$effectiveVisibility$iv.getStatus();
        Object object2 = object instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)object : null;
        if (object2 == null || (object2 = object2.getEffectiveVisibility()) == null) {
            object2 = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual(classVisibility = object2, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        List<FirTypeRef> supertypes2 = declaration.getSuperTypeRefs();
        boolean isInterface = declaration.getClassKind() == ClassKind.INTERFACE;
        object = supertypes2.iterator();
        while (object.hasNext()) {
            Pair<FirBasedSymbol<?>, EffectiveVisibility> pair;
            FirRegularClassSymbol classSymbol;
            boolean superIsInterface;
            ConeClassLikeType supertype2;
            FirTypeRef supertypeRef;
            FirTypeRef $this$coneTypeSafe$iv = supertypeRef = (FirTypeRef)object.next();
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)) == null || FirHelpersKt.toRegularClassSymbol(supertype2, context.getSession()) == null || (superIsInterface = classSymbol.getClassKind() == ClassKind.INTERFACE) != isInterface || this.findVisibilityExposure(supertype2, context, (EffectiveVisibility)classVisibility) == null) continue;
            FirBasedSymbol<?> restricting = pair.component1();
            EffectiveVisibility restrictingVisibility = pair.component2();
            KtSourceElement ktSourceElement = supertypeRef.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = declaration.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)ktSourceElement, isInterface ? FirErrors.INSTANCE.getEXPOSED_SUPER_INTERFACE() : FirErrors.INSTANCE.getEXPOSED_SUPER_CLASS(), classVisibility, restricting, (Object)restrictingVisibility, (DiagnosticContext)context, null, 64, null);
        }
    }

    private final void checkParameterBounds(FirRegularClass declaration, DiagnosticReporter reporter2, CheckerContext context) {
        Object classVisibility;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual(classVisibility = object, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        for (FirTypeParameterRef parameter : declaration.getTypeParameters()) {
            for (FirResolvedTypeRef bound : parameter.getSymbol().getResolvedBounds()) {
                Pair<FirBasedSymbol<?>, EffectiveVisibility> pair;
                if (this.findVisibilityExposure(FirTypeUtilsKt.getConeType(bound), context, (EffectiveVisibility)classVisibility) == null) continue;
                FirBasedSymbol<?> restricting = pair.component1();
                EffectiveVisibility restrictingVisibility = pair.component2();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)bound.getSource(), FirErrors.INSTANCE.getEXPOSED_TYPE_PARAMETER_BOUND(), classVisibility, restricting, (Object)restrictingVisibility, (DiagnosticContext)context, null, 64, null);
            }
        }
    }

    private final void checkTypeAlias(FirTypeAlias declaration, DiagnosticReporter reporter2, CheckerContext context) {
        Object typeAliasVisibility;
        ConeClassLikeType expandedType2 = FirDeclarationUtilKt.getExpandedConeType(declaration);
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual(typeAliasVisibility = object, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        Object object2 = expandedType2;
        if (object2 == null || (object2 = this.findVisibilityExposure((ConeKotlinType)object2, context, (EffectiveVisibility)typeAliasVisibility)) == null) {
            return;
        }
        Object object3 = object2;
        FirBasedSymbol restricting = (FirBasedSymbol)((Pair)object3).component1();
        EffectiveVisibility restrictingVisibility = (EffectiveVisibility)((Pair)object3).component2();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getEXPOSED_TYPEALIAS_EXPANDED_TYPE(), typeAliasVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context, null, 64, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFunction(FirFunction declaration, DiagnosticReporter reporter2, CheckerContext context) {
        Object restrictingVisibility;
        Object $this$isFromSealedClass$iv;
        KtSourceElement ktSourceElement = declaration.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        Object functionVisibility = null;
        Intrinsics.checkNotNull(declaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration");
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = functionVisibility = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
        }
        if (declaration instanceof FirConstructor) {
            $this$isFromSealedClass$iv = declaration;
            boolean $i$f$isFromSealedClass = false;
            if (((FirMemberDeclaration)$this$isFromSealedClass$iv).getStatus().isFromSealedClass()) {
                functionVisibility = EffectiveVisibility.PrivateInClass.INSTANCE;
            }
        }
        if (Intrinsics.areEqual(functionVisibility, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        if (!(declaration instanceof FirConstructor) && !(declaration instanceof FirPropertyAccessor)) {
            Object $this$coneTypeSafe$iv = declaration.getReturnTypeRef();
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeKotlinType)) {
                coneKotlinType = null;
            }
            if (($this$isFromSealedClass$iv = coneKotlinType) != null && ($this$coneTypeSafe$iv = this.findVisibilityExposure((ConeKotlinType)$this$isFromSealedClass$iv, context, (EffectiveVisibility)functionVisibility)) != null) {
                Object object2 = $this$coneTypeSafe$iv;
                boolean bl = false;
                FirBasedSymbol restricting = (FirBasedSymbol)((Pair)object2).component1();
                restrictingVisibility = (EffectiveVisibility)((Pair)object2).component2();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getEXPOSED_FUNCTION_RETURN_TYPE(), functionVisibility, (Object)restricting, restrictingVisibility, (DiagnosticContext)context, null, 64, null);
            }
        }
        if (!(declaration instanceof FirPropertyAccessor)) {
            Iterable $this$forEachIndexed$iv = declaration.getValueParameters();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                ConeKotlinType coneKotlinType;
                void valueParameter2;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                restrictingVisibility = (FirValueParameter)item$iv;
                int i = n;
                boolean bl = false;
                if (i >= declaration.getValueParameters().size()) continue;
                Object $this$coneTypeSafe$iv = valueParameter2.getReturnTypeRef();
                boolean $i$f$coneTypeSafe = false;
                FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                ConeKotlinType coneKotlinType2 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                if (!(coneKotlinType2 instanceof ConeKotlinType)) {
                    coneKotlinType2 = null;
                }
                if ((coneKotlinType = coneKotlinType2) == null || ($this$coneTypeSafe$iv = INSTANCE.findVisibilityExposure(coneKotlinType, context, (EffectiveVisibility)functionVisibility)) == null) continue;
                Object object3 = $this$coneTypeSafe$iv;
                FirBasedSymbol restricting = (FirBasedSymbol)((Pair)object3).component1();
                EffectiveVisibility restrictingVisibility2 = (EffectiveVisibility)((Pair)object3).component2();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)valueParameter2.getSource(), FirErrors.INSTANCE.getEXPOSED_PARAMETER_TYPE(), functionVisibility, (Object)restricting, (Object)restrictingVisibility2, (DiagnosticContext)context, null, 64, null);
            }
        }
        this.checkMemberReceiver(declaration.getReceiverTypeRef(), declaration instanceof FirCallableDeclaration ? (FirCallableDeclaration)declaration : null, reporter2, context);
    }

    private final void checkProperty(FirProperty declaration, DiagnosticReporter reporter2, CheckerContext context) {
        Pair<FirBasedSymbol<?>, EffectiveVisibility> pair;
        ConeKotlinType coneKotlinType;
        Object propertyVisibility;
        if (declaration.isLocal()) {
            return;
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual(propertyVisibility = object, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        FirTypeRef $this$coneTypeSafe$iv = declaration.getReturnTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType2 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType2 instanceof ConeKotlinType)) {
            coneKotlinType2 = null;
        }
        if ((coneKotlinType = coneKotlinType2) != null && (pair = this.findVisibilityExposure(coneKotlinType, context, (EffectiveVisibility)propertyVisibility)) != null) {
            Pair<FirBasedSymbol<?>, EffectiveVisibility> pair2 = pair;
            boolean bl = false;
            FirBasedSymbol<?> restricting = pair2.component1();
            EffectiveVisibility restrictingVisibility = pair2.component2();
            if (Intrinsics.areEqual(DeclarationAttributesKt.getFromPrimaryConstructor(declaration), true)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR(), propertyVisibility, restricting, (Object)restrictingVisibility, (DiagnosticContext)context, null, 64, null);
            } else {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE(), propertyVisibility, restricting, (Object)restrictingVisibility, (DiagnosticContext)context, null, 64, null);
            }
        }
        this.checkMemberReceiver(declaration.getReceiverTypeRef(), declaration, reporter2, context);
    }

    private final void checkMemberReceiver(FirTypeRef typeRef, FirCallableDeclaration memberDeclaration, DiagnosticReporter reporter2, CheckerContext context) {
        Object memberVisibility;
        if (typeRef == null || memberDeclaration == null) {
            return;
        }
        ConeKotlinType receiverParameterType = FirTypeUtilsKt.getConeType(typeRef);
        FirMemberDeclaration $this$effectiveVisibility$iv = memberDeclaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual(memberVisibility = object, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        Pair<FirBasedSymbol<?>, EffectiveVisibility> pair = this.findVisibilityExposure(receiverParameterType, context, (EffectiveVisibility)memberVisibility);
        if (pair == null) {
            return;
        }
        Pair<FirBasedSymbol<?>, EffectiveVisibility> pair2 = pair;
        FirBasedSymbol<?> restricting = pair2.component1();
        EffectiveVisibility restrictingVisibility = pair2.component2();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getEXPOSED_RECEIVER_TYPE(), memberVisibility, restricting, (Object)restrictingVisibility, (DiagnosticContext)context, null, 64, null);
    }

    private final Pair<FirBasedSymbol<?>, EffectiveVisibility> findVisibilityExposure(ConeKotlinType $this$findVisibilityExposure, CheckerContext context, EffectiveVisibility base2) {
        EffectiveVisibility effectiveVisibility;
        EffectiveVisibility effectiveVisibility2;
        boolean $i$f$getEffectiveVisibility;
        FirClassLikeSymbol $this$effectiveVisibility$iv;
        ConeClassLikeType coneClassLikeType = $this$findVisibilityExposure instanceof ConeClassLikeType ? (ConeClassLikeType)$this$findVisibilityExposure : null;
        if (coneClassLikeType == null) {
            return null;
        }
        ConeClassLikeType type2 = coneClassLikeType;
        ConeTypeProjection[] coneTypeProjectionArray = LookupTagUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType$default(type2, context.getSession(), null, 2, null).getLookupTag(), context.getSession());
        if (coneTypeProjectionArray == null) {
            return null;
        }
        ConeTypeProjection[] classSymbol = coneTypeProjectionArray;
        ConeTypeProjection[] coneTypeProjectionArray2 = classSymbol;
        if (coneTypeProjectionArray2 instanceof FirRegularClassSymbol) {
            $this$effectiveVisibility$iv = (FirClassSymbol)classSymbol;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility2 = ((FirClassSymbol)$this$effectiveVisibility$iv).getResolvedStatus().getEffectiveVisibility();
        } else if (coneTypeProjectionArray2 instanceof FirTypeAliasSymbol) {
            $this$effectiveVisibility$iv = (FirTypeAliasSymbol)classSymbol;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility2 = ((FirTypeAliasSymbol)$this$effectiveVisibility$iv).getResolvedStatus().getEffectiveVisibility();
        } else {
            effectiveVisibility2 = effectiveVisibility = null;
        }
        if (effectiveVisibility != null) {
            switch (WhenMappings.$EnumSwitchMapping$0[effectiveVisibility.relation(base2, TypeComponentsKt.getTypeContext(context.getSession())).ordinal()]) {
                case 1: 
                case 2: {
                    return TuplesKt.to(classSymbol, effectiveVisibility);
                }
            }
        }
        coneTypeProjectionArray2 = type2.getTypeArguments();
        int n = coneTypeProjectionArray2.length;
        for (int i = 0; i < n; ++i) {
            Pair<FirBasedSymbol<?>, EffectiveVisibility> pair;
            ConeClassLikeType coneClassLikeType2;
            ConeTypeProjection it;
            ConeTypeProjection $this$safeAs$iv = it = coneTypeProjectionArray2[i];
            boolean $i$f$safeAs = false;
            ConeTypeProjection coneTypeProjection = $this$safeAs$iv;
            if (!(coneTypeProjection instanceof ConeClassLikeType)) {
                coneTypeProjection = null;
            }
            if ((coneClassLikeType2 = (ConeClassLikeType)coneTypeProjection) == null || (pair = this.findVisibilityExposure(coneClassLikeType2, context, base2)) == null) continue;
            Pair<FirBasedSymbol<?>, EffectiveVisibility> it2 = pair;
            boolean bl = false;
            return it2;
        }
        return null;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EffectiveVisibility.Permissiveness.values().length];
            nArray[EffectiveVisibility.Permissiveness.LESS.ordinal()] = 1;
            nArray[EffectiveVisibility.Permissiveness.UNKNOWN.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

