/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/PrimitiveCompanionLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getActualPrimitiveCompanion", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irClass", "getActualPrimitiveCompanionPropertyAccessor", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "function", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "backend.js"})
public final class PrimitiveCompanionLowering
implements BodyLoweringPass {
    @NotNull
    private final JsIrBackendContext context;

    public PrimitiveCompanionLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    private final IrClass getActualPrimitiveCompanion(IrClass irClass2) {
        if (!irClass2.isCompanion()) {
            return null;
        }
        IrDeclarationParent irDeclarationParent = irClass2.getParent();
        Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        IrClass parent2 = (IrClass)irDeclarationParent;
        if (!IrTypePredicatesKt.isPrimitiveType$default(IrUtilsKt.getDefaultType(parent2), false, 1, null) && !IrTypePredicatesKt.isString(IrUtilsKt.getDefaultType(parent2))) {
            return null;
        }
        IrClassSymbol irClassSymbol = this.context.getPrimitiveCompanionObjects().get(parent2.getName());
        return irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction getActualPrimitiveCompanionPropertyAccessor(IrSimpleFunction function2) {
        void $this$single$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Object object = function2.getCorrespondingPropertySymbol();
        if (object == null || (object = (IrProperty)object.getOwner()) == null) {
            return null;
        }
        Object property2 = object;
        Object object2 = property2.getParent();
        IrClass irClass2 = object2 instanceof IrClass ? (IrClass)object2 : null;
        if (irClass2 == null) {
            return null;
        }
        IrClass companion = irClass2;
        IrClass irClass3 = this.getActualPrimitiveCompanion(companion);
        if (irClass3 == null) {
            return null;
        }
        IrClass actualCompanion = irClass3;
        object2 = IrUtilsKt.getProperties(actualCompanion).iterator();
        while (object2.hasNext()) {
            IrSimpleFunction it;
            IrProperty p = (IrProperty)object2.next();
            if (p.getGetter() != null) {
                boolean bl = false;
                if (Intrinsics.areEqual(it.getName(), function2.getName())) {
                    return it;
                }
            }
            if (p.getSetter() == null) continue;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getName(), function2.getName())) continue;
            return it;
        }
        object2 = actualCompanion.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        void var7_13 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getName(), function2.getName())) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return single$iv;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(this){
            final /* synthetic */ PrimitiveCompanionLowering this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrClass irClass2 = (IrClass)expression2.getSymbol().getOwner();
                IrClass irClass3 = PrimitiveCompanionLowering.access$getActualPrimitiveCompanion(this.this$0, irClass2);
                if (irClass3 == null) {
                    return expression2;
                }
                IrClass actualCompanion = irClass3;
                return new IrGetObjectValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), IrUtilsKt.getDefaultType(actualCompanion), actualCompanion.getSymbol());
            }

            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrExpression irExpression = super.visitCall(expression2);
                Intrinsics.checkNotNull(irExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
                IrCall newCall2 = (IrCall)irExpression;
                IrSimpleFunction irSimpleFunction = PrimitiveCompanionLowering.access$getActualPrimitiveCompanionPropertyAccessor(this.this$0, (IrSimpleFunction)expression2.getSymbol().getOwner());
                if (irSimpleFunction == null) {
                    return newCall2;
                }
                IrSimpleFunction actualFunction = irSimpleFunction;
                return IrUtilsKt.irCall$default((IrFunctionAccessExpression)newCall2, actualFunction, false, false, null, null, 60, null);
            }
        });
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }

    public static final /* synthetic */ IrClass access$getActualPrimitiveCompanion(PrimitiveCompanionLowering $this, IrClass irClass2) {
        return $this.getActualPrimitiveCompanion(irClass2);
    }

    public static final /* synthetic */ IrSimpleFunction access$getActualPrimitiveCompanionPropertyAccessor(PrimitiveCompanionLowering $this, IrSimpleFunction function2) {
        return $this.getActualPrimitiveCompanionPropertyAccessor(function2);
    }
}

