/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.PrioritizedComponent;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;

final class PrioritizedComponents<T> {
    private final Map<?, ?> configProps;
    private final boolean useInsertionOrder;
    private final List<PrioritizedComponent<T>> components;
    private int firstDisabled;

    PrioritizedComponents(RepositorySystemSession session2) {
        this(session2.getConfigProperties());
    }

    PrioritizedComponents(Map<?, ?> configurationProperties) {
        this.configProps = configurationProperties;
        this.useInsertionOrder = ConfigUtils.getBoolean(this.configProps, false, "aether.priority.implicit");
        this.components = new ArrayList<PrioritizedComponent<T>>();
        this.firstDisabled = 0;
    }

    public void add(T component, float priority) {
        Class<?> type2 = PrioritizedComponents.getImplClass(component);
        int index2 = this.components.size();
        priority = this.useInsertionOrder ? (float)(-index2) : ConfigUtils.getFloat(this.configProps, priority, PrioritizedComponents.getConfigKeys(type2));
        PrioritizedComponent<T> pc = new PrioritizedComponent<T>(component, type2, priority, index2);
        if (!this.useInsertionOrder) {
            index2 = Collections.binarySearch(this.components, pc);
            index2 = index2 < 0 ? -index2 - 1 : ++index2;
        }
        this.components.add(index2, pc);
        if (index2 <= this.firstDisabled && !pc.isDisabled()) {
            ++this.firstDisabled;
        }
    }

    private static Class<?> getImplClass(Object component) {
        Class<?> base2;
        Class<?> type2 = component.getClass();
        int idx = type2.getName().indexOf("$$");
        if (idx >= 0 && (base2 = type2.getSuperclass()) != null && idx == base2.getName().length() && type2.getName().startsWith(base2.getName())) {
            type2 = base2;
        }
        return type2;
    }

    static String[] getConfigKeys(Class<?> type2) {
        ArrayList<String> keys2 = new ArrayList<String>();
        keys2.add("aether.priority." + type2.getName());
        String sn = type2.getSimpleName();
        keys2.add("aether.priority." + sn);
        if (sn.endsWith("Factory")) {
            keys2.add("aether.priority." + sn.substring(0, sn.length() - "Factory".length()));
        }
        return keys2.toArray(new String[0]);
    }

    public boolean isEmpty() {
        return this.components.isEmpty();
    }

    public List<PrioritizedComponent<T>> getEnabled() {
        return this.components.subList(0, this.firstDisabled);
    }

    public void list(StringBuilder buffer) {
        int i = 0;
        for (PrioritizedComponent<T> component : this.components) {
            if (i++ > 0) {
                buffer.append(", ");
            }
            buffer.append(component.getType().getSimpleName());
            if (!component.isDisabled()) continue;
            buffer.append(" (disabled)");
        }
    }

    public String toString() {
        return this.components.toString();
    }
}

