/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.plexus;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jetbrains.kotlin.com.google.inject.Singleton;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.org.codehaus.plexus.PlexusContainer;
import org.jetbrains.kotlin.org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.jetbrains.kotlin.org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.jetbrains.kotlin.org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.jetbrains.kotlin.org.codehaus.plexus.context.Context;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.BeanManager;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.Hints;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBean;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBeanLocator;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.EntryListAdapter;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.EntryMapAdapter;

@Singleton
final class PseudoPlexusContainer
implements PlexusContainer {
    final PlexusBeanLocator locator;
    final BeanManager manager;
    final Context context;

    @Inject
    PseudoPlexusContainer(PlexusBeanLocator locator, BeanManager manager, Context context) {
        this.locator = locator;
        this.manager = manager;
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public Object lookup(String role) throws ComponentLookupException {
        return this.lookup(role, "");
    }

    public Object lookup(String role, String hint) throws ComponentLookupException {
        return this.lookup(null, role, hint);
    }

    public <T> T lookup(Class<T> role) throws ComponentLookupException {
        return this.lookup(role, "");
    }

    @Override
    public <T> T lookup(Class<T> role, String hint) throws ComponentLookupException {
        return this.lookup(role, null, hint);
    }

    public <T> T lookup(Class<T> type2, String role, String hint) throws ComponentLookupException {
        try {
            return (T)this.locate(role, type2, hint).iterator().next().getValue();
        }
        catch (RuntimeException e) {
            throw new ComponentLookupException(e, role != null ? role : type2.getName(), hint);
        }
    }

    public List<Object> lookupList(String role) throws ComponentLookupException {
        return new EntryListAdapter<Object>(this.locate(role, null, new String[0]));
    }

    public <T> List<T> lookupList(Class<T> role) throws ComponentLookupException {
        return new EntryListAdapter(this.locate(null, role, new String[0]));
    }

    public Map<String, Object> lookupMap(String role) throws ComponentLookupException {
        return new EntryMapAdapter<String, Object>(this.locate(role, null, new String[0]));
    }

    public <T> Map<String, T> lookupMap(Class<T> role) throws ComponentLookupException {
        return new EntryMapAdapter(this.locate(null, role, new String[0]));
    }

    public boolean hasComponent(String role) {
        return this.hasComponent(role, "");
    }

    public boolean hasComponent(String role, String hint) {
        return this.hasComponent(null, role, hint);
    }

    public boolean hasComponent(Class role) {
        return this.hasComponent(role, "");
    }

    public boolean hasComponent(Class role, String hint) {
        return this.hasComponent(role, null, hint);
    }

    public boolean hasComponent(Class type2, String role, String hint) {
        return PseudoPlexusContainer.hasPlexusBeans(this.locate(role, type2, hint));
    }

    public void addComponent(Object component, String role) {
        throw new UnsupportedOperationException();
    }

    public <T> void addComponent(T component, Class<?> role, String hint) {
        throw new UnsupportedOperationException();
    }

    public <T> void addComponentDescriptor(ComponentDescriptor<T> descriptor2) {
        throw new UnsupportedOperationException();
    }

    public ComponentDescriptor<?> getComponentDescriptor(String role, String hint) {
        throw new UnsupportedOperationException();
    }

    public <T> ComponentDescriptor<T> getComponentDescriptor(Class<T> type2, String role, String hint) {
        throw new UnsupportedOperationException();
    }

    public List getComponentDescriptorList(String role) {
        throw new UnsupportedOperationException();
    }

    public <T> List<ComponentDescriptor<T>> getComponentDescriptorList(Class<T> type2, String role) {
        throw new UnsupportedOperationException();
    }

    public Map getComponentDescriptorMap(String role) {
        throw new UnsupportedOperationException();
    }

    public <T> Map<String, ComponentDescriptor<T>> getComponentDescriptorMap(Class<T> type2, String role) {
        throw new UnsupportedOperationException();
    }

    public List<ComponentDescriptor<?>> discoverComponents(ClassRealm realm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassRealm getContainerRealm() {
        throw new UnsupportedOperationException();
    }

    public ClassRealm setLookupRealm(ClassRealm realm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassRealm getLookupRealm() {
        throw new UnsupportedOperationException();
    }

    public ClassRealm createChildRealm(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void release(Object component) {
        this.manager.unmanage(component);
    }

    public void releaseAll(Map<String, ?> components2) {
        for (Object o : components2.values()) {
            this.release(o);
        }
    }

    public void releaseAll(List<?> components2) {
        for (Object o : components2) {
            this.release(o);
        }
    }

    public void dispose() {
        this.manager.unmanage();
    }

    private <T> Iterable<PlexusBean<T>> locate(String role, Class<T> type2, String ... hints) {
        String[] canonicalHints = Hints.canonicalHints(hints);
        if (role == null || type2 != null && type2.getName().equals(role)) {
            return this.locator.locate(TypeLiteral.get(type2), canonicalHints);
        }
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(role);
            Iterable<PlexusBean<T>> beans = this.locator.locate(TypeLiteral.get(clazz), canonicalHints);
            if (PseudoPlexusContainer.hasPlexusBeans(beans)) {
                return beans;
            }
        }
        catch (Exception exception) {
        }
        catch (LinkageError linkageError) {}
        return Collections.EMPTY_SET;
    }

    private static <T> boolean hasPlexusBeans(Iterable<PlexusBean<T>> beans) {
        Iterator<PlexusBean<T>> i = beans.iterator();
        return i.hasNext() && i.next().getImplementationClass() != null;
    }
}

