/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.space;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Set;
import javax.annotation.processing.Completion;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.inject.Qualifier;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.jetbrains.kotlin.org.eclipse.sisu.space.AbstractSisuIndex;

public final class SisuIndexAPT6
extends AbstractSisuIndex
implements Processor {
    private static final String QUALIFIERS = "qualifiers";
    private static final String ALL = "all";
    private static final String NONE = "none";
    private static final boolean HAS_QUALIFIER;
    private ProcessingEnvironment environment;
    private String qualifiers;

    static {
        boolean hasQualifier;
        try {
            hasQualifier = Qualifier.class.isAnnotation();
        }
        catch (LinkageError linkageError) {
            hasQualifier = false;
        }
        HAS_QUALIFIER = hasQualifier;
    }

    @Override
    public void init(ProcessingEnvironment _environment) {
        this.environment = _environment;
        this.qualifiers = _environment.getOptions().get(QUALIFIERS);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations2, RoundEnvironment round) {
        Elements elementUtils = this.environment.getElementUtils();
        for (TypeElement typeElement : annotations2) {
            if (ALL.equals(this.qualifiers) && !SisuIndexAPT6.hasQualifier(typeElement)) continue;
            for (Element element : round.getElementsAnnotatedWith(typeElement)) {
                if (!element.getKind().isClass()) continue;
                this.addClassToIndex("javax.inject.Named", elementUtils.getBinaryName((TypeElement)element));
            }
        }
        if (round.processingOver()) {
            this.flushIndex();
        }
        return false;
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation2, ExecutableElement member2, String userText) {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        if (ALL.equalsIgnoreCase(this.qualifiers)) {
            return Collections.singleton("*");
        }
        if (NONE.equalsIgnoreCase(this.qualifiers)) {
            return Collections.emptySet();
        }
        return Collections.singleton("javax.inject.Named");
    }

    @Override
    public Set<String> getSupportedOptions() {
        return Collections.singleton(QUALIFIERS);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    protected void info(String msg2) {
        this.environment.getMessager().printMessage(Diagnostic.Kind.NOTE, msg2);
    }

    @Override
    protected void warn(String msg2) {
        this.environment.getMessager().printMessage(Diagnostic.Kind.WARNING, msg2);
    }

    @Override
    protected Reader getReader(String path2) throws IOException {
        FileObject file2 = this.environment.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", path2);
        return new InputStreamReader(file2.openInputStream(), "UTF-8");
    }

    @Override
    protected Writer getWriter(String path2) throws IOException {
        return this.environment.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", path2, new Element[0]).openWriter();
    }

    private static boolean hasQualifier(TypeElement anno) {
        if (HAS_QUALIFIER) {
            return anno.getAnnotation(Qualifier.class) != null;
        }
        for (AnnotationMirror annotationMirror : anno.getAnnotationMirrors()) {
            if (!"javax.inject.Qualifier".equals(annotationMirror.getAnnotationType().toString())) continue;
            return true;
        }
        return false;
    }
}

