/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.SealedClassInheritorsProvider;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.ResolutionScope;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nSealedClassInheritorsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SealedClassInheritorsProvider.kt\norg/jetbrains/kotlin/resolve/CliSealedClassInheritorsProvider\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n179#2,2:87\n1045#3:89\n*S KotlinDebug\n*F\n+ 1 SealedClassInheritorsProvider.kt\norg/jetbrains/kotlin/resolve/CliSealedClassInheritorsProvider\n*L\n73#1:87,2\n82#1:89\n*E\n"})
public final class CliSealedClassInheritorsProvider
extends SealedClassInheritorsProvider {
    @NotNull
    public static final CliSealedClassInheritorsProvider INSTANCE = new CliSealedClassInheritorsProvider();

    private CliSealedClassInheritorsProvider() {
    }

    @NotNull
    public Collection<ClassDescriptor> computeSealedSubclasses(@NotNull ClassDescriptor sealedClass, boolean allowSealedInheritorsInDifferentFilesOfSamePackage) {
        DeclarationDescriptor container;
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter((Object)sealedClass, (String)"sealedClass");
        if (sealedClass.getModality() != Modality.SEALED) {
            return CollectionsKt.emptyList();
        }
        LinkedHashSet<ClassDescriptor> result = new LinkedHashSet<ClassDescriptor>();
        if (!allowSealedInheritorsInDifferentFilesOfSamePackage) {
            declarationDescriptor = sealedClass.getContainingDeclaration();
        } else {
            Object v1;
            block5: {
                Sequence<DeclarationDescriptor> $this$firstOrNull$iv = DescriptorUtilsKt.getParents(sealedClass);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                    boolean bl = false;
                    if (!(it instanceof PackageFragmentDescriptor)) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            declarationDescriptor = container = (DeclarationDescriptor)v1;
        }
        if (container instanceof PackageFragmentDescriptor) {
            CliSealedClassInheritorsProvider.computeSealedSubclasses$collectSubclasses(sealedClass, result, ((PackageFragmentDescriptor)container).getMemberScope(), allowSealedInheritorsInDifferentFilesOfSamePackage);
        }
        MemberScope memberScope2 = sealedClass.getUnsubstitutedInnerClassesScope();
        Intrinsics.checkNotNullExpressionValue((Object)memberScope2, (String)"sealedClass.unsubstitutedInnerClassesScope");
        CliSealedClassInheritorsProvider.computeSealedSubclasses$collectSubclasses(sealedClass, result, memberScope2, true);
        Iterable $this$sortedBy$iv = result;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ClassDescriptor it = (ClassDescriptor)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)DescriptorUtilsKt.getFqNameSafe(it).asString());
                it = (ClassDescriptor)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)DescriptorUtilsKt.getFqNameSafe(it).asString())));
            }
        });
    }

    private static final void computeSealedSubclasses$collectSubclasses(ClassDescriptor $sealedClass, LinkedHashSet<ClassDescriptor> result, MemberScope scope2, boolean collectNested) {
        for (DeclarationDescriptor descriptor2 : ResolutionScope.DefaultImpls.getContributedDescriptors$default(scope2, DescriptorKindFilter.CLASSIFIERS, null, 2, null)) {
            ClassDescriptor classDescriptor;
            if (!(descriptor2 instanceof ClassDescriptor)) continue;
            if (((ClassDescriptor)descriptor2).isExpect()) {
                Name name = ((ClassDescriptor)descriptor2).getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"descriptor.name");
                ClassifierDescriptor actualDescriptor = scope2.getContributedClassifier(name, NoLookupLocation.WHEN_GET_ALL_DESCRIPTORS);
                classDescriptor = actualDescriptor instanceof ClassDescriptor ? (ClassDescriptor)actualDescriptor : (actualDescriptor instanceof TypeAliasDescriptor ? ((TypeAliasDescriptor)actualDescriptor).getClassDescriptor() : null);
            } else {
                classDescriptor = (ClassDescriptor)descriptor2;
            }
            if (classDescriptor == null) continue;
            ClassDescriptor refinedDescriptor = classDescriptor;
            if (DescriptorUtils.isDirectSubclass(refinedDescriptor, $sealedClass)) {
                result.add(refinedDescriptor);
            }
            if (!collectNested) continue;
            MemberScope memberScope2 = refinedDescriptor.getUnsubstitutedInnerClassesScope();
            Intrinsics.checkNotNullExpressionValue((Object)memberScope2, (String)"refinedDescriptor.unsubstitutedInnerClassesScope");
            CliSealedClassInheritorsProvider.computeSealedSubclasses$collectSubclasses($sealedClass, result, memberScope2, collectNested);
        }
    }
}

