/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.CompressionUtil;
import com.intellij.util.io.AppendablePersistentMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import com.intellij.util.io.VersionUpdatedException;
import com.intellij.util.io.WalOpCode;
import com.intellij.util.io.WalRecord;
import com.intellij.util.io.WriteAheadLogKt;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003BE\b\u0007\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000fJ\u001b\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u0017H\u0016J\u0006\u0010 \u001a\u00020\u0017J \u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0006\u0010#\u001a\u00020\u0017J\u001b\u0010$\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010%\u001a\u00028\u0001\u00a2\u0006\u0002\u0010&J\u001d\u0010'\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010%\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010(J\u0013\u0010)\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010*J\u0015\u0010+\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010,J\f\u0010-\u001a\u00020\u0017*\u00020\u001dH\u0002J\u0014\u0010.\u001a\u00020\u0017*\u00020/2\u0006\u00100\u001a\u00020\u0011H\u0002J\f\u00101\u001a\u00020/*\u00020\u001aH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/util/io/PersistentMapWal;", "K", "V", "Ljava/io/Closeable;", "keyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "valueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "useCompression", "", "file", "Ljava/nio/file/Path;", "walIoExecutor", "Ljava/util/concurrent/ExecutorService;", "compact", "(Lcom/intellij/util/io/KeyDescriptor;Lcom/intellij/util/io/DataExternalizer;ZLjava/nio/file/Path;Ljava/util/concurrent/ExecutorService;Z)V", "out", "Lcom/intellij/util/io/DataOutputStream;", "version", "", "getVersion", "()I", "appendData", "", "key", "appender", "Lcom/intellij/util/io/AppendablePersistentMap$ValueDataAppender;", "(Ljava/lang/Object;Lcom/intellij/util/io/AppendablePersistentMap$ValueDataAppender;)V", "appendRecord", "Lcom/intellij/util/io/WalRecord;", "(Ljava/lang/Object;Lcom/intellij/util/io/AppendablePersistentMap$ValueDataAppender;)Lcom/intellij/util/io/WalRecord;", "close", "closeAndDelete", "ensureCompatible", "expectedVersion", "flush", "put", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "putRecord", "(Ljava/lang/Object;Ljava/lang/Object;)Lcom/intellij/util/io/WalRecord;", "remove", "(Ljava/lang/Object;)V", "removeRecord", "(Ljava/lang/Object;)Lcom/intellij/util/io/WalRecord;", "submitWrite", "write", "", "outputStream", "writeToByteArray", "intellij.platform.util"})
public final class PersistentMapWal<K, V>
implements Closeable {
    private final DataOutputStream out;
    private final int version;
    private final KeyDescriptor<K> keyDescriptor;
    private final DataExternalizer<V> valueExternalizer;
    private final boolean useCompression;
    private final Path file;
    private final ExecutorService walIoExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void ensureCompatible(int expectedVersion, boolean useCompression, Path file2) throws IOException {
        void actualVersion;
        Pair pair;
        if (!Files.exists(file2, new LinkOption[0])) {
            Files.createDirectories(file2.getParent(), new FileAttribute[0]);
            Closeable closeable = new DataOutputStream(Files.newOutputStream(file2, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                DataOutputStream it = (DataOutputStream)closeable;
                boolean bl3 = false;
                DataInputOutputUtil.writeINT(it, expectedVersion);
                it.writeBoolean(useCompression);
                Unit unit2 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return;
        }
        Closeable closeable = new DataInputStream(Files.newInputStream(file2, StandardOpenOption.READ));
        boolean bl = false;
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            DataInputStream it = (DataInputStream)closeable;
            boolean bl5 = false;
            pair = TuplesKt.to((Object)DataInputOutputUtil.readINT(it), (Object)it.readBoolean());
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Pair pair2 = pair;
        int n = ((Number)pair2.component1()).intValue();
        boolean actualUsesCompression = (Boolean)pair2.component2();
        if (actualVersion != expectedVersion) {
            throw (Throwable)new VersionUpdatedException(file2, expectedVersion, (int)actualVersion);
        }
        if (actualUsesCompression != useCompression) {
            throw (Throwable)new VersionUpdatedException(file2, useCompression, actualUsesCompression);
        }
    }

    private final void write(byte[] $this$write, DataOutputStream outputStream2) {
        if (this.useCompression) {
            CompressionUtil.writeCompressed(outputStream2, $this$write, 0, $this$write.length);
        } else {
            outputStream2.writeInt($this$write.length);
            outputStream2.write($this$write);
        }
    }

    private final byte[] writeToByteArray(AppendablePersistentMap.ValueDataAppender $this$writeToByteArray) {
        UnsyncByteArrayOutputStream baos = new UnsyncByteArrayOutputStream();
        $this$writeToByteArray.append(new DataOutputStream(baos));
        byte[] byArray = baos.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"baos.toByteArray()");
        return byArray;
    }

    private final WalRecord appendRecord(K key, AppendablePersistentMap.ValueDataAppender appender) {
        return WalRecord.Companion.writeRecord(WalOpCode.APPEND, (Function1<? super DataOutputStream, Unit>)((Function1)new Function1<DataOutputStream, Unit>(this, key, appender){
            final /* synthetic */ PersistentMapWal this$0;
            final /* synthetic */ Object $key;
            final /* synthetic */ AppendablePersistentMap.ValueDataAppender $appender;

            public final void invoke(@NotNull DataOutputStream it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PersistentMapWal.access$getKeyDescriptor$p(this.this$0).save(it, this.$key);
                PersistentMapWal.access$write(this.this$0, PersistentMapWal.access$writeToByteArray(this.this$0, this.$appender), it);
            }
            {
                this.this$0 = persistentMapWal;
                this.$key = object;
                this.$appender = valueDataAppender;
                super(1);
            }
        }));
    }

    private final WalRecord putRecord(K key, V value2) {
        return WalRecord.Companion.writeRecord(WalOpCode.PUT, (Function1<? super DataOutputStream, Unit>)((Function1)new Function1<DataOutputStream, Unit>(this, key, value2){
            final /* synthetic */ PersistentMapWal this$0;
            final /* synthetic */ Object $key;
            final /* synthetic */ Object $value;

            public final void invoke(@NotNull DataOutputStream it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PersistentMapWal.access$getKeyDescriptor$p(this.this$0).save(it, this.$key);
                PersistentMapWal.access$write(this.this$0, WriteAheadLogKt.access$writeData(this.$value, PersistentMapWal.access$getValueExternalizer$p(this.this$0)), it);
            }
            {
                this.this$0 = persistentMapWal;
                this.$key = object;
                this.$value = object2;
                super(1);
            }
        }));
    }

    private final WalRecord removeRecord(K key) {
        return WalRecord.Companion.writeRecord(WalOpCode.REMOVE, (Function1<? super DataOutputStream, Unit>)((Function1)new Function1<DataOutputStream, Unit>(this, key){
            final /* synthetic */ PersistentMapWal this$0;
            final /* synthetic */ Object $key;

            public final void invoke(@NotNull DataOutputStream it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PersistentMapWal.access$getKeyDescriptor$p(this.this$0).save(it, this.$key);
            }
            {
                this.this$0 = persistentMapWal;
                this.$key = object;
                super(1);
            }
        }));
    }

    private final void submitWrite(WalRecord $this$submitWrite) {
        this.walIoExecutor.submit(new Runnable(this, $this$submitWrite){
            final /* synthetic */ PersistentMapWal this$0;
            final /* synthetic */ WalRecord $this_submitWrite;

            public final void run() {
                if (WriteAheadLogKt.getDebugWalRecords()) {
                    String string2 = "write: " + this.$this_submitWrite;
                    boolean bl = false;
                    System.out.println((Object)string2);
                }
                this.$this_submitWrite.write(PersistentMapWal.access$getOut$p(this.this$0));
            }
            {
                this.this$0 = persistentMapWal;
                this.$this_submitWrite = walRecord;
            }
        });
    }

    public final void appendData(K key, @NotNull AppendablePersistentMap.ValueDataAppender appender) throws IOException {
        Intrinsics.checkNotNullParameter((Object)appender, (String)"appender");
        this.submitWrite(this.appendRecord(key, appender));
    }

    public final void put(K key, V value2) throws IOException {
        this.submitWrite(this.putRecord(key, value2));
    }

    public final void remove(K key) throws IOException {
        this.submitWrite(this.removeRecord(key));
    }

    public final void flush() throws IOException {
        this.walIoExecutor.submit(new Runnable(this){
            final /* synthetic */ PersistentMapWal this$0;

            public final void run() {
                PersistentMapWal.access$getOut$p(this.this$0).flush();
            }
            {
                this.this$0 = persistentMapWal;
            }
        }).get();
    }

    @Override
    public void close() throws IOException {
        this.walIoExecutor.submit(new Runnable(this){
            final /* synthetic */ PersistentMapWal this$0;

            public final void run() {
                PersistentMapWal.access$getOut$p(this.this$0).close();
            }
            {
                this.this$0 = persistentMapWal;
            }
        }).get();
    }

    public final void closeAndDelete() throws IOException {
        this.close();
        FileUtil.deleteWithRenaming(this.file);
    }

    @JvmOverloads
    public PersistentMapWal(@NotNull KeyDescriptor<K> keyDescriptor, @NotNull DataExternalizer<V> valueExternalizer, boolean useCompression, @NotNull Path file2, @NotNull ExecutorService walIoExecutor, boolean compact) throws IOException {
        boolean bl;
        int n;
        Object object;
        Intrinsics.checkNotNullParameter(keyDescriptor, (String)"keyDescriptor");
        Intrinsics.checkNotNullParameter(valueExternalizer, (String)"valueExternalizer");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)walIoExecutor, (String)"walIoExecutor");
        this.keyDescriptor = keyDescriptor;
        this.valueExternalizer = valueExternalizer;
        this.useCompression = useCompression;
        this.file = file2;
        this.walIoExecutor = walIoExecutor;
        if (compact) {
            Path path = WriteAheadLogKt.access$tryCompact(this.file, this.keyDescriptor, this.valueExternalizer);
            if (path != null) {
                object = path;
                n = 0;
                bl = false;
                Path compactedWal = object;
                boolean bl2 = false;
                FileUtil.deleteWithRenaming(this.file);
                FileUtil.rename(compactedWal.toFile(), this.file.toFile());
            }
        }
        this.ensureCompatible(this.version, this.useCompression, this.file);
        OutputStream outputStream2 = Files.newOutputStream(this.file, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
        Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"Files.newOutputStream(fi\u2026tandardOpenOption.APPEND)");
        object = outputStream2;
        n = 8192;
        bl = false;
        this.out = new DataOutputStream(object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n));
    }

    public /* synthetic */ PersistentMapWal(KeyDescriptor keyDescriptor, DataExternalizer dataExternalizer, boolean bl, Path path, ExecutorService executorService, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) throws IOException {
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        this(keyDescriptor, dataExternalizer, bl, path, executorService, bl2);
    }

    public static final /* synthetic */ KeyDescriptor access$getKeyDescriptor$p(PersistentMapWal $this) {
        return $this.keyDescriptor;
    }

    public static final /* synthetic */ void access$write(PersistentMapWal $this, byte[] $this$access_u24write, DataOutputStream outputStream2) {
        $this.write($this$access_u24write, outputStream2);
    }

    public static final /* synthetic */ byte[] access$writeToByteArray(PersistentMapWal $this, AppendablePersistentMap.ValueDataAppender $this$access_u24writeToByteArray) {
        return $this.writeToByteArray($this$access_u24writeToByteArray);
    }

    public static final /* synthetic */ DataExternalizer access$getValueExternalizer$p(PersistentMapWal $this) {
        return $this.valueExternalizer;
    }

    public static final /* synthetic */ DataOutputStream access$getOut$p(PersistentMapWal $this) {
        return $this.out;
    }
}

