/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.coroutines;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.common.CustomFramesMethodAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.common.OptimizationBasicInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.StackTransformationUtilsKt;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003\u0011\u0012\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\n\u001a\u0004\u0018\u00010\u000b*\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u0010\u001a\u00020\u0005*\u00020\u000fH\u0002R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/codegen/coroutines/UninitializedStoresProcessor;", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "shouldPreserveClassInitialization", "", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;Z)V", "isInSpecialMethod", "run", "", "getUninitializedValueForConstructorCall", "Lorg/jetbrains/kotlin/codegen/coroutines/UninitializedStoresProcessor$UninitializedNewValue;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "isConstructorCall", "UninitializedNewValue", "UninitializedNewValueFrame", "UninitializedNewValueMarkerInterpreter", "backend"})
public final class UninitializedStoresProcessor {
    private final boolean isInSpecialMethod;
    private final MethodNode methodNode;
    private final boolean shouldPreserveClassInitialization;

    /*
     * WARNING - void declaration
     */
    public final void run() {
        InsnList insnList = this.methodNode.instructions;
        Intrinsics.checkExpressionValueIsNotNull(insnList, "methodNode.instructions");
        UninitializedNewValueMarkerInterpreter interpreter = new UninitializedNewValueMarkerInterpreter(insnList);
        Frame<V>[] frames2 = new CustomFramesMethodAnalyzer("fake", this.methodNode, interpreter, (Function2)new Function2<Integer, Integer, UninitializedNewValueFrame>(this){

            @NotNull
            public final UninitializedNewValueFrame invoke(int p1, int p2) {
                return (UninitializedStoresProcessor)this.receiver.new UninitializedNewValueFrame(p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(UninitializedNewValueFrame.class);
            }

            public final String getName() {
                return "<init>";
            }

            public final String getSignature() {
                return "<init>(Lorg/jetbrains/kotlin/codegen/coroutines/UninitializedStoresProcessor;II)V";
            }
        }).analyze();
        interpreter.analyzePopInstructions(frames2);
        AbstractInsnNode[] abstractInsnNodeArray = this.methodNode.instructions.toArray();
        Intrinsics.checkExpressionValueIsNotNull(abstractInsnNodeArray, "methodNode.instructions.toArray()");
        AbstractInsnNode[] abstractInsnNodeArray2 = abstractInsnNodeArray;
        int n = abstractInsnNodeArray2.length;
        int n2 = 0;
        while (n2 < n) {
            void index2;
            AbstractInsnNode insn = abstractInsnNodeArray2[n2];
            if (frames2[index2] == null) {
            } else {
                Frame<BasicValue> frame;
                AbstractInsnNode abstractInsnNode = insn;
                Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "insn");
                if (this.getUninitializedValueForConstructorCall(frame, abstractInsnNode) == null) {
                } else {
                    Set<AbstractInsnNode> removableUsages;
                    Collection collection;
                    boolean bl;
                    UninitializedNewValue uninitializedValue;
                    TypeInsnNode newInsn = uninitializedValue.getNewInsn();
                    if (interpreter.getUninitializedValuesToRemovableUsages().get(newInsn) == null) {
                        Intrinsics.throwNpe();
                    }
                    boolean bl2 = bl = !(collection = (Collection)removableUsages).isEmpty();
                    if (_Assertions.ENABLED && !bl) {
                        String string = "At least DUP copy operation expected";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    if (removableUsages.size() != 1) {
                        InsnList insnList2;
                        InsnList $receiver = insnList2 = this.methodNode.instructions;
                        UtilKt.removeAll($receiver, (Collection<? extends AbstractInsnNode>)removableUsages);
                        if (this.shouldPreserveClassInitialization) {
                            String string = newInsn.desc;
                            Intrinsics.checkExpressionValueIsNotNull(string, "newInsn.desc");
                            String typeNameForClass = StringsKt.replace$default(string, '/', '.', false, 4, null);
                            $receiver.insertBefore((AbstractInsnNode)newInsn, new LdcInsnNode(typeNameForClass));
                            $receiver.insertBefore((AbstractInsnNode)newInsn, new MethodInsnNode(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;", false));
                            $receiver.set(newInsn, new InsnNode(87));
                        } else {
                            $receiver.remove(newInsn);
                        }
                        int indexOfConstructorArgumentFromTopOfStack = Type.getArgumentTypes(((MethodInsnNode)insn).desc).length;
                        ArrayList<Type> storedTypes = new ArrayList<Type>();
                        int nextVarIndex = this.methodNode.maxLocals;
                        int $i$a$2$run = 0;
                        int n3 = indexOfConstructorArgumentFromTopOfStack;
                        while ($i$a$2$run < n3) {
                            void i;
                            BasicValue value;
                            BasicValue basicValue = value = frame.getStack(frame.getStackSize() - 1 - i);
                            Intrinsics.checkExpressionValueIsNotNull(basicValue, "value");
                            Type type2 = basicValue.getType();
                            this.methodNode.instructions.insertBefore(insn, new VarInsnNode(type2.getOpcode(54), nextVarIndex));
                            Type type3 = type2;
                            Intrinsics.checkExpressionValueIsNotNull(type3, "type");
                            nextVarIndex += type3.getSize();
                            storedTypes.add(type2);
                            ++i;
                        }
                        this.methodNode.maxLocals = Math.max(this.methodNode.maxLocals, nextVarIndex);
                        this.methodNode.instructions.insertBefore(insn, UtilKt.insnListOf(new TypeInsnNode(187, newInsn.desc), new InsnNode(89)));
                        for (Type type4 : CollectionsKt.reversed((Iterable)storedTypes)) {
                            this.methodNode.instructions.insertBefore(insn, new VarInsnNode(type4.getOpcode(21), nextVarIndex -= type4.getSize()));
                        }
                    }
                }
            }
            ++index2;
        }
    }

    private final UninitializedNewValue getUninitializedValueForConstructorCall(@NotNull Frame<BasicValue> $receiver, AbstractInsnNode insn) {
        boolean bl;
        if (!this.isConstructorCall(insn)) {
            return null;
        }
        boolean bl2 = bl = insn.getOpcode() == 183;
        if (_Assertions.ENABLED && !bl) {
            String string = "Expected opcode Opcodes.INVOKESPECIAL for <init>, but " + insn.getOpcode() + " found";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        AbstractInsnNode abstractInsnNode = insn;
        if (abstractInsnNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.MethodInsnNode");
        }
        int paramsCountIncludingReceiver = Type.getArgumentTypes(((MethodInsnNode)abstractInsnNode).desc).length + 1;
        BasicValue basicValue = StackTransformationUtilsKt.peek($receiver, paramsCountIncludingReceiver);
        if (!(basicValue instanceof UninitializedNewValue)) {
            basicValue = null;
        }
        UninitializedNewValue uninitializedNewValue = (UninitializedNewValue)basicValue;
        if (uninitializedNewValue == null) {
            if (this.isInSpecialMethod) {
                return null;
            }
            String string = "Expected value generated with NEW";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        UninitializedNewValue newValue = uninitializedNewValue;
        boolean bl3 = StackTransformationUtilsKt.peek($receiver, paramsCountIncludingReceiver - 1) instanceof UninitializedNewValue;
        if (_Assertions.ENABLED && !bl3) {
            String string = "Next value after NEW should be one generated by DUP";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return newValue;
    }

    private final boolean isConstructorCall(@NotNull AbstractInsnNode $receiver) {
        return $receiver instanceof MethodInsnNode && Intrinsics.areEqual(((MethodInsnNode)$receiver).name, "<init>");
    }

    public UninitializedStoresProcessor(@NotNull MethodNode methodNode, boolean shouldPreserveClassInitialization) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        this.methodNode = methodNode;
        this.shouldPreserveClassInitialization = shouldPreserveClassInitialization;
        this.isInSpecialMethod = Intrinsics.areEqual(this.methodNode.name, "<init>") || Intrinsics.areEqual(this.methodNode.name, "<clinit>");
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/codegen/coroutines/UninitializedStoresProcessor$UninitializedNewValueFrame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "nLocals", "", "nStack", "(Lorg/jetbrains/kotlin/codegen/coroutines/UninitializedStoresProcessor;II)V", "execute", "", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "interpreter", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;", "backend"})
    private final class UninitializedNewValueFrame
    extends Frame<BasicValue> {
        @Override
        public void execute(@NotNull AbstractInsnNode insn, @Nullable Interpreter<BasicValue> interpreter) {
            Intrinsics.checkParameterIsNotNull(insn, "insn");
            boolean replaceTopValueWithInitialized = UninitializedStoresProcessor.this.getUninitializedValueForConstructorCall(this, insn) != null;
            super.execute(insn, interpreter);
            if (replaceTopValueWithInitialized) {
                Object v = this.pop();
                if (v == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.codegen.coroutines.UninitializedStoresProcessor.UninitializedNewValue");
                }
                UninitializedNewValue value = (UninitializedNewValue)v;
                this.push((Value)new StrictBasicValue(value.getType()));
            }
        }

        public UninitializedNewValueFrame(int nLocals, int nStack) {
            super(nLocals, nStack);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/codegen/coroutines/UninitializedStoresProcessor$UninitializedNewValue;", "Lorg/jetbrains/kotlin/codegen/optimization/common/StrictBasicValue;", "newInsn", "Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;", "internalName", "", "(Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;Ljava/lang/String;)V", "getInternalName", "()Ljava/lang/String;", "getNewInsn", "()Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;", "toString", "backend"})
    private static final class UninitializedNewValue
    extends StrictBasicValue {
        @NotNull
        private final TypeInsnNode newInsn;
        @NotNull
        private final String internalName;

        @Override
        @NotNull
        public String toString() {
            return "UninitializedNewValue(internalName='" + this.internalName + "')";
        }

        @NotNull
        public final TypeInsnNode getNewInsn() {
            return this.newInsn;
        }

        @NotNull
        public final String getInternalName() {
            return this.internalName;
        }

        public UninitializedNewValue(@NotNull TypeInsnNode newInsn, @NotNull String internalName) {
            Intrinsics.checkParameterIsNotNull(newInsn, "newInsn");
            Intrinsics.checkParameterIsNotNull(internalName, "internalName");
            super(Type.getObjectType(internalName));
            this.newInsn = newInsn;
            this.internalName = internalName;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u001e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J!\u0010\u0017\u001a\u00020\u00112\u0014\u0010\u0018\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00140\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u00072\b\u0010 \u001a\u0004\u0018\u00010\u0015H\u0016J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0015H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R9\u0010\u0005\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006j\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\u00020\r*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/codegen/coroutines/UninitializedStoresProcessor$UninitializedNewValueMarkerInterpreter;", "Lorg/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter;", "instructions", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "(Lorg/jetbrains/org/objectweb/asm/tree/InsnList;)V", "uninitializedValuesToRemovableUsages", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "", "Lkotlin/collections/HashMap;", "getUninitializedValuesToRemovableUsages", "()Ljava/util/HashMap;", "debugText", "", "getDebugText", "(Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;)Ljava/lang/String;", "analyzePop", "", "insn", "frame", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "analyzePop2", "analyzePopInstructions", "frames", "", "([Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)V", "checkUninitializedObjectCopy", "newInsn", "Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;", "usageInsn", "copyOperation", "value", "merge", "v", "w", "newOperation", "backend"})
    private static final class UninitializedNewValueMarkerInterpreter
    extends OptimizationBasicInterpreter {
        @NotNull
        private final HashMap<AbstractInsnNode, Set<AbstractInsnNode>> uninitializedValuesToRemovableUsages;
        private final InsnList instructions;

        @NotNull
        public final HashMap<AbstractInsnNode, Set<AbstractInsnNode>> getUninitializedValuesToRemovableUsages() {
            return this.uninitializedValuesToRemovableUsages;
        }

        @Override
        @Nullable
        public BasicValue newOperation(@NotNull AbstractInsnNode insn) {
            Intrinsics.checkParameterIsNotNull(insn, "insn");
            if (insn.getOpcode() == 187) {
                Map $receiver$iv = this.uninitializedValuesToRemovableUsages;
                Object value$iv = $receiver$iv.get(insn);
                if (value$iv == null) {
                    Set answer$iv = new LinkedHashSet();
                    $receiver$iv.put(insn, answer$iv);
                }
                TypeInsnNode typeInsnNode = (TypeInsnNode)insn;
                String string = ((TypeInsnNode)insn).desc;
                Intrinsics.checkExpressionValueIsNotNull(string, "insn.desc");
                return new UninitializedNewValue(typeInsnNode, string);
            }
            return super.newOperation(insn);
        }

        @Override
        @Nullable
        public BasicValue copyOperation(@NotNull AbstractInsnNode insn, @Nullable BasicValue value) {
            Intrinsics.checkParameterIsNotNull(insn, "insn");
            if (value instanceof UninitializedNewValue) {
                this.checkUninitializedObjectCopy(((UninitializedNewValue)value).getNewInsn(), insn);
                Set<AbstractInsnNode> set = this.uninitializedValuesToRemovableUsages.get(((UninitializedNewValue)value).getNewInsn());
                if (set == null) {
                    Intrinsics.throwNpe();
                }
                set.add(insn);
                return value;
            }
            return super.copyOperation(insn, value);
        }

        @Override
        @NotNull
        public BasicValue merge(@NotNull BasicValue v, @NotNull BasicValue w) {
            Intrinsics.checkParameterIsNotNull(v, "v");
            Intrinsics.checkParameterIsNotNull(w, "w");
            if (v == w) {
                return v;
            }
            if (v == StrictBasicValue.UNINITIALIZED_VALUE || w == StrictBasicValue.UNINITIALIZED_VALUE) {
                return StrictBasicValue.UNINITIALIZED_VALUE;
            }
            if (v instanceof UninitializedNewValue || w instanceof UninitializedNewValue) {
                BasicValue basicValue = v;
                if (!(basicValue instanceof UninitializedNewValue)) {
                    basicValue = null;
                }
                UninitializedNewValue uninitializedNewValue = (UninitializedNewValue)basicValue;
                TypeInsnNode typeInsnNode = uninitializedNewValue != null ? uninitializedNewValue.getNewInsn() : null;
                BasicValue basicValue2 = w;
                if (!(basicValue2 instanceof UninitializedNewValue)) {
                    basicValue2 = null;
                }
                UninitializedNewValue uninitializedNewValue2 = (UninitializedNewValue)basicValue2;
                if (typeInsnNode != (uninitializedNewValue2 != null ? uninitializedNewValue2.getNewInsn() : null)) {
                    return StrictBasicValue.UNINITIALIZED_VALUE;
                }
                return v;
            }
            BasicValue basicValue = super.merge(v, w);
            Intrinsics.checkExpressionValueIsNotNull(basicValue, "super.merge(v, w)");
            return basicValue;
        }

        private final void checkUninitializedObjectCopy(TypeInsnNode newInsn, AbstractInsnNode usageInsn) {
            switch (usageInsn.getOpcode()) {
                case 25: 
                case 58: 
                case 89: {
                    break;
                }
                default: {
                    String string = "Unexpected copy instruction for " + this.getDebugText(newInsn) + ": " + this.getDebugText(usageInsn);
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
        }

        private final String getDebugText(@NotNull AbstractInsnNode $receiver) {
            return this.instructions.indexOf($receiver) + ": " + InlineCodegenUtilsKt.getInsnText($receiver);
        }

        /*
         * WARNING - void declaration
         */
        public final void analyzePopInstructions(@NotNull Frame<BasicValue>[] frames2) {
            Intrinsics.checkParameterIsNotNull(frames2, "frames");
            AbstractInsnNode[] insns2 = this.instructions.toArray();
            int n = 0;
            int n2 = frames2.length;
            while (n < n2) {
                void i;
                if (frames2[i] == null) {
                } else {
                    AbstractInsnNode insn;
                    AbstractInsnNode abstractInsnNode = insn = insns2[i];
                    Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "insn");
                    switch (abstractInsnNode.getOpcode()) {
                        case 87: {
                            Frame<BasicValue> frame;
                            this.analyzePop(insn, frame);
                            break;
                        }
                        case 88: {
                            Frame<BasicValue> frame;
                            this.analyzePop2(insn, frame);
                        }
                    }
                }
                ++i;
            }
        }

        private final void analyzePop(AbstractInsnNode insn, Frame<BasicValue> frame) {
            BasicValue basicValue = StackTransformationUtilsKt.top(frame);
            if (basicValue == null) {
                String string = "Stack underflow on POP: " + this.getDebugText(insn);
                throw (Throwable)new IllegalStateException(string.toString());
            }
            BasicValue top = basicValue;
            if (top instanceof UninitializedNewValue) {
                Set<AbstractInsnNode> set = this.uninitializedValuesToRemovableUsages.get(((UninitializedNewValue)top).getNewInsn());
                if (set == null) {
                    Intrinsics.throwNpe();
                }
                set.add(insn);
            }
        }

        private final void analyzePop2(AbstractInsnNode insn, Frame<BasicValue> frame) {
            List<BasicValue> list2 = StackTransformationUtilsKt.peekWords(frame, 2);
            if (list2 == null) {
                String string = "Stack underflow on POP2: " + this.getDebugText(insn);
                throw (Throwable)new IllegalStateException(string.toString());
            }
            List<BasicValue> top2 = list2;
            for (BasicValue value : top2) {
                if (!(value instanceof UninitializedNewValue)) continue;
                String string = "Unexpected POP2 instruction for " + this.getDebugText(((UninitializedNewValue)value).getNewInsn()) + ": " + this.getDebugText(insn);
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }

        public UninitializedNewValueMarkerInterpreter(@NotNull InsnList instructions) {
            Intrinsics.checkParameterIsNotNull(instructions, "instructions");
            this.instructions = instructions;
            UninitializedNewValueMarkerInterpreter uninitializedNewValueMarkerInterpreter = this;
            HashMap hashMap = new HashMap();
            uninitializedNewValueMarkerInterpreter.uninitializedValuesToRemovableUsages = hashMap;
        }
    }
}

