/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantKt;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructorKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0003J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstructor;", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "value", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "parameters", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "(JLorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;)V", "supertypes", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/types/KotlinType;", "checkBoundsAndAddSuperType", "", "kotlinType", "getBuiltIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getDeclarationDescriptor", "", "getParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "getSupertypes", "", "getValue", "isDenotable", "", "isFinal", "toString", "", "unsignedType", "Lorg/jetbrains/kotlin/types/SimpleType;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "descriptors"})
public final class IntegerValueTypeConstructor
implements TypeConstructor {
    private final ArrayList<KotlinType> supertypes;
    private final long value;
    private final ModuleDescriptor module;

    private final void checkBoundsAndAddSuperType(long value, KotlinType kotlinType) {
        long l = value;
        if (IntegerValueTypeConstructorKt.access$minValue(kotlinType) <= l && IntegerValueTypeConstructorKt.access$maxValue(kotlinType) >= l) {
            this.supertypes.add(kotlinType);
        }
    }

    private final SimpleType unsignedType(ClassId classId) {
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(this.module, classId);
        if (classDescriptor == null) {
            Intrinsics.throwNpe();
        }
        SimpleType simpleType2 = classDescriptor.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "module.findClassAcrossMo\u2026es(classId)!!.defaultType");
        return simpleType2;
    }

    @Override
    @NotNull
    public Collection<KotlinType> getSupertypes() {
        return this.supertypes;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Nullable
    public Void getDeclarationDescriptor() {
        return null;
    }

    public final long getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    @NotNull
    public String toString() {
        return "IntegerValueType(" + this.value + ')';
    }

    public IntegerValueTypeConstructor(long value, @NotNull ModuleDescriptor module2, @NotNull CompileTimeConstant.Parameters parameters2) {
        SimpleType simpleType2;
        SimpleType simpleType3;
        SimpleType simpleType4;
        SimpleType simpleType5;
        Intrinsics.checkParameterIsNotNull(module2, "module");
        Intrinsics.checkParameterIsNotNull(parameters2, "parameters");
        this.value = value;
        this.module = module2;
        this.supertypes = new ArrayList(4);
        boolean isUnsigned = parameters2.isUnsignedNumberLiteral();
        if (isUnsigned) {
            boolean bl = CompileTimeConstantKt.hasUnsignedTypesInModuleDependencies(this.module);
            if (_Assertions.ENABLED && !bl) {
                String string = "Unsigned types should be on classpath to create an unsigned type constructor";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
        if (isUnsigned) {
            ClassId classId = KotlinBuiltIns.FQ_NAMES.uInt;
            Intrinsics.checkExpressionValueIsNotNull(classId, "KotlinBuiltIns.FQ_NAMES.uInt");
            simpleType5 = this.unsignedType(classId);
        } else {
            SimpleType simpleType6 = this.getBuiltIns().getIntType();
            simpleType5 = simpleType6;
            Intrinsics.checkExpressionValueIsNotNull(simpleType6, "builtIns.intType");
        }
        this.checkBoundsAndAddSuperType(this.value, simpleType5);
        if (isUnsigned) {
            ClassId classId = KotlinBuiltIns.FQ_NAMES.uByte;
            Intrinsics.checkExpressionValueIsNotNull(classId, "KotlinBuiltIns.FQ_NAMES.uByte");
            simpleType4 = this.unsignedType(classId);
        } else {
            SimpleType simpleType7 = this.getBuiltIns().getByteType();
            simpleType4 = simpleType7;
            Intrinsics.checkExpressionValueIsNotNull(simpleType7, "builtIns.byteType");
        }
        this.checkBoundsAndAddSuperType(this.value, simpleType4);
        if (isUnsigned) {
            ClassId classId = KotlinBuiltIns.FQ_NAMES.uShort;
            Intrinsics.checkExpressionValueIsNotNull(classId, "KotlinBuiltIns.FQ_NAMES.uShort");
            simpleType3 = this.unsignedType(classId);
        } else {
            SimpleType simpleType8 = this.getBuiltIns().getShortType();
            simpleType3 = simpleType8;
            Intrinsics.checkExpressionValueIsNotNull(simpleType8, "builtIns.shortType");
        }
        this.checkBoundsAndAddSuperType(this.value, simpleType3);
        if (isUnsigned) {
            ClassId classId = KotlinBuiltIns.FQ_NAMES.uLong;
            Intrinsics.checkExpressionValueIsNotNull(classId, "KotlinBuiltIns.FQ_NAMES.uLong");
            simpleType2 = this.unsignedType(classId);
        } else {
            SimpleType simpleType9 = this.getBuiltIns().getLongType();
            simpleType2 = simpleType9;
            Intrinsics.checkExpressionValueIsNotNull(simpleType9, "builtIns.longType");
        }
        this.supertypes.add(simpleType2);
    }
}

