/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.IrGeneratorContext;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrEnumConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrInstanceInitializerCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.util.TypeTranslator;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptorKt;
import org.jetbrains.kotlin.psi2ir.generators.ArgumentsGenerationUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.BodyGenerator$WhenMappings;
import org.jetbrains.kotlin.psi2ir.generators.CallGenerator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorWithScope;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.intermediate.CallBuilder;
import org.jetbrains.kotlin.psi2ir.intermediate.VariableLValue;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0016\u0010*\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010+\u001a\u00020)J\u0018\u0010,\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010+\u001a\u00020)H\u0002J \u0010-\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020.2\u0006\u0010/\u001a\u00020)H\u0002J\u000e\u00100\u001a\u0002012\u0006\u00102\u001a\u000203J\u000e\u00104\u001a\u0002052\u0006\u00106\u001a\u000203J\u000e\u00107\u001a\u0002052\u0006\u00108\u001a\u000209J\u000e\u0010:\u001a\u0002052\u0006\u0010;\u001a\u00020<J \u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020@2\u0006\u0010B\u001a\u00020%H\u0002J\u000e\u0010C\u001a\u0002052\u0006\u0010\"\u001a\u00020#J\u000e\u0010D\u001a\u0002052\u0006\u0010\"\u001a\u00020#J\u0018\u0010E\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010F\u001a\u0004\u0018\u00010\f2\u0006\u0010G\u001a\u000203J\u0016\u0010H\u001a\u00020\u001c2\u0006\u0010G\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020\fJ$\u0010J\u001a\u00020%*\u00020\u001a2\u000e\u0010K\u001a\n\u0012\u0006\b\u0001\u0012\u00020M0L2\u0006\u0010&\u001a\u00020'H\u0002J\u001c\u0010=\u001a\u00020\u001c*\u00020\u001a2\u0006\u00102\u001a\u0002032\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\f\u0010N\u001a\u00020O*\u00020PH\u0002J\f\u0010Q\u001a\u00020%*\u00020%H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/BodyGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorWithScope;", "scopeOwnerSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "context", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "(Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;)V", "getContext", "()Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "loopTable", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "scope", "Lorg/jetbrains/kotlin/ir/builders/Scope;", "getScope", "()Lorg/jetbrains/kotlin/ir/builders/Scope;", "scopeOwner", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getScopeOwner", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getScopeOwnerSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "typeTranslator", "Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "createStatementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "generateAnySuperConstructorCall", "", "irBlockBody", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrBlockBodyImpl;", "ktElement", "Lorg/jetbrains/kotlin/psi/KtPureElement;", "generateDelegatingConstructorCall", "ktConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "generateEnumConstructorCallOrSuperCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ktEnumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "enumClassDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "generateEnumEntryInitializer", "enumEntryDescriptor", "generateEnumEntrySuperConstructorCall", "generateEnumSuperConstructorCall", "Lorg/jetbrains/kotlin/psi/KtElement;", "classDescriptor", "generateExpressionBody", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "ktExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "generateFunctionBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "ktBody", "generateLambdaBody", "ktFun", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "generatePrimaryConstructorBody", "ktClassOrObject", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "generateReturnExpression", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrReturnImpl;", "startOffset", "", "endOffset", "returnValue", "generateSecondaryConstructorBody", "generateSecondaryConstructorBodyWithNestedInitializers", "generateSuperConstructorCall", "getLoop", "expression", "putLoop", "irLoop", "generateEnumConstructorCall", "constructorCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "toIrType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/types/KotlinType;", "wrapWithReturn", "ir.psi2ir"})
public final class BodyGenerator
implements GeneratorWithScope {
    private final TypeTranslator typeTranslator;
    @NotNull
    private final Scope scope;
    private final HashMap<KtLoopExpression, IrLoop> loopTable;
    @NotNull
    private final IrSymbol scopeOwnerSymbol;
    @NotNull
    private final GeneratorContext context;

    @NotNull
    public final DeclarationDescriptor getScopeOwner() {
        return this.scopeOwnerSymbol.getDescriptor();
    }

    private final IrType toIrType(@NotNull KotlinType $receiver) {
        return this.typeTranslator.translateType($receiver);
    }

    @Override
    @NotNull
    public Scope getScope() {
        return this.scope;
    }

    @NotNull
    public final IrBody generateFunctionBody(@NotNull KtExpression ktBody) {
        Intrinsics.checkParameterIsNotNull(ktBody, "ktBody");
        StatementGenerator statementGenerator = this.createStatementGenerator();
        IrBlockBodyImpl irBlockBody2 = new IrBlockBodyImpl(PsiUtilsKt.getStartOffset(ktBody), PsiUtilsKt.getEndOffset(ktBody));
        if (ktBody instanceof KtBlockExpression) {
            List<KtExpression> list2 = ((KtBlockExpression)ktBody).getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list2, "ktBody.statements");
            statementGenerator.generateStatements(list2, irBlockBody2);
        } else {
            this.generateReturnExpression(statementGenerator, ktBody, irBlockBody2);
        }
        return irBlockBody2;
    }

    @NotNull
    public final IrExpressionBody generateExpressionBody(@NotNull KtExpression ktExpression) {
        Intrinsics.checkParameterIsNotNull(ktExpression, "ktExpression");
        return new IrExpressionBodyImpl(this.createStatementGenerator().generateExpression(ktExpression));
    }

    @NotNull
    public final IrBody generateLambdaBody(@NotNull KtFunctionLiteral ktFun) {
        List<KtExpression> ktBodyStatements;
        KtBlockExpression ktBody;
        Intrinsics.checkParameterIsNotNull(ktFun, "ktFun");
        StatementGenerator statementGenerator = this.createStatementGenerator();
        KtBlockExpression ktBlockExpression = ktFun.getBodyExpression();
        if (ktBlockExpression == null) {
            Intrinsics.throwNpe();
        }
        KtBlockExpression ktBlockExpression2 = ktBody = ktBlockExpression;
        Intrinsics.checkExpressionValueIsNotNull(ktBlockExpression2, "ktBody");
        IrBlockBodyImpl irBlockBody2 = new IrBlockBodyImpl(PsiUtilsKt.getStartOffset(ktBlockExpression2), PsiUtilsKt.getEndOffset(ktBody));
        Object object = ktFun.getValueParameters().iterator();
        while (object.hasNext()) {
            KtDestructuringDeclaration ktDestructuringDeclaration;
            KtParameter ktParameter;
            KtParameter ktParameter2 = ktParameter = object.next();
            Intrinsics.checkExpressionValueIsNotNull(ktParameter2, "ktParameter");
            if (ktParameter2.getDestructuringDeclaration() == null) {
                continue;
            }
            WritableSlice<KtParameter, VariableDescriptor> writableSlice = BindingContext.VALUE_PARAMETER;
            Intrinsics.checkExpressionValueIsNotNull(writableSlice, "BindingContext.VALUE_PARAMETER");
            VariableDescriptor valueParameter = (VariableDescriptor)GeneratorKt.getOrFail(this, writableSlice, ktParameter);
            IrGeneratorContext irGeneratorContext = this.getContext();
            KtDestructuringDeclaration ktDestructuringDeclaration2 = ktDestructuringDeclaration;
            Intrinsics.checkExpressionValueIsNotNull(ktDestructuringDeclaration2, "ktDestructuringDeclaration");
            int n = PsiUtilsKt.getStartOffset(ktDestructuringDeclaration2);
            int n2 = PsiUtilsKt.getEndOffset(ktDestructuringDeclaration);
            SymbolTable symbolTable = this.getContext().getSymbolTable();
            VariableDescriptor variableDescriptor = valueParameter;
            Intrinsics.checkExpressionValueIsNotNull(variableDescriptor, "valueParameter");
            IrValueSymbol irValueSymbol = symbolTable.referenceValue(variableDescriptor);
            KotlinType kotlinType = valueParameter.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "valueParameter.type");
            VariableLValue parameterValue = new VariableLValue(irGeneratorContext, n, n2, irValueSymbol, this.toIrType(kotlinType), IrStatementOrigin.DESTRUCTURING_DECLARATION.INSTANCE);
            statementGenerator.declareComponentVariablesInBlock(ktDestructuringDeclaration, irBlockBody2, parameterValue);
        }
        List<KtExpression> list2 = ktBodyStatements = ktBody.getStatements();
        Intrinsics.checkExpressionValueIsNotNull(list2, "ktBodyStatements");
        object = list2;
        if (!object.isEmpty()) {
            KtExpression ktReturnedValue;
            for (KtExpression ktStatement : CollectionsKt.dropLast(ktBodyStatements, 1)) {
                List<IrStatement> list3 = irBlockBody2.getStatements();
                KtExpression ktExpression = ktStatement;
                Intrinsics.checkExpressionValueIsNotNull(ktExpression, "ktStatement");
                list3.add(statementGenerator.generateStatement(ktExpression));
            }
            KtExpression ktExpression = ktReturnedValue = CollectionsKt.last(ktBodyStatements);
            Intrinsics.checkExpressionValueIsNotNull(ktExpression, "ktReturnedValue");
            this.generateReturnExpression(statementGenerator, ktExpression, irBlockBody2);
        } else {
            List<IrStatement> list4 = irBlockBody2.getStatements();
            int n = PsiUtilsKt.getStartOffset(ktBody);
            int n3 = PsiUtilsKt.getEndOffset(ktBody);
            int n4 = PsiUtilsKt.getStartOffset(ktBody);
            int n5 = PsiUtilsKt.getEndOffset(ktBody);
            IrType irType = this.getContext().getIrBuiltIns().getUnitType();
            SymbolTable symbolTable = this.getContext().getSymbolTable();
            ClassDescriptor classDescriptor = this.getContext().getBuiltIns().getUnit();
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "context.builtIns.unit");
            list4.add(this.generateReturnExpression(n, n3, new IrGetObjectValueImpl(n4, n5, irType, symbolTable.referenceClass(classDescriptor))));
        }
        return irBlockBody2;
    }

    private final void generateReturnExpression(@NotNull StatementGenerator $receiver, KtExpression ktExpression, IrBlockBodyImpl irBlockBody2) {
        IrStatement irReturnExpression = $receiver.generateStatement(ktExpression);
        if (irReturnExpression instanceof IrExpression) {
            irBlockBody2.getStatements().add(this.wrapWithReturn((IrExpression)irReturnExpression));
        } else {
            irBlockBody2.getStatements().add(irReturnExpression);
        }
    }

    private final IrExpression wrapWithReturn(@NotNull IrExpression $receiver) {
        return $receiver instanceof IrReturn || $receiver instanceof IrErrorExpression || $receiver instanceof IrThrow ? $receiver : (IrExpression)this.generateReturnExpression($receiver.getStartOffset(), $receiver.getEndOffset(), $receiver);
    }

    private final IrReturnImpl generateReturnExpression(int startOffset, int endOffset, IrExpression returnValue) {
        DeclarationDescriptor declarationDescriptor = this.getScopeOwner();
        if (!(declarationDescriptor instanceof CallableDescriptor)) {
            declarationDescriptor = null;
        }
        CallableDescriptor callableDescriptor = (CallableDescriptor)declarationDescriptor;
        if (callableDescriptor == null) {
            throw (Throwable)((Object)new AssertionError((Object)("'return' in a non-callable: " + this.getScopeOwner())));
        }
        CallableDescriptor returnTarget = callableDescriptor;
        return new IrReturnImpl(startOffset, endOffset, this.getContext().getIrBuiltIns().getNothingType(), IrUtilsKt.referenceFunction(this.getContext().getSymbolTable(), returnTarget), returnValue);
    }

    @NotNull
    public final IrBody generateSecondaryConstructorBody(@NotNull KtSecondaryConstructor ktConstructor) {
        IrBlockBodyImpl irBlockBody2;
        block0: {
            KtBlockExpression ktBlockExpression;
            Intrinsics.checkParameterIsNotNull(ktConstructor, "ktConstructor");
            irBlockBody2 = new IrBlockBodyImpl(PsiUtilsKt.getStartOffset(ktConstructor), PsiUtilsKt.getEndOffset(ktConstructor));
            this.generateDelegatingConstructorCall(irBlockBody2, ktConstructor);
            KtBlockExpression ktBlockExpression2 = ktConstructor.getBodyExpression();
            if (ktBlockExpression2 == null) break block0;
            KtBlockExpression ktBody = ktBlockExpression = ktBlockExpression2;
            StatementGenerator statementGenerator = this.createStatementGenerator();
            List<KtExpression> list2 = ktBody.getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list2, "ktBody.statements");
            statementGenerator.generateStatements(list2, irBlockBody2);
        }
        return irBlockBody2;
    }

    private final void generateDelegatingConstructorCall(IrBlockBodyImpl irBlockBody2, KtSecondaryConstructor ktConstructor) {
        DeclarationDescriptor declarationDescriptor = this.getScopeOwner();
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor");
        }
        ClassConstructorDescriptor constructorDescriptor = (ClassConstructorDescriptor)declarationDescriptor;
        StatementGenerator statementGenerator = this.createStatementGenerator();
        KtConstructorDelegationCall ktDelegatingConstructorCall = ktConstructor.getDelegationCall();
        ResolvedCall<? extends CallableDescriptor> delegatingConstructorResolvedCall = GeneratorKt.getResolvedCall(this, ktDelegatingConstructorCall);
        if (delegatingConstructorResolvedCall == null) {
            ClassDescriptor classDescriptor = constructorDescriptor.getContainingDeclaration();
            if (classDescriptor.getKind() == ClassKind.ENUM_CLASS) {
                this.generateEnumSuperConstructorCall(irBlockBody2, ktConstructor, classDescriptor);
            } else {
                this.generateAnySuperConstructorCall(irBlockBody2, ktConstructor);
            }
            return;
        }
        CallBuilder delegatingConstructorCall = ArgumentsGenerationUtilsKt.pregenerateCall(statementGenerator, delegatingConstructorResolvedCall);
        IrExpression irDelegatingConstructorCall = new CallGenerator(statementGenerator).generateDelegatingConstructorCall(PsiUtilsKt.getStartOffset(ktDelegatingConstructorCall), PsiUtilsKt.getEndOffset(ktDelegatingConstructorCall), delegatingConstructorCall);
        irBlockBody2.getStatements().add(irDelegatingConstructorCall);
    }

    @NotNull
    public final StatementGenerator createStatementGenerator() {
        return new StatementGenerator(this, this.getScope());
    }

    public final void putLoop(@NotNull KtLoopExpression expression2, @NotNull IrLoop irLoop) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(irLoop, "irLoop");
        Map map2 = this.loopTable;
        IrLoop irLoop2 = irLoop;
        map2.put(expression2, irLoop2);
    }

    @Nullable
    public final IrLoop getLoop(@NotNull KtExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Map map2 = this.loopTable;
        return (IrLoop)map2.get(expression2);
    }

    @NotNull
    public final IrBody generatePrimaryConstructorBody(@NotNull KtPureClassOrObject ktClassOrObject) {
        Intrinsics.checkParameterIsNotNull(ktClassOrObject, "ktClassOrObject");
        IrBlockBodyImpl irBlockBody2 = new IrBlockBodyImpl(PsiUtilsKt.getPureStartOffset(ktClassOrObject), PsiUtilsKt.getPureEndOffset(ktClassOrObject));
        this.generateSuperConstructorCall(irBlockBody2, ktClassOrObject);
        DeclarationDescriptor declarationDescriptor = this.getScopeOwner();
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor");
        }
        ClassDescriptor classDescriptor = ((ClassConstructorDescriptor)declarationDescriptor).getContainingDeclaration();
        irBlockBody2.getStatements().add(new IrInstanceInitializerCallImpl(PsiUtilsKt.getPureStartOffset(ktClassOrObject), PsiUtilsKt.getPureEndOffset(ktClassOrObject), this.getContext().getSymbolTable().referenceClass(classDescriptor), this.getContext().getIrBuiltIns().getUnitType()));
        return irBlockBody2;
    }

    @NotNull
    public final IrBody generateSecondaryConstructorBodyWithNestedInitializers(@NotNull KtSecondaryConstructor ktConstructor) {
        IrBlockBodyImpl irBlockBody2;
        block1: {
            KtBlockExpression ktBlockExpression;
            Intrinsics.checkParameterIsNotNull(ktConstructor, "ktConstructor");
            irBlockBody2 = new IrBlockBodyImpl(PsiUtilsKt.getStartOffset(ktConstructor), PsiUtilsKt.getEndOffset(ktConstructor));
            this.generateDelegatingConstructorCall(irBlockBody2, ktConstructor);
            WritableSlice<PsiElement, ConstructorDescriptor> writableSlice = BindingContext.CONSTRUCTOR;
            Intrinsics.checkExpressionValueIsNotNull(writableSlice, "BindingContext.CONSTRUCTOR");
            Object v2 = GeneratorKt.getOrFail(this, writableSlice, ktConstructor);
            Intrinsics.checkExpressionValueIsNotNull(v2, "getOrFail(BindingContext\u2026NSTRUCTOR, ktConstructor)");
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)v2).getContainingDeclaration();
            if (classifierDescriptorWithTypeParameters == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptorWithTypeParameters;
            irBlockBody2.getStatements().add(new IrInstanceInitializerCallImpl(PsiUtilsKt.getStartOffset(ktConstructor), PsiUtilsKt.getEndOffset(ktConstructor), this.getContext().getSymbolTable().referenceClass(classDescriptor), this.getContext().getIrBuiltIns().getUnitType()));
            KtBlockExpression ktBlockExpression2 = ktConstructor.getBodyExpression();
            if (ktBlockExpression2 == null) break block1;
            KtBlockExpression ktBody = ktBlockExpression = ktBlockExpression2;
            StatementGenerator statementGenerator = this.createStatementGenerator();
            List<KtExpression> list2 = ktBody.getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list2, "ktBody.statements");
            statementGenerator.generateStatements(list2, irBlockBody2);
        }
        return irBlockBody2;
    }

    private final void generateSuperConstructorCall(IrBlockBodyImpl irBlockBody2, KtPureClassOrObject ktClassOrObject) {
        ClassDescriptor classDescriptor = SyntheticClassOrObjectDescriptorKt.findClassDescriptor(ktClassOrObject, this.getContext().getBindingContext());
        switch (BodyGenerator$WhenMappings.$EnumSwitchMapping$0[classDescriptor.getKind().ordinal()]) {
            case 1: {
                KtPureClassOrObject ktPureClassOrObject = ktClassOrObject;
                if (ktPureClassOrObject == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
                }
                this.generateEnumSuperConstructorCall(irBlockBody2, (KtClassOrObject)ktPureClassOrObject, classDescriptor);
                break;
            }
            case 2: {
                KtPureClassOrObject ktPureClassOrObject = ktClassOrObject;
                if (ktPureClassOrObject == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtEnumEntry");
                }
                irBlockBody2.getStatements().add(this.generateEnumEntrySuperConstructorCall((KtEnumEntry)ktPureClassOrObject, classDescriptor));
                break;
            }
            default: {
                KtElementImplStub ktElementImplStub;
                StatementGenerator statementGenerator = this.createStatementGenerator();
                KtPureClassOrObject ktPureClassOrObject = ktClassOrObject;
                if (!(ktPureClassOrObject instanceof KtClassOrObject)) {
                    ktPureClassOrObject = null;
                }
                if ((ktElementImplStub = (KtClassOrObject)ktPureClassOrObject) != null && (ktElementImplStub = ((KtClassOrObject)ktElementImplStub).getSuperTypeList()) != null) {
                    KtElementImplStub ktElementImplStub2;
                    KtElementImplStub ktSuperTypeList = ktElementImplStub2 = ktElementImplStub;
                    for (KtSuperTypeListEntry ktSuperTypeListEntry : ((KtSuperTypeList)ktSuperTypeList).getEntries()) {
                        if (!(ktSuperTypeListEntry instanceof KtSuperTypeCallEntry)) continue;
                        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, ktSuperTypeListEntry);
                        if (resolvedCall2 == null) {
                            Intrinsics.throwNpe();
                        }
                        CallBuilder superConstructorCall = ArgumentsGenerationUtilsKt.pregenerateCall(statementGenerator, resolvedCall2);
                        IrExpression irSuperConstructorCall = new CallGenerator(statementGenerator).generateDelegatingConstructorCall(PsiUtilsKt.getStartOffset(ktSuperTypeListEntry), PsiUtilsKt.getEndOffset(ktSuperTypeListEntry), superConstructorCall);
                        irBlockBody2.getStatements().add(irSuperConstructorCall);
                        return;
                    }
                }
                ClassDescriptor superClass = DescriptorUtilsKt.getSuperClassOrAny(classDescriptor);
                boolean bl = KotlinBuiltIns.isAny(superClass);
                if (_Assertions.ENABLED && !bl) {
                    String string = classDescriptor + ": Super class should be any: " + superClass;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                this.generateAnySuperConstructorCall(irBlockBody2, ktClassOrObject);
            }
        }
    }

    private final void generateAnySuperConstructorCall(IrBlockBodyImpl irBlockBody2, KtPureElement ktElement) {
        ClassDescriptor classDescriptor = this.getContext().getBuiltIns().getAny();
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "context.builtIns.any");
        Collection<ClassConstructorDescriptor> collection = classDescriptor.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(collection, "context.builtIns.any.constructors");
        ClassConstructorDescriptor anyConstructor = (ClassConstructorDescriptor)CollectionsKt.single((Iterable)collection);
        List<IrStatement> list2 = irBlockBody2.getStatements();
        int n = PsiUtilsKt.getPureStartOffset(ktElement);
        int n2 = PsiUtilsKt.getPureEndOffset(ktElement);
        IrType irType = this.getContext().getIrBuiltIns().getUnitType();
        SymbolTable symbolTable = this.getContext().getSymbolTable();
        ClassConstructorDescriptor classConstructorDescriptor = anyConstructor;
        Intrinsics.checkExpressionValueIsNotNull(classConstructorDescriptor, "anyConstructor");
        list2.add(new IrDelegatingConstructorCallImpl(n, n2, irType, symbolTable.referenceConstructor(classConstructorDescriptor), anyConstructor));
    }

    private final void generateEnumSuperConstructorCall(IrBlockBodyImpl irBlockBody2, KtElement ktElement, ClassDescriptor classDescriptor) {
        ClassDescriptor classDescriptor2 = this.getContext().getBuiltIns().getEnum();
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "context.builtIns.enum");
        Collection<ClassConstructorDescriptor> collection = classDescriptor2.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(collection, "context.builtIns.enum.constructors");
        ClassConstructorDescriptor enumConstructor = (ClassConstructorDescriptor)CollectionsKt.single((Iterable)collection);
        List<IrStatement> list2 = irBlockBody2.getStatements();
        int n = PsiUtilsKt.getStartOffset(ktElement);
        int n2 = PsiUtilsKt.getEndOffset(ktElement);
        IrType irType = this.getContext().getIrBuiltIns().getUnitType();
        SymbolTable symbolTable = this.getContext().getSymbolTable();
        ClassConstructorDescriptor classConstructorDescriptor = enumConstructor;
        Intrinsics.checkExpressionValueIsNotNull(classConstructorDescriptor, "enumConstructor");
        IrEnumConstructorCallImpl irEnumConstructorCallImpl = new IrEnumConstructorCallImpl(n, n2, irType, symbolTable.referenceConstructor(classConstructorDescriptor), 1);
        List<IrStatement> list3 = list2;
        IrEnumConstructorCallImpl $receiver = irEnumConstructorCallImpl;
        SimpleType simpleType2 = classDescriptor.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "classDescriptor.defaultType");
        $receiver.putTypeArgument(0, this.toIrType(simpleType2));
        IrEnumConstructorCallImpl irEnumConstructorCallImpl2 = irEnumConstructorCallImpl;
        list3.add(irEnumConstructorCallImpl2);
    }

    private final IrExpression generateEnumEntrySuperConstructorCall(KtEnumEntry ktEnumEntry, ClassDescriptor enumEntryDescriptor) {
        DeclarationDescriptor declarationDescriptor = enumEntryDescriptor.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        return this.generateEnumConstructorCallOrSuperCall(ktEnumEntry, (ClassDescriptor)declarationDescriptor);
    }

    @NotNull
    public final IrExpression generateEnumEntryInitializer(@NotNull KtEnumEntry ktEnumEntry, @NotNull ClassDescriptor enumEntryDescriptor) {
        Intrinsics.checkParameterIsNotNull(ktEnumEntry, "ktEnumEntry");
        Intrinsics.checkParameterIsNotNull(enumEntryDescriptor, "enumEntryDescriptor");
        Collection collection = ktEnumEntry.getDeclarations();
        if (!collection.isEmpty()) {
            ClassConstructorDescriptor classConstructorDescriptor = enumEntryDescriptor.getUnsubstitutedPrimaryConstructor();
            if (classConstructorDescriptor == null) {
                Intrinsics.throwNpe();
            }
            ClassConstructorDescriptor enumEntryConstructor = classConstructorDescriptor;
            int n = PsiUtilsKt.getStartOffset(ktEnumEntry);
            int n2 = PsiUtilsKt.getEndOffset(ktEnumEntry);
            IrType irType = this.getContext().getIrBuiltIns().getUnitType();
            SymbolTable symbolTable = this.getContext().getSymbolTable();
            ClassConstructorDescriptor classConstructorDescriptor2 = enumEntryConstructor;
            Intrinsics.checkExpressionValueIsNotNull(classConstructorDescriptor2, "enumEntryConstructor");
            return new IrEnumConstructorCallImpl(n, n2, irType, symbolTable.referenceConstructor(classConstructorDescriptor2), 0);
        }
        DeclarationDescriptor declarationDescriptor = enumEntryDescriptor.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        return this.generateEnumConstructorCallOrSuperCall(ktEnumEntry, (ClassDescriptor)declarationDescriptor);
    }

    private final IrExpression generateEnumConstructorCallOrSuperCall(KtEnumEntry ktEnumEntry, ClassDescriptor enumClassDescriptor) {
        StatementGenerator statementGenerator = this.createStatementGenerator();
        List<KtSuperTypeListEntry> list2 = ktEnumEntry.getSuperTypeListEntries();
        Intrinsics.checkExpressionValueIsNotNull(list2, "ktEnumEntry.superTypeListEntries");
        KtSuperTypeListEntry ktSuperCallElement = CollectionsKt.firstOrNull(list2);
        if (ktSuperCallElement != null) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, ktSuperCallElement);
            if (resolvedCall2 == null) {
                Intrinsics.throwNpe();
            }
            return this.generateEnumConstructorCall(statementGenerator, resolvedCall2, ktEnumEntry);
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = GeneratorKt.getResolvedCall(this, ktEnumEntry);
        if (resolvedCall3 == null) {
            throw (Throwable)((Object)new AssertionError((Object)("No default constructor call for enum entry " + enumClassDescriptor)));
        }
        ResolvedCall<? extends CallableDescriptor> enumDefaultConstructorCall = resolvedCall3;
        return this.generateEnumConstructorCall(statementGenerator, enumDefaultConstructorCall, ktEnumEntry);
    }

    private final IrExpression generateEnumConstructorCall(@NotNull StatementGenerator $receiver, ResolvedCall<? extends CallableDescriptor> constructorCall, KtEnumEntry ktEnumEntry) {
        return new CallGenerator($receiver).generateEnumConstructorSuperCall(PsiUtilsKt.getStartOffset(ktEnumEntry), PsiUtilsKt.getEndOffset(ktEnumEntry), ArgumentsGenerationUtilsKt.pregenerateCall($receiver, constructorCall));
    }

    @NotNull
    public final IrSymbol getScopeOwnerSymbol() {
        return this.scopeOwnerSymbol;
    }

    @Override
    @NotNull
    public GeneratorContext getContext() {
        return this.context;
    }

    public BodyGenerator(@NotNull IrSymbol scopeOwnerSymbol, @NotNull GeneratorContext context) {
        Intrinsics.checkParameterIsNotNull(scopeOwnerSymbol, "scopeOwnerSymbol");
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.scopeOwnerSymbol = scopeOwnerSymbol;
        this.context = context;
        this.typeTranslator = this.getContext().getTypeTranslator();
        this.scope = new Scope(this.scopeOwnerSymbol);
        this.loopTable = new HashMap();
    }
}

