/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.components.PostponedArgumentsAnalyzer;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.NewConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.components.KotlinConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintStorage;
import org.jetbrains.kotlin.resolve.calls.inference.model.DelegatedPropertyConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallComponents;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedLambdaAtom;
import org.jetbrains.kotlin.resolve.calls.tower.ManyCandidatesResolver;
import org.jetbrains.kotlin.resolve.calls.tower.PSICallResolver;
import org.jetbrains.kotlin.resolve.calls.tower.PSIPartialCallInfo;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J$\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00060\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016J\b\u0010$\u001a\u00020%H\u0016J\u001c\u0010&\u001a\u00020\u001e*\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020*H\u0002J\u0014\u0010+\u001a\u00020\u001e*\u00020'2\u0006\u0010\u001f\u001a\u00020*H\u0002J\u0014\u0010,\u001a\u00020\u001e*\u00020'2\u0006\u0010\u001f\u001a\u00020*H\u0002R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/resolve/DelegatedPropertyInferenceSession;", "Lorg/jetbrains/kotlin/resolve/calls/tower/ManyCandidatesResolver;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "expectedType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "psiCallResolver", "Lorg/jetbrains/kotlin/resolve/calls/tower/PSICallResolver;", "postponedArgumentsAnalyzer", "Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;", "kotlinConstraintSystemCompleter", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter;", "callComponents", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/types/UnwrappedType;Lorg/jetbrains/kotlin/resolve/calls/tower/PSICallResolver;Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter;Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "getExpectedType", "()Lorg/jetbrains/kotlin/types/UnwrappedType;", "getVariableDescriptor", "()Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "inferPostponedVariables", "", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "lambda", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedLambdaAtom;", "initialStorage", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintStorage;", "prepareForCompletion", "", "commonSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/NewConstraintSystem;", "resolvedCallsInfo", "", "Lorg/jetbrains/kotlin/resolve/calls/tower/PSIPartialCallInfo;", "writeOnlyStubs", "", "addConstraintForThis", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallAtom;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "addConstraintsForGetValueMethod", "addConstraintsForSetValueMethod", "frontend"})
public final class DelegatedPropertyInferenceSession
extends ManyCandidatesResolver<FunctionDescriptor> {
    @NotNull
    private final VariableDescriptorWithAccessors variableDescriptor;
    @Nullable
    private final UnwrappedType expectedType;

    @Override
    public void prepareForCompletion(@NotNull NewConstraintSystem commonSystem, @NotNull List<PSIPartialCallInfo> resolvedCallsInfo) {
        Intrinsics.checkParameterIsNotNull(commonSystem, "commonSystem");
        Intrinsics.checkParameterIsNotNull(resolvedCallsInfo, "resolvedCallsInfo");
        ConstraintSystemBuilder csBuilder = commonSystem.getBuilder();
        for (PSIPartialCallInfo callInfo : resolvedCallsInfo) {
            ResolvedCallAtom resultAtom = callInfo.getCallResolutionResult().getResultCallAtom();
            Name name = resultAtom.getCandidateDescriptor().getName();
            if (Intrinsics.areEqual(name, OperatorNameConventions.GET_VALUE)) {
                this.addConstraintsForGetValueMethod(resultAtom, csBuilder);
                continue;
            }
            if (!Intrinsics.areEqual(name, OperatorNameConventions.SET_VALUE)) continue;
            this.addConstraintsForSetValueMethod(resultAtom, csBuilder);
        }
    }

    private final void addConstraintForThis(@NotNull ResolvedCallAtom $receiver, CallableDescriptor descriptor2, ConstraintSystemBuilder commonSystem) {
        Annotated annotated;
        Annotated annotated2 = this.variableDescriptor.getExtensionReceiverParameter();
        if (annotated2 == null || (annotated2 = annotated2.getType()) == null) {
            ReceiverParameterDescriptor receiverParameterDescriptor = this.variableDescriptor.getDispatchReceiverParameter();
            annotated2 = annotated = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
        }
        if (annotated2 == null) {
            annotated = this.getBuiltIns().getNullableNothingType();
        }
        Annotated typeOfThis = annotated;
        List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "descriptor.valueParameters");
        ValueParameterDescriptor valueParameterDescriptor = CollectionsKt.getOrNull(list2, 0);
        if (valueParameterDescriptor == null) {
            return;
        }
        ValueParameterDescriptor valueParameterForThis = valueParameterDescriptor;
        UnwrappedType substitutedType = $receiver.getSubstitutor().substituteKeepAnnotations(valueParameterForThis.getType().unwrap());
        commonSystem.addSubtypeConstraint(((KotlinType)typeOfThis).unwrap(), substitutedType, new DelegatedPropertyConstraintPosition($receiver.getAtom()));
    }

    private final void addConstraintsForGetValueMethod(@NotNull ResolvedCallAtom $receiver, ConstraintSystemBuilder commonSystem) {
        if (this.expectedType != null) {
            KotlinType kotlinType = $receiver.getCandidateDescriptor().getReturnType();
            if (kotlinType == null || (kotlinType = kotlinType.unwrap()) == null) {
                return;
            }
            KotlinType unsubstitutedReturnType = kotlinType;
            UnwrappedType substitutedReturnType = $receiver.getSubstitutor().substituteKeepAnnotations((UnwrappedType)unsubstitutedReturnType);
            commonSystem.addSubtypeConstraint(substitutedReturnType, this.expectedType, new DelegatedPropertyConstraintPosition($receiver.getAtom()));
        }
        this.addConstraintForThis($receiver, $receiver.getCandidateDescriptor(), commonSystem);
    }

    private final void addConstraintsForSetValueMethod(@NotNull ResolvedCallAtom $receiver, ConstraintSystemBuilder commonSystem) {
        if (this.expectedType != null) {
            List<ValueParameterDescriptor> list2 = $receiver.getCandidateDescriptor().getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, "candidateDescriptor.valueParameters");
            Annotated annotated = CollectionsKt.getOrNull(list2, 2);
            if (annotated == null || (annotated = annotated.getType()) == null || (annotated = ((KotlinType)annotated).unwrap()) == null) {
                return;
            }
            Annotated unsubstitutedParameterType = annotated;
            UnwrappedType substitutedParameterType = $receiver.getSubstitutor().substituteKeepAnnotations((UnwrappedType)unsubstitutedParameterType);
            commonSystem.addSubtypeConstraint(this.expectedType, substitutedParameterType, new DelegatedPropertyConstraintPosition($receiver.getAtom()));
        }
        this.addConstraintForThis($receiver, $receiver.getCandidateDescriptor(), commonSystem);
    }

    @Override
    @NotNull
    public Map<TypeConstructor, UnwrappedType> inferPostponedVariables(@NotNull ResolvedLambdaAtom lambda2, @NotNull ConstraintStorage initialStorage) {
        Intrinsics.checkParameterIsNotNull(lambda2, "lambda");
        Intrinsics.checkParameterIsNotNull(initialStorage, "initialStorage");
        return MapsKt.emptyMap();
    }

    @Override
    public boolean writeOnlyStubs() {
        return false;
    }

    @NotNull
    public final VariableDescriptorWithAccessors getVariableDescriptor() {
        return this.variableDescriptor;
    }

    @Nullable
    public final UnwrappedType getExpectedType() {
        return this.expectedType;
    }

    public DelegatedPropertyInferenceSession(@NotNull VariableDescriptorWithAccessors variableDescriptor, @Nullable UnwrappedType expectedType, @NotNull PSICallResolver psiCallResolver, @NotNull PostponedArgumentsAnalyzer postponedArgumentsAnalyzer, @NotNull KotlinConstraintSystemCompleter kotlinConstraintSystemCompleter, @NotNull KotlinCallComponents callComponents, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(variableDescriptor, "variableDescriptor");
        Intrinsics.checkParameterIsNotNull(psiCallResolver, "psiCallResolver");
        Intrinsics.checkParameterIsNotNull(postponedArgumentsAnalyzer, "postponedArgumentsAnalyzer");
        Intrinsics.checkParameterIsNotNull(kotlinConstraintSystemCompleter, "kotlinConstraintSystemCompleter");
        Intrinsics.checkParameterIsNotNull(callComponents, "callComponents");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        super(psiCallResolver, postponedArgumentsAnalyzer, kotlinConstraintSystemCompleter, callComponents, builtIns);
        this.variableDescriptor = variableDescriptor;
        this.expectedType = expectedType;
    }
}

