/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.ScriptDefinitionProvider;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"findScriptDefinition", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "psi"})
public final class KotlinScriptDefinitionProviderKt {
    @Nullable
    public static final KotlinScriptDefinition findScriptDefinition(@NotNull VirtualFile file2, @NotNull Project project) {
        block7: {
            block6: {
                Intrinsics.checkParameterIsNotNull(file2, "file");
                Intrinsics.checkParameterIsNotNull(project, "project");
                if (file2.isDirectory()) {
                    return null;
                }
                if (Intrinsics.areEqual(file2.getExtension(), "kt")) break block6;
                String string = file2.getExtension();
                JavaClassFileType javaClassFileType = JavaClassFileType.INSTANCE;
                Intrinsics.checkExpressionValueIsNotNull(javaClassFileType, "JavaClassFileType.INSTANCE");
                if (!Intrinsics.areEqual(string, javaClassFileType.getDefaultExtension())) break block7;
            }
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance(project).findFile(file2);
        if (psiFile != null) {
            if (!(psiFile instanceof KtFile) || !((KtFile)psiFile).isScript()) {
                return null;
            }
            Object object = ((KtFile)psiFile).getScript();
            return object != null && (object = ((KtScript)object).kotlinScriptDefinition) != null ? (KotlinScriptDefinition)object.getValue() : null;
        }
        ScriptDefinitionProvider scriptDefinitionProvider = ScriptDefinitionProvider.Companion.getInstance(project);
        String string = file2.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "file.name");
        return scriptDefinitionProvider.findScriptDefinition(string);
    }

    @Nullable
    public static final KotlinScriptDefinition findScriptDefinition(@NotNull PsiFile psiFile) {
        Object object;
        Intrinsics.checkParameterIsNotNull(psiFile, "psiFile");
        if (psiFile.isDirectory()) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        return (object = (KtFile)psiFile2) != null && (object = ((KtFile)object).getScript()) != null && (object = ((KtScript)object).kotlinScriptDefinition) != null ? (KotlinScriptDefinition)object.getValue() : null;
    }
}

