/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.WrappedProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import gnu.trove.THashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProgressManager
extends ProgressIndicatorProvider {
    static ProgressManager ourInstance = CachedSingletonsRegistry.markCachedField(ProgressManager.class);

    @NotNull
    public static ProgressManager getInstance() {
        ProgressManager result2 = ourInstance;
        if (result2 == null) {
            ourInstance = result2 = ServiceManager.getService(ProgressManager.class);
        }
        ProgressManager progressManager = result2;
        if (progressManager == null) {
            ProgressManager.$$$reportNull$$$0(0);
        }
        return progressManager;
    }

    public abstract boolean hasProgressIndicator();

    public abstract boolean hasModalProgressIndicator();

    public abstract boolean hasUnsafeProgressIndicator();

    public abstract void runProcess(@NotNull Runnable var1, @Nullable ProgressIndicator var2) throws ProcessCanceledException;

    public abstract <T> T runProcess(@NotNull Computable<T> var1, @Nullable ProgressIndicator var2) throws ProcessCanceledException;

    @Override
    public abstract ProgressIndicator getProgressIndicator();

    public static void progress(@NotNull String text2) throws ProcessCanceledException {
        if (text2 == null) {
            ProgressManager.$$$reportNull$$$0(1);
        }
        ProgressManager.progress(text2, "");
    }

    public static void progress2(@NotNull String text2) throws ProcessCanceledException {
        ProgressIndicator pi;
        if (text2 == null) {
            ProgressManager.$$$reportNull$$$0(2);
        }
        if ((pi = ProgressManager.getInstance().getProgressIndicator()) != null) {
            pi.checkCanceled();
            pi.setText2(text2);
        }
    }

    public static void progress(@NotNull String text2, @Nullable String text22) throws ProcessCanceledException {
        ProgressIndicator pi;
        if (text2 == null) {
            ProgressManager.$$$reportNull$$$0(3);
        }
        if ((pi = ProgressManager.getInstance().getProgressIndicator()) != null) {
            pi.checkCanceled();
            pi.setText(text2);
            pi.setText2(text22 == null ? "" : text22);
        }
    }

    public abstract void executeNonCancelableSection(@NotNull Runnable var1);

    public abstract boolean runProcessWithProgressSynchronously(@NotNull Runnable var1, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String var2, boolean var3, @Nullable Project var4);

    public abstract <T, E extends Exception> T runProcessWithProgressSynchronously(@NotNull ThrowableComputable<T, E> var1, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String var2, boolean var3, @Nullable Project var4) throws E;

    public abstract boolean runProcessWithProgressSynchronously(@NotNull Runnable var1, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String var2, boolean var3, @Nullable Project var4, @Nullable JComponent var5);

    @Deprecated
    public abstract void runProcessWithProgressAsynchronously(@NotNull Project var1, @NotNull @Nls String var2, @NotNull Runnable var3, @Nullable Runnable var4, @Nullable Runnable var5);

    @Deprecated
    public abstract void runProcessWithProgressAsynchronously(@NotNull Project var1, @NotNull @Nls String var2, @NotNull Runnable var3, @Nullable Runnable var4, @Nullable Runnable var5, @NotNull PerformInBackgroundOption var6);

    public abstract void run(@NotNull Task var1);

    public <T, E extends Exception> T run(@NotNull Task.WithResult<T, E> task) throws E {
        if (task == null) {
            ProgressManager.$$$reportNull$$$0(4);
        }
        this.run((Task)task);
        return task.getResult();
    }

    public abstract void runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable var1, @NotNull ProgressIndicator var2);

    protected void indicatorCanceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ProgressManager.$$$reportNull$$$0(5);
        }
    }

    public static void canceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ProgressManager.$$$reportNull$$$0(6);
        }
        ProgressManager.getInstance().indicatorCanceled(indicator);
    }

    public static void checkCanceled() throws ProcessCanceledException {
        ProgressManager instance = ourInstance;
        if (instance != null) {
            instance.doCheckCanceled();
        }
    }

    public abstract void executeProcessUnderProgress(@NotNull Runnable var1, @Nullable ProgressIndicator var2) throws ProcessCanceledException;

    public static void assertNotCircular(@NotNull ProgressIndicator original) {
        if (original == null) {
            ProgressManager.$$$reportNull$$$0(7);
        }
        Set wrappedParents = null;
        ProgressIndicator i = original;
        while (i instanceof WrappedProgressIndicator) {
            if (wrappedParents == null) {
                wrappedParents = new THashSet();
            }
            if (!wrappedParents.add(i)) {
                throw new IllegalArgumentException(i + " wraps itself");
            }
            i = ((WrappedProgressIndicator)i).getOriginalProgressIndicator();
        }
    }

    public abstract boolean runInReadActionWithWriteActionPriority(@NotNull Runnable var1, @Nullable ProgressIndicator var2);

    public abstract boolean isInNonCancelableSection();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/ProgressManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/ProgressManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "progress";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "progress2";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "indicatorCanceled";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canceled";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "assertNotCircular";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

