/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrNamer;
import org.jetbrains.kotlin.ir.backend.js.utils.LegacyMemberNameGenerator;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTables;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsRootScope;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamerImpl;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamer;", "memberNameGenerator", "Lorg/jetbrains/kotlin/ir/backend/js/utils/LegacyMemberNameGenerator;", "newNameTables", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTables;", "rootScope", "Lorg/jetbrains/kotlin/js/backend/ast/JsRootScope;", "(Lorg/jetbrains/kotlin/ir/backend/js/utils/LegacyMemberNameGenerator;Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTables;Lorg/jetbrains/kotlin/js/backend/ast/JsRootScope;)V", "getNameForClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getNameForConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getNameForField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getNameForLoop", "", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "getNameForMemberField", "getNameForMemberFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getNameForProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getNameForStaticDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getNameForStaticFunction", "getNameForValueDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "getRefForExternalClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "backend.js"})
public final class IrNamerImpl
implements IrNamer {
    private final LegacyMemberNameGenerator memberNameGenerator;
    private final NameTables newNameTables;
    private final JsRootScope rootScope;

    @Override
    @NotNull
    public JsName getNameForStaticDeclaration(@NotNull IrDeclarationWithName declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        String name = this.newNameTables.getNameForStaticDeclaration(declaration2);
        JsName jsName = this.rootScope.declareName(name);
        Intrinsics.checkExpressionValueIsNotNull(jsName, "rootScope.declareName(name)");
        return jsName;
    }

    @Override
    @Nullable
    public String getNameForLoop(@NotNull IrLoop loop2) {
        Intrinsics.checkParameterIsNotNull(loop2, "loop");
        return this.newNameTables.getNameForLoop(loop2);
    }

    @Override
    @NotNull
    public JsName getNameForConstructor(@NotNull IrConstructor constructor2) {
        Intrinsics.checkParameterIsNotNull(constructor2, "constructor");
        return this.getNameForStaticDeclaration(IrUtilsKt.getParentAsClass(constructor2));
    }

    @Override
    @NotNull
    public JsName getNameForMemberFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkParameterIsNotNull(function2, "function");
        boolean bl = function2.getDispatchReceiverParameter() != null;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.memberNameGenerator.getNameForMemberFunction(function2);
    }

    @Override
    @NotNull
    public JsName getNameForMemberField(@NotNull IrField field2) {
        Intrinsics.checkParameterIsNotNull(field2, "field");
        boolean bl = !field2.isStatic();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.memberNameGenerator.getNameForMemberField(field2);
    }

    @Override
    @NotNull
    public JsName getNameForField(@NotNull IrField field2) {
        Intrinsics.checkParameterIsNotNull(field2, "field");
        return field2.isStatic() ? this.getNameForStaticDeclaration(field2) : this.getNameForMemberField(field2);
    }

    @Override
    @NotNull
    public JsName getNameForValueDeclaration(@NotNull IrValueDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        return this.getNameForStaticDeclaration(declaration2);
    }

    @Override
    @NotNull
    public JsName getNameForClass(@NotNull IrClass klass2) {
        Intrinsics.checkParameterIsNotNull(klass2, "klass");
        return this.getNameForStaticDeclaration(klass2);
    }

    @Override
    @NotNull
    public JsName getNameForStaticFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkParameterIsNotNull(function2, "function");
        return this.getNameForStaticDeclaration(function2);
    }

    @Override
    @NotNull
    public JsName getNameForProperty(@NotNull IrProperty property2) {
        Intrinsics.checkParameterIsNotNull(property2, "property");
        JsName jsName = this.rootScope.declareName(AnnotationUtilsKt.getJsNameOrKotlinName(property2).asString());
        Intrinsics.checkExpressionValueIsNotNull(jsName, "rootScope.declareName(pr\u2026rKotlinName().asString())");
        return jsName;
    }

    @Override
    @NotNull
    public JsNameRef getRefForExternalClass(@NotNull IrClass klass2) {
        JsNameRef jsNameRef;
        Intrinsics.checkParameterIsNotNull(klass2, "klass");
        IrDeclarationParent parent2 = klass2.getParent();
        if (klass2.isCompanion()) {
            IrDeclarationParent irDeclarationParent = parent2;
            if (irDeclarationParent == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            }
            return this.getRefForExternalClass((IrClass)irDeclarationParent);
        }
        String string = AnnotationUtilsKt.getJsNameOrKotlinName(klass2).getIdentifier();
        Intrinsics.checkExpressionValueIsNotNull(string, "klass.getJsNameOrKotlinName().identifier");
        String currentClassName = string;
        IrDeclarationParent irDeclarationParent = parent2;
        if (irDeclarationParent instanceof IrClass) {
            jsNameRef = new JsNameRef(currentClassName, (JsExpression)this.getRefForExternalClass((IrClass)parent2));
        } else if (irDeclarationParent instanceof IrPackageFragment) {
            jsNameRef = new JsNameRef(currentClassName);
        } else {
            String string2 = "Unsupported external class parent " + parent2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return jsNameRef;
    }

    public IrNamerImpl(@NotNull LegacyMemberNameGenerator memberNameGenerator, @NotNull NameTables newNameTables, @NotNull JsRootScope rootScope2) {
        Intrinsics.checkParameterIsNotNull(memberNameGenerator, "memberNameGenerator");
        Intrinsics.checkParameterIsNotNull(newNameTables, "newNameTables");
        Intrinsics.checkParameterIsNotNull(rootScope2, "rootScope");
        this.memberNameGenerator = memberNameGenerator;
        this.newNameTables = newNameTables;
        this.rootScope = rootScope2;
    }
}

