/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.jvm.impl;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.script.experimental.api.CompiledScript;
import kotlin.script.experimental.api.EvaluationResult;
import kotlin.script.experimental.api.ScriptEvaluationConfiguration;
import kotlin.script.experimental.api.ScriptEvaluationKt;
import kotlin.script.experimental.jvm.JvmScriptEvaluationKt;
import kotlin.script.experimental.jvm.impl.KJvmCompiledModule;
import kotlin.script.experimental.jvm.impl.KJvmCompiledModuleFromClassLoader;
import kotlin.script.experimental.jvm.impl.KJvmCompiledScript;
import kotlin.script.experimental.jvm.impl.KJvmCompiledScriptKt;
import kotlin.script.experimental.util.PropertiesCollection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\u001a\u001a\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\t\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a \u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0004\"\b\b\u0000\u0010\u000f*\u00020\u0010*\b\u0012\u0004\u0012\u0002H\u000f0\u0004\u001a\u0016\u0010\u0011\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0012\u001a\u00020\t\u001a\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0007*\u0006\u0012\u0002\b\u00030\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u000e\u0010\u0015\u001a\u00020\u0016*\u0006\u0012\u0002\b\u00030\u0004\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"KOTLIN_SCRIPT_METADATA_EXTENSION_WITH_DOT", "", "KOTLIN_SCRIPT_METADATA_PATH", "createScriptFromClassLoader", "Lkotlin/script/experimental/jvm/impl/KJvmCompiledScript;", "scriptClassFQName", "classLoader", "Ljava/lang/ClassLoader;", "getConfigurationWithClassloader", "Lkotlin/script/experimental/api/ScriptEvaluationConfiguration;", "script", "Lkotlin/script/experimental/api/CompiledScript;", "baseConfiguration", "scriptMetadataPath", "copyWithoutModule", "T", "", "getOrCreateActualClassloader", "evaluationConfiguration", "makeClassLoaderFromDependencies", "baseClassLoader", "toBytes", "", "kotlin-scripting-jvm"})
public final class KJvmCompiledScriptKt {
    @NotNull
    public static final String KOTLIN_SCRIPT_METADATA_PATH = "META-INF/kotlin/script";
    @NotNull
    public static final String KOTLIN_SCRIPT_METADATA_EXTENSION_WITH_DOT = ".kotlin_script";

    @NotNull
    public static final ClassLoader getOrCreateActualClassloader(@NotNull KJvmCompiledScript<?> $this$getOrCreateActualClassloader, @NotNull ScriptEvaluationConfiguration evaluationConfiguration2) {
        Intrinsics.checkParameterIsNotNull($this$getOrCreateActualClassloader, (String)"$this$getOrCreateActualClassloader");
        Intrinsics.checkParameterIsNotNull((Object)evaluationConfiguration2, (String)"evaluationConfiguration");
        ClassLoader classLoader = evaluationConfiguration2.get(JvmScriptEvaluationKt.getActualClassLoader(JvmScriptEvaluationKt.getJvm(ScriptEvaluationConfiguration.Companion)));
        if (classLoader == null) {
            KJvmCompiledScript<?> kJvmCompiledScript = $this$getOrCreateActualClassloader;
            boolean bl = false;
            boolean bl2 = false;
            KJvmCompiledScript<?> $this$run = kJvmCompiledScript;
            boolean bl3 = false;
            KJvmCompiledModule kJvmCompiledModule = $this$run.getCompiledModule();
            if (kJvmCompiledModule == null) {
                throw (Throwable)new IllegalStateException("Illegal call sequence, actualClassloader should be set before calling function on the class without module");
            }
            KJvmCompiledModule module = kJvmCompiledModule;
            ClassLoader baseClassLoader2 = evaluationConfiguration2.get(JvmScriptEvaluationKt.getBaseClassLoader(JvmScriptEvaluationKt.getJvm(ScriptEvaluationConfiguration.Companion)));
            ClassLoader classLoaderWithDeps = Intrinsics.areEqual((Object)evaluationConfiguration2.get(JvmScriptEvaluationKt.getLoadDependencies(JvmScriptEvaluationKt.getJvm(ScriptEvaluationConfiguration.Companion))), (Object)false) ? baseClassLoader2 : KJvmCompiledScriptKt.makeClassLoaderFromDependencies((CompiledScript)$this$run, baseClassLoader2);
            return module.createClassLoader(classLoaderWithDeps);
        }
        return classLoader;
    }

    @NotNull
    public static final ScriptEvaluationConfiguration getConfigurationWithClassloader(@NotNull CompiledScript<?> script, @NotNull ScriptEvaluationConfiguration baseConfiguration) {
        ScriptEvaluationConfiguration scriptEvaluationConfiguration;
        Intrinsics.checkParameterIsNotNull(script, (String)"script");
        Intrinsics.checkParameterIsNotNull((Object)baseConfiguration, (String)"baseConfiguration");
        if (baseConfiguration.containsKey(JvmScriptEvaluationKt.getActualClassLoader(JvmScriptEvaluationKt.getJvm(ScriptEvaluationConfiguration.Companion)))) {
            scriptEvaluationConfiguration = baseConfiguration;
        } else {
            CompiledScript<?> compiledScript = script;
            if (!(compiledScript instanceof KJvmCompiledScript)) {
                compiledScript = null;
            }
            KJvmCompiledScript kJvmCompiledScript = (KJvmCompiledScript)compiledScript;
            if (kJvmCompiledScript == null) {
                throw (Throwable)new IllegalArgumentException("Unexpected compiled script type: " + script);
            }
            KJvmCompiledScript jvmScript = kJvmCompiledScript;
            ClassLoader classloader = KJvmCompiledScriptKt.getOrCreateActualClassloader(jvmScript, baseConfiguration);
            scriptEvaluationConfiguration = new ScriptEvaluationConfiguration(new ScriptEvaluationConfiguration[]{baseConfiguration}, (Function1<? super ScriptEvaluationConfiguration.Builder, Unit>)((Function1)new Function1<ScriptEvaluationConfiguration.Builder, Unit>(classloader, baseConfiguration){
                final /* synthetic */ ClassLoader $classloader;
                final /* synthetic */ ScriptEvaluationConfiguration $baseConfiguration;

                public final void invoke(@NotNull ScriptEvaluationConfiguration.Builder $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    $receiver.invoke(JvmScriptEvaluationKt.getActualClassLoader(JvmScriptEvaluationKt.getJvm(ScriptEvaluationConfiguration.Companion)), this.$classloader);
                    if (Intrinsics.areEqual((Object)this.$baseConfiguration.get(ScriptEvaluationKt.getScriptsInstancesSharing(ScriptEvaluationConfiguration.Companion)), (Object)true)) {
                        PropertiesCollection.Key<Map<KClass<?>, EvaluationResult>> key = JvmScriptEvaluationKt.getScriptsInstancesSharingMap(JvmScriptEvaluationKt.getJvm(ScriptEvaluationConfiguration.Companion));
                        ScriptEvaluationConfiguration.Builder builder = $receiver;
                        boolean bl = false;
                        Map map2 = new LinkedHashMap<K, V>();
                        builder.invoke(key, map2);
                    }
                }
                {
                    this.$classloader = classLoader;
                    this.$baseConfiguration = scriptEvaluationConfiguration;
                    super(1);
                }
            }));
        }
        return scriptEvaluationConfiguration;
    }

    private static final ClassLoader makeClassLoaderFromDependencies(@NotNull CompiledScript<?> $this$makeClassLoaderFromDependencies, ClassLoader baseClassLoader2) {
        ClassLoader classLoader;
        boolean bl = false;
        Set processedScripts = new LinkedHashSet();
        Function2 $fun$seq$1 = new Function2<Sequence<? extends CompiledScript<?>>, CompiledScript<?>, Sequence<? extends CompiledScript<?>>>(processedScripts){
            final /* synthetic */ Set $processedScripts;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Sequence<CompiledScript<?>> invoke(@NotNull Sequence<? extends CompiledScript<?>> res2, @NotNull CompiledScript<?> script) {
                void $this$fold$iv;
                Intrinsics.checkParameterIsNotNull(res2, (String)"res");
                Intrinsics.checkParameterIsNotNull(script, (String)"script");
                if (this.$processedScripts.contains(script)) {
                    return res2;
                }
                this.$processedScripts.add(script);
                Sequence sequence = CollectionsKt.asSequence((Iterable)script.getOtherScripts());
                Sequence<CompiledScript<?>> initial$iv = SequencesKt.plus(res2, script);
                boolean $i$f$fold = false;
                Sequence<CompiledScript<?>> accumulator$iv = initial$iv;
                for (E element$iv : $this$fold$iv) {
                    void p2;
                    CompiledScript compiledScript = (CompiledScript)element$iv;
                    Sequence<CompiledScript<?>> p1 = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = this.invoke((Sequence<? extends CompiledScript<?>>)p1, (CompiledScript<?>)p2);
                }
                return accumulator$iv;
            }
            {
                this.$processedScripts = set;
                super(2);
            }
        };
        Sequence dependencies2 = SequencesKt.distinct((Sequence)SequencesKt.flatMap($fun$seq$1.invoke(SequencesKt.emptySequence(), $this$makeClassLoaderFromDependencies), (Function1)makeClassLoaderFromDependencies.dependencies.1.INSTANCE));
        if (SequencesKt.none((Sequence)dependencies2)) {
            classLoader = baseClassLoader2;
        } else {
            Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)dependencies2);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
            if (uRLArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            URL[] uRLArray2 = uRLArray;
            ClassLoader classLoader2 = baseClassLoader2;
            URL[] uRLArray3 = uRLArray2;
            classLoader = new URLClassLoader(uRLArray3, classLoader2);
        }
        return classLoader;
    }

    @NotNull
    public static final String scriptMetadataPath(@NotNull String scriptClassFQName) {
        Intrinsics.checkParameterIsNotNull((Object)scriptClassFQName, (String)"scriptClassFQName");
        return "META-INF/kotlin/script/" + scriptClassFQName + KOTLIN_SCRIPT_METADATA_EXTENSION_WITH_DOT;
    }

    @NotNull
    public static final <T> KJvmCompiledScript<T> copyWithoutModule(@NotNull KJvmCompiledScript<? extends T> $this$copyWithoutModule) {
        Intrinsics.checkParameterIsNotNull($this$copyWithoutModule, (String)"$this$copyWithoutModule");
        return new KJvmCompiledScript($this$copyWithoutModule.getData$kotlin_scripting_jvm(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] toBytes(@NotNull KJvmCompiledScript<?> $this$toBytes) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull($this$toBytes, (String)"$this$toBytes");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(bos);
            oos.writeObject($this$toBytes);
            oos.flush();
            byte[] byArray2 = bos.toByteArray();
            if (byArray2 == null) {
                Intrinsics.throwNpe();
            }
            byArray = byArray2;
        }
        catch (Throwable throwable) {
            try {
                ObjectOutputStream objectOutputStream = oos;
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            oos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final KJvmCompiledScript<?> createScriptFromClassLoader(@NotNull String scriptClassFQName, @NotNull ClassLoader classLoader) {
        KJvmCompiledScript kJvmCompiledScript;
        Intrinsics.checkParameterIsNotNull((Object)scriptClassFQName, (String)"scriptClassFQName");
        Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
        InputStream inputStream = classLoader.getResourceAsStream(KJvmCompiledScriptKt.scriptMetadataPath(scriptClassFQName));
        if (inputStream == null) {
            throw (Throwable)new IllegalArgumentException("Cannot find metadata for script " + scriptClassFQName);
        }
        InputStream scriptDataStream = inputStream;
        Closeable closeable = new ObjectInputStream(scriptDataStream);
        boolean bl = false;
        Throwable throwable = null;
        try {
            ObjectInputStream it = (ObjectInputStream)closeable;
            boolean bl2 = false;
            Object object = it.readObject();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.script.experimental.jvm.impl.KJvmCompiledScript<*>");
            }
            kJvmCompiledScript = (KJvmCompiledScript)object;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        KJvmCompiledScript script = kJvmCompiledScript;
        script.setCompiledModule(new KJvmCompiledModuleFromClassLoader(classLoader));
        return script;
    }
}

