/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.backend.common.serialization.UniqId;
import org.jetbrains.kotlin.backend.common.serialization.UniqIdKt;
import org.jetbrains.kotlin.backend.common.serialization.proto.DescriptorReference;
import org.jetbrains.kotlin.backend.common.serialization.proto.FqName;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrDataIndex;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorReferenceSerializer;", "", "declarationTable", "Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "serializeString", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrDataIndex;", "serializeFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/FqName;", "(Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getDeclarationTable", "()Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "getSerializeFqName", "()Lkotlin/jvm/functions/Function1;", "getSerializeString", "extractPackageAndClassFqns", "Lkotlin/Pair;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isEnumSpecialMember", "", "serializeDescriptorReference", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/DescriptorReference;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ir.serialization.common"})
public class DescriptorReferenceSerializer {
    @NotNull
    private final DeclarationTable declarationTable;
    @NotNull
    private final Function1<String, IrDataIndex> serializeString;
    @NotNull
    private final Function1<org.jetbrains.kotlin.name.FqName, FqName> serializeFqName;

    private final boolean isEnumSpecialMember(DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof SimpleFunctionDescriptor)) {
            return false;
        }
        return DescriptorFactory.isEnumValueOfMethod((FunctionDescriptor)descriptor2) || DescriptorFactory.isEnumValuesMethod((FunctionDescriptor)descriptor2);
    }

    @Nullable
    public final Pair<org.jetbrains.kotlin.name.FqName, org.jetbrains.kotlin.name.FqName> extractPackageAndClassFqns(@NotNull DeclarationDescriptor descriptor2) {
        Pair<org.jetbrains.kotlin.name.FqName, org.jetbrains.kotlin.name.FqName> pair;
        DeclarationDescriptor containingDeclaration;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        DeclarationDescriptor declarationDescriptor = containingDeclaration = descriptor2.getContainingDeclaration();
        if (declarationDescriptor instanceof ClassDescriptor) {
            ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)containingDeclaration);
            if (classId == null) {
                return null;
            }
            ClassId classId2 = classId;
            org.jetbrains.kotlin.name.FqName fqName2 = classId2.getPackageFqName();
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "classId.packageFqName");
            org.jetbrains.kotlin.name.FqName fqName3 = classId2.getRelativeClassName();
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "classId.relativeClassName");
            pair = new Pair<org.jetbrains.kotlin.name.FqName, org.jetbrains.kotlin.name.FqName>(fqName2, fqName3);
        } else if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            pair = new Pair<org.jetbrains.kotlin.name.FqName, org.jetbrains.kotlin.name.FqName>(((PackageFragmentDescriptor)containingDeclaration).getFqName(), org.jetbrains.kotlin.name.FqName.ROOT);
        } else if (declarationDescriptor instanceof PropertyDescriptor) {
            pair = !(descriptor2 instanceof TypeParameterDescriptor) ? null : this.extractPackageAndClassFqns(containingDeclaration);
        } else {
            return null;
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    public final DescriptorReference serializeDescriptorReference(@NotNull IrDeclaration declaration2) {
        void packageFqName;
        UniqId uniqId;
        boolean bl;
        String string2;
        IrDeclaration discoverableDescriptorsDeclaration;
        IrDeclaration irDeclaration2;
        IrDeclaration realDeclaration;
        IrDeclaration irDeclaration3;
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        DeclarationDescriptor descriptor2 = declaration2.getDescriptor();
        if (!this.declarationTable.isExportedDeclaration(declaration2)) {
            IrDeclaration irDeclaration4 = declaration2;
            if (!(irDeclaration4 instanceof IrDeclarationWithVisibility)) {
                irDeclaration4 = null;
            }
            IrDeclarationWithVisibility irDeclarationWithVisibility = (IrDeclarationWithVisibility)irDeclaration4;
            if (!Intrinsics.areEqual(irDeclarationWithVisibility != null ? irDeclarationWithVisibility.getVisibility() : null, Visibilities.INVISIBLE_FAKE)) {
                return null;
            }
        }
        if (declaration2 instanceof IrAnonymousInitializer) {
            return null;
        }
        if (descriptor2 instanceof ParameterDescriptor) return null;
        if (descriptor2 instanceof VariableDescriptor && !(descriptor2 instanceof PropertyDescriptor)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        if (declarationDescriptor == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "descriptor.containingDeclaration!!");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        Pair<org.jetbrains.kotlin.name.FqName, org.jetbrains.kotlin.name.FqName> pair = this.extractPackageAndClassFqns(descriptor2);
        if (pair == null) return null;
        Pair<org.jetbrains.kotlin.name.FqName, org.jetbrains.kotlin.name.FqName> pair2 = pair;
        org.jetbrains.kotlin.name.FqName fqName2 = pair2.component1();
        org.jetbrains.kotlin.name.FqName classFqName = pair2.component2();
        boolean isAccessor = AdditionalIrUtilsKt.isAccessor(declaration2);
        boolean isBackingField = declaration2 instanceof IrField && ((IrField)declaration2).getCorrespondingProperty() != null;
        boolean isFakeOverride = Intrinsics.areEqual(declaration2.getOrigin(), IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE);
        boolean isDefaultConstructor = descriptor2 instanceof ClassConstructorDescriptor && containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() == ClassKind.OBJECT;
        boolean isEnumEntry = descriptor2 instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY;
        boolean isEnumSpecial = this.isEnumSpecialMember(descriptor2);
        boolean isTypeParameter = declaration2 instanceof IrTypeParameter;
        if (containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() == ClassKind.ENUM_ENTRY && !isFakeOverride) {
            return null;
        }
        if (isFakeOverride) {
            IrElement irElement;
            IrDeclaration irDeclaration5 = declaration2;
            if (irDeclaration5 instanceof IrSimpleFunction) {
                irElement = IrFakeOverrideUtilsKt.resolveFakeOverrideMaybeAbstract((IrSimpleFunction)declaration2);
            } else if (irDeclaration5 instanceof IrField) {
                irElement = IrFakeOverrideUtilsKt.resolveFakeOverride((IrField)declaration2);
            } else {
                if (!(irDeclaration5 instanceof IrProperty)) {
                    String string3 = "Unexpected fake override declaration";
                    boolean bl2 = false;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
                irElement = IrFakeOverrideUtilsKt.resolveFakeOverrideMaybeAbstract((IrProperty)declaration2);
            }
            irDeclaration3 = (IrDeclaration)irElement;
        } else {
            irDeclaration3 = realDeclaration = declaration2;
        }
        if (isAccessor) {
            IrDeclaration irDeclaration6 = realDeclaration;
            if (irDeclaration6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
            }
            IrProperty irProperty = ((IrSimpleFunction)irDeclaration6).getCorrespondingProperty();
            if (irProperty == null) {
                Intrinsics.throwNpe();
            }
            irDeclaration2 = irProperty;
        } else if (isBackingField) {
            IrDeclaration irDeclaration7 = realDeclaration;
            if (irDeclaration7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrField");
            }
            IrProperty irProperty = ((IrField)irDeclaration7).getCorrespondingProperty();
            if (irProperty == null) {
                Intrinsics.throwNpe();
            }
            irDeclaration2 = irProperty;
        } else {
            irDeclaration2 = discoverableDescriptorsDeclaration = isDefaultConstructor || isEnumEntry ? null : realDeclaration;
        }
        if (isTypeParameter) {
            IrElement irElement;
            IrDeclarationParent parent2 = declaration2.getParent();
            IrDeclarationParent irDeclarationParent = parent2;
            if (irDeclarationParent instanceof IrClass) {
                irElement = parent2;
            } else if (irDeclarationParent instanceof IrSimpleFunction) {
                Object object = ((IrSimpleFunction)parent2).getCorrespondingPropertySymbol();
                irElement = object != null && (object = (IrProperty)object.getOwner()) != null ? (IrElement)object : (IrElement)parent2;
            } else {
                if (!(irDeclarationParent instanceof IrConstructor)) {
                    String string4 = "unknown type parameter container type";
                    boolean bl3 = false;
                    throw (Throwable)new IllegalStateException(string4.toString());
                }
                irElement = parent2;
            }
            IrElement irElement2 = irElement;
            string2 = ((IrDeclarationWithName)irElement2).getDescriptor().getName().asString();
        } else {
            string2 = descriptor2.getName().toString();
        }
        Intrinsics.checkExpressionValueIsNotNull(string2, "if (isTypeParameter) {\n \u2026escriptor.name.toString()");
        String nameString = string2;
        IrDeclaration irDeclaration8 = discoverableDescriptorsDeclaration;
        if (irDeclaration8 != null) {
            IrDeclaration irDeclaration9 = irDeclaration8;
            boolean bl4 = false;
            bl = false;
            IrDeclaration irDeclaration10 = irDeclaration9;
            boolean bl5 = false;
            uniqId = this.declarationTable.uniqIdByDeclaration(irDeclaration10);
        } else {
            uniqId = null;
        }
        UniqId uniqId2 = uniqId;
        DescriptorReference.Builder builder = DescriptorReference.newBuilder().setPackageFqName(this.serializeFqName.invoke((org.jetbrains.kotlin.name.FqName)packageFqName)).setClassFqName(this.serializeFqName.invoke(classFqName)).setName(this.serializeString.invoke(nameString));
        if (uniqId2 != null) {
            builder.setUniqId(UniqIdKt.protoUniqId(uniqId2));
        }
        if (isFakeOverride) {
            builder.setIsFakeOverride(true);
        }
        if (isBackingField) {
            builder.setIsBackingField(true);
        }
        if (isAccessor) {
            if (AdditionalIrUtilsKt.isGetter(declaration2)) {
                builder.setIsGetter(true);
                return builder.build();
            }
            if (AdditionalIrUtilsKt.isSetter(declaration2)) {
                builder.setIsSetter(true);
                return builder.build();
            }
            String string5 = "A property accessor which is neither a getter, nor a setter: " + descriptor2;
            bl = false;
            throw (Throwable)new IllegalStateException(string5.toString());
        }
        if (isDefaultConstructor) {
            builder.setIsDefaultConstructor(true);
            return builder.build();
        }
        if (isEnumEntry) {
            builder.setIsEnumEntry(true);
            return builder.build();
        }
        if (isEnumSpecial) {
            builder.setIsEnumSpecial(true);
            return builder.build();
        }
        if (!isTypeParameter) return builder.build();
        builder.setIsTypeParameter(true);
        return builder.build();
    }

    @NotNull
    public final DeclarationTable getDeclarationTable() {
        return this.declarationTable;
    }

    @NotNull
    public final Function1<String, IrDataIndex> getSerializeString() {
        return this.serializeString;
    }

    @NotNull
    public final Function1<org.jetbrains.kotlin.name.FqName, FqName> getSerializeFqName() {
        return this.serializeFqName;
    }

    public DescriptorReferenceSerializer(@NotNull DeclarationTable declarationTable, @NotNull Function1<? super String, IrDataIndex> serializeString, @NotNull Function1<? super org.jetbrains.kotlin.name.FqName, FqName> serializeFqName) {
        Intrinsics.checkParameterIsNotNull(declarationTable, "declarationTable");
        Intrinsics.checkParameterIsNotNull(serializeString, "serializeString");
        Intrinsics.checkParameterIsNotNull(serializeFqName, "serializeFqName");
        this.declarationTable = declarationTable;
        this.serializeString = serializeString;
        this.serializeFqName = serializeFqName;
    }
}

