/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.runner;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.runner.AbstractRunner;
import org.jetbrains.kotlin.runner.RunnerException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014R\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/runner/JarRunner;", "Lorg/jetbrains/kotlin/runner/AbstractRunner;", "path", "", "(Ljava/lang/String;)V", "className", "getClassName", "()Ljava/lang/String;", "createClassLoader", "Ljava/lang/ClassLoader;", "classpath", "", "Ljava/net/URL;", "kotlin-runner"})
public final class JarRunner
extends AbstractRunner {
    @NotNull
    private final String className;
    private final String path;

    @Override
    @NotNull
    protected String getClassName() {
        return this.className;
    }

    @Override
    @NotNull
    protected ClassLoader createClassLoader(@NotNull List<URL> classpath) {
        Intrinsics.checkParameterIsNotNull(classpath, "classpath");
        return new URLClassLoader(new URL[]{new File(this.path).toURI().toURL()}, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public JarRunner(@NotNull String path) {
        String string;
        Intrinsics.checkParameterIsNotNull(path, "path");
        this.path = path;
        JarRunner jarRunner = this;
        try {
            String string2;
            JarRunner jarRunner2 = jarRunner;
            try (JarFile jar = new JarFile(this.path);){
                JarRunner jarRunner3 = jarRunner2;
                Manifest manifest = jar.getManifest();
                Intrinsics.checkExpressionValueIsNotNull(manifest, "jar.manifest");
                string2 = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            }
            string = string2;
        }
        catch (IOException iOException) {
            void e;
            JarRunner jarRunner4 = jarRunner;
            throw (Throwable)new RunnerException("could not read manifest from " + this.path + ": " + e.getMessage());
        }
        String string3 = string;
        if (string3 == null) {
            throw (Throwable)new RunnerException("no Main-Class entry found in manifest in " + this.path);
        }
        jarRunner3.className = string3;
    }
}

